/*
 * Decompiled with CFR 0.152.
 */
package base.composites;

import base.composites.BaseTableCompositeDataListener;
import base.controls.ExtendedTable;
import base.data.ColumnDef;
import base.data.RowConfigurator;
import ekspert.mobile.UtilsM;
import ekspert.mobile.common.UstawieniaOkna;
import ekspert.mobile.common.paleta.Paleta;
import ekspert.mobile.datamodel.MobileRecords;
import ekspert.mobile.gui.SwtCommon;
import ekspert.mobile.util.Matcher;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public abstract class BaseTableComposite
extends ExtendedTable {
    private static final int MULTI_ROW_1COL_WIDTH = 215;
    private MobileRecords dataSet;
    private BaseTableCompositeDataListener dataListener = new BaseTableCompositeDataListener(this);
    private int recreationCounter = 0;

    protected void checkSubclass() {
    }

    public BaseTableComposite(Composite parent, int style) {
        super(parent, style | 0x10000000);
        this.addListener(36, this.dataListener);
        if (this.hasMultiRowVersion()) {
            this.addMultiRowListeners();
            this.setLinesVisible(true);
            this.setHeaderVisible(false);
            this.getVerticalBar().setVisible(true);
        } else {
            this.setLinesVisible(true);
            this.setHeaderVisible(true);
        }
    }

    private void addMultiRowListeners() {
        this.addListener(41, new Listener(){
            private int minHi;
            private boolean minHiCalculated;

            public void handleEvent(Event event) {
                String[] itemData = BaseTableComposite.this.dataListener.getItemData((TableItem)event.item);
                GC gc = new GC((Drawable)BaseTableComposite.this);
                if (!this.minHiCalculated) {
                    this.minHi = gc.textExtent((String)"a\nb").y;
                    this.minHiCalculated = true;
                }
                Point size = gc.textExtent(UtilsM.ifNull(itemData[0]));
                gc.dispose();
                event.height = size.y < this.minHi ? this.minHi : size.y + 3;
                event.width = 215;
            }
        });
        this.addListener(40, new Listener(){

            public void handleEvent(Event event) {
                event.detail &= 0xFFFFFFEF;
            }
        });
        this.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                TableItem item = (TableItem)event.item;
                String text = item.getText(event.index);
                event.gc.drawText(text, event.x, event.y, true);
            }
        });
    }

    public void setFontSize(Integer fSize) {
        if (this.hasMultiRowVersion()) {
            SwtCommon.setConrolFontSize((Control)this, 8);
        } else if (fSize != null) {
            SwtCommon.setConrolFontSize((Control)this, fSize);
        }
    }

    public abstract ColumnDef[] getColumnsDef();

    public abstract String getPropertyFileName();

    public RowConfigurator getRowConfigurator() {
        return null;
    }

    public boolean hasMultiRowVersion() {
        return false;
    }

    public String getMultiRowFormat() {
        return null;
    }

    public MobileRecords getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(MobileRecords dataSet) {
        this.dataSet = dataSet;
        this.recreateColumns();
    }

    public void saveColumnSettings() {
        UstawieniaOkna.zapisz(this.getPropertyFileName(), (Table)this);
    }

    private void loadColumnSettings() {
        UstawieniaOkna.czytaj(this.getPropertyFileName(), (Table)this);
    }

    protected boolean restoresCurrentPosition() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recreateColumns() {
        int prevPosition = this.getSelectionIndex();
        if (!this.hasMultiRowVersion()) {
            if (this.recreationCounter > 0) {
                this.saveColumnSettings();
            }
            ++this.recreationCounter;
        }
        this.setRedraw(false);
        try {
            while (this.getColumnCount() > 0) {
                this.getColumns()[0].dispose();
            }
            this.removeAll();
            this.setItemCount(this.dataSet.getRecordCount());
            if (this.hasMultiRowVersion()) {
                TableColumn col = new TableColumn((Table)this, 16384);
                col.setWidth(215);
            } else {
                ColumnDef[] fieldDefs = this.getColumnsDef();
                for (int index = 0; index < fieldDefs.length; ++index) {
                    ColumnDef colDef = fieldDefs[index];
                    TableColumn col = new TableColumn((Table)this, colDef.getStyle());
                    col.setMoveable(colDef.isMovable());
                    String caption = colDef.getCaption();
                    if (caption != null) {
                        col.setText(caption);
                    }
                    col.setWidth(colDef.getSize());
                }
                TableColumn[] cols = this.getColumns();
                for (int index = 0; index < cols.length; ++index) {
                    if (!fieldDefs[index].isPackable()) continue;
                    cols[index].pack();
                }
                this.loadColumnSettings();
            }
            if (this.restoresCurrentPosition() && prevPosition > 0 && this.dataSet.getRecordCount() > 0) {
                if (prevPosition >= this.dataSet.getRecordCount()) {
                    this.setSelection(this.dataSet.getRecordCount() - 1);
                } else {
                    this.setSelection(prevPosition);
                }
            }
        }
        finally {
            this.setRedraw(true);
        }
    }

    public Object getSelectedRecord() {
        int index = this.getSelectionIndex();
        if (index < 0) {
            return null;
        }
        MobileRecords ds = this.getDataSet();
        if (ds == null) {
            return null;
        }
        return ds.getRecord(index);
    }

    public void removeRecord(Paleta paleta) {
        this.getDataSet().getManagedArray().removeItem(paleta);
        this.removeAll();
        this.setItemCount(this.getDataSet().getRecordCount());
        this.recreateColumns();
    }

    public Object getFirstMatched(Matcher matcher) {
        return this.getDataSet().getManagedArray().findFirstMatched(matcher);
    }
}

