/*
 * Decompiled with CFR 0.152.
 */
package base.composites;

import base.composites.BaseTableComposite;
import base.composites.MultiRowParser;
import base.data.ColumnDef;
import base.data.RowConfiguration;
import base.data.RowConfigurator;
import ekspert.mobile.UtilsM;
import ekspert.mobile.common.WordWrap2;
import ekspert.mobile.datamodel.MobileRecords;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;

public class BaseTableCompositeDataListener
implements Listener {
    private BaseTableComposite tableComposite;
    private static final String[] EMPTY_ARRAY = new String[]{""};
    private MultiRowParser parser;

    public BaseTableCompositeDataListener(BaseTableComposite tableComposite) {
        this.tableComposite = tableComposite;
    }

    public String[] getItemData(TableItem item) {
        int tableIndex = this.tableComposite.indexOf(item);
        if (!this.canDisplayTableIndexData(tableIndex)) {
            return EMPTY_ARRAY;
        }
        MobileRecords dataSet = this.tableComposite.getDataSet();
        ColumnDef[] columnDefs = this.tableComposite.getColumnsDef();
        int recordCount = dataSet.getRecordCount();
        if (tableIndex < 0 || tableIndex >= recordCount) {
            return EMPTY_ARRAY;
        }
        int columnsCount = columnDefs.length;
        if (this.tableComposite.hasMultiRowVersion()) {
            columnsCount = 1;
        }
        Object record = dataSet.getRecord(tableIndex);
        String[] resArray = new String[columnsCount];
        if (this.tableComposite.hasMultiRowVersion()) {
            String text = this.getMultiRowText(record);
            GC gc = new GC((Drawable)this.tableComposite);
            text = WordWrap2.wrap2(text, item.getTextBounds((int)0).width, gc);
            gc.dispose();
            resArray[0] = text;
        } else {
            for (int index = 0; index < resArray.length; ++index) {
                String itemData = columnDefs[index].getDataGetter().getData(record);
                if (itemData == null) {
                    itemData = "";
                }
                resArray[index] = itemData;
            }
        }
        return resArray;
    }

    public void handleEvent(Event event) {
        MobileRecords dataSet;
        Object record;
        RowConfiguration cfg;
        TableItem item = (TableItem)event.item;
        String[] dataArray = this.getItemData(item);
        int tableIndex = this.tableComposite.indexOf(item);
        RowConfigurator rowConfigurator = this.tableComposite.getRowConfigurator();
        if (rowConfigurator != null && this.canDisplayTableIndexData(tableIndex) && (cfg = rowConfigurator.getConfiguration(record = (dataSet = this.tableComposite.getDataSet()).getRecord(tableIndex))) != null) {
            Color foreground = cfg.getForeground(record);
            if (foreground != null) {
                item.setForeground(foreground);
            }
            cfg.customizeTableItem(this.tableComposite, item, record);
        }
        item.setText(dataArray);
    }

    private String getMultiRowText(Object record) {
        StringBuffer sb = new StringBuffer();
        String format = this.tableComposite.getMultiRowFormat();
        if (UtilsM.napisPustyLubTylkoSpacje(format)) {
            ColumnDef[] columnsDef = this.tableComposite.getColumnsDef();
            for (int index = 0; index < columnsDef.length; ++index) {
                String text = UtilsM.ifNull(columnsDef[index].getDataGetter().getData(record));
                if (index > 0) {
                    sb.append(" ");
                }
                sb.append(text);
            }
            return sb.toString();
        }
        MultiRowParser parser = this.getParser(format);
        return parser.getFormattedText(this.tableComposite.getColumnsDef(), record);
    }

    MultiRowParser getParser(String format) {
        if (this.parser != null) {
            return this.parser;
        }
        this.parser = new MultiRowParser(format);
        return this.parser;
    }

    private boolean canDisplayTableIndexData(int tableIndex) {
        MobileRecords dataSet = this.tableComposite.getDataSet();
        if (dataSet == null) {
            return false;
        }
        if (this.tableComposite.getColumnsDef() == null) {
            return false;
        }
        int recordCount = dataSet.getRecordCount();
        return tableIndex >= 0 && tableIndex < recordCount;
    }
}

