/*
 * Decompiled with CFR 0.152.
 */
package base.composites;

import base.composites.MultiRowSection;
import base.data.ColumnDef;
import base.data.StringDataGetter;
import ekspert.mobile.MultiRowCode;
import ekspert.mobile.UtilsM;
import java.util.ArrayList;

public class MultiRowParser {
    public static final char START = '{';
    public static final char END = '}';
    private ArrayList sections = new ArrayList();

    public MultiRowParser(String format) {
        this.prepare(format);
    }

    private void prepare(String format) {
        if (UtilsM.napisPustyLubTylkoSpacje(format)) {
            return;
        }
        int currentStart = 0;
        while (currentStart < format.length()) {
            int endPos;
            int startPos = format.indexOf(123, currentStart);
            if (startPos < 0) {
                this.sections.add(new MultiRowSection(format.substring(currentStart, format.length())));
                break;
            }
            if (startPos - currentStart > 0) {
                this.sections.add(new MultiRowSection(format.substring(currentStart, startPos)));
                currentStart = startPos;
            }
            if ((endPos = format.indexOf(125, currentStart + 1)) < 0) {
                this.sections.add(new MultiRowSection(format.substring(currentStart, format.length())));
                break;
            }
            MultiRowSection section = new MultiRowSection(format.substring(startPos + 1, endPos));
            section.setSectionNameFlag();
            this.sections.add(section);
            currentStart = endPos + 1;
        }
    }

    public String getFormattedText(ColumnDef[] columnsDef, Object record) {
        StringBuffer b = new StringBuffer();
        for (int index = 0; index < this.sections.size(); ++index) {
            MultiRowSection section = (MultiRowSection)this.sections.get(index);
            if (section.isSectionName()) {
                String data;
                StringDataGetter dataGetter;
                if (section.isEnter()) {
                    b.append("\n");
                    continue;
                }
                String sectionName = section.getSectionDesc();
                ColumnDef col = this.findColumnDefWithMultiRowCode(columnsDef, sectionName);
                if (col == null || (dataGetter = col.getDataGetter()) == null || (data = dataGetter.getData(record)) == null) continue;
                b.append(data);
                continue;
            }
            b.append(section.getSectionDesc());
        }
        return b.toString();
    }

    private ColumnDef findColumnDefWithMultiRowCode(ColumnDef[] columnsDef, String sectionCode) {
        for (int index = 0; index < columnsDef.length; ++index) {
            ColumnDef col = columnsDef[index];
            MultiRowCode multiRowCode = col.getMultiRowCode();
            if (multiRowCode == null || !sectionCode.equalsIgnoreCase(multiRowCode.getCode())) continue;
            return col;
        }
        return null;
    }
}

