/*
 * Decompiled with CFR 0.152.
 */
package ekspert.mobile;

import ekspert.mobile.UtilsM;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class JustOneServer
extends Thread {
    public static final int PORT = 1810;
    ServerSocket serverSocket = null;
    private boolean shutdownRequested = false;
    private Object shutdownDone = new Object();
    Shell mainShell;

    public void setShell(Shell mainShell) {
        this.mainShell = mainShell;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.serverSocket = new ServerSocket(1810, 1);
            System.out.println("serverSocket " + this.serverSocket);
            if (this.serverSocket == null) {
                System.out.println("socket null!!!");
                throw new Exception();
            }
            while (true) {
                Socket clientSocket = this.serverSocket.accept();
                if (this.shutdownRequested) {
                    UtilsM.log("JustOneServer shutdown requested...");
                    clientSocket.close();
                    this.serverSocket.close();
                    Object object = this.shutdownDone;
                    synchronized (object) {
                        this.shutdownDone.notifyAll();
                    }
                    return;
                }
                UtilsM.log("*** Got a connection!");
                BufferedReader in = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
                String inData = in.readLine();
                System.out.println("*** Got input! '" + inData + "'");
                PrintWriter out = new PrintWriter(clientSocket.getOutputStream(), true);
                if (inData.equals("Hello MO")) {
                    System.out.println("*** input valid!");
                    out.println(inData);
                    out.flush();
                    this.activateWindow();
                } else {
                    out.println("ERR invalid hello");
                    out.flush();
                }
                clientSocket.close();
            }
        }
        catch (Exception ioe) {
            UtilsM.logE("Error in JustOneServer: " + ioe);
            System.err.println(this.mainShell);
            if (this.mainShell != null && !this.mainShell.isDisposed()) {
                this.mainShell.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        String msg = "blad JustOneServer - program jest juz uruchomiony, ale moze nie odpowiadac, koncze.\nZamknij wszystkie procesy i/lub zrestartuj urzadzenie";
                        MessageBox messageBox = new MessageBox(JustOneServer.this.mainShell, 33);
                        messageBox.setMessage(msg);
                        messageBox.setText("blad");
                        messageBox.open();
                    }
                });
            }
            System.exit(15);
            return;
        }
    }

    private void activateWindow() {
        if (this.mainShell != null) {
            UtilsM.log("Activate window ");
            this.mainShell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    JustOneServer.this.mainShell.setVisible(true);
                    JustOneServer.this.mainShell.moveAbove(null);
                    JustOneServer.this.mainShell.forceActive();
                    JustOneServer.this.mainShell.setFocus();
                    JustOneServer.this.mainShell.forceFocus();
                    JustOneServer.this.mainShell.open();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.shutdownRequested = true;
        if (this.serverSocket == null) {
            return;
        }
        try {
            System.out.println("shutting down JustOneServer ...");
            Object object = this.shutdownDone;
            synchronized (object) {
                new Socket(this.serverSocket.getInetAddress(), this.serverSocket.getLocalPort()).close();
                this.shutdownDone.wait();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("blad zamykania IO");
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            System.out.println("blad zamykania interrupt");
        }
    }
}

