/*
 * Decompiled with CFR 0.152.
 */
package ekspert.mobile;

import ekspert.mobile.gui.SwtCommon;
import ekspert.mobile.gui.TomcatConfigCD;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.swt.widgets.Shell;

public class LocalConfig {
    public static final String PROP_URL = "URL";
    public static final String PROP_USER = "defUser";
    public static final String PROP_PASS = "defPass";
    public static final String PROP_DEBUG = "debug";
    public static final String PROP_TRACE = "trace";
    public static final String PROP_FONT = "font";
    public static final String PROP_SCIEZKA = "sciezka";
    private String defaultUrl;
    private File propsFile = null;
    private Shell mainShell = null;
    public Properties p = null;
    private String opis;

    public LocalConfig(File propsFile, Shell mainShell, String opis2) {
        this.propsFile = propsFile;
        this.mainShell = mainShell;
        this.opis = opis2;
    }

    public void czytajConfig(String defaultUrl) {
        this.defaultUrl = defaultUrl;
        this.czytajConfig();
    }

    private void czytajConfig() {
        IOException ee = null;
        try {
            this.p = new Properties();
            this.p.load(new FileInputStream(this.propsFile));
            return;
        }
        catch (FileNotFoundException e) {
            ee = e;
        }
        catch (IOException e) {
            ee = e;
        }
        SwtCommon.alert(this.mainShell, "blad ladowania konfiguracji: " + ee);
        this.konfigurujTomcat(true, null);
    }

    public boolean zapiszConfig() {
        IOException ee = null;
        try {
            this.p.store(new FileOutputStream(this.propsFile), "Konfiguracja " + this.opis);
            return true;
        }
        catch (FileNotFoundException e) {
            ee = e;
        }
        catch (IOException e) {
            ee = e;
        }
        SwtCommon.alert(this.mainShell, "blad zapisu konfiguracji: " + ee);
        return false;
    }

    public boolean konfigurujTomcat(boolean exitOnNull, String lastURL) {
        if (lastURL == null) {
            lastURL = this.defaultUrl;
        }
        String nowyURL = TomcatConfigCD.run(this.mainShell, null, lastURL);
        if (exitOnNull && nowyURL == null) {
            if (!this.mainShell.isDisposed()) {
                SwtCommon.alert(this.mainShell, "nie mam adresu serwera, prosz\u0119 uruchomi\u0107 program ponownie!");
            }
            System.exit(5);
        }
        if (nowyURL == null) {
            return false;
        }
        this.p.put(PROP_URL, nowyURL);
        return this.zapiszConfig();
    }

    public Integer getLocalFontSize() {
        Integer fSize = null;
        String fontStr = this.p.getProperty(PROP_FONT);
        if (fontStr != null && fontStr.length() > 0) {
            try {
                fSize = new Integer(fontStr);
            }
            catch (NumberFormatException e) {
                System.out.println("nieprawidlowy rozmiar fontu: " + fontStr);
            }
        }
        return fSize;
    }
}

