/*
 * Decompiled with CFR 0.152.
 */
package ekspert.mobile;

import base.controls.ControlFactory;
import ekspert.mobile.Actions;
import ekspert.mobile.BuildInfo2;
import ekspert.mobile.Common;
import ekspert.mobile.ContC;
import ekspert.mobile.Http401Exc;
import ekspert.mobile.LocalConfig;
import ekspert.mobile.Main;
import ekspert.mobile.MenuC;
import ekspert.mobile.Sciezka;
import ekspert.mobile.UtilsM;
import ekspert.mobile.common.ExitMnuExc;
import ekspert.mobile.common.LocalConnectLogin;
import ekspert.mobile.common.MagClientConfig;
import ekspert.mobile.common.MagIF;
import ekspert.mobile.common.WyborBazyC;
import ekspert.mobile.gui.SwtCommon;
import ekspert.mobile.mnu.MainMnu;
import java.io.File;
import java.util.Stack;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class MainSWT2
extends Composite {
    static MainSWT2 inst;
    private boolean moge_wyjsc = false;
    LocalConfig localConf = null;
    private Stack biezacaSciezka;
    boolean forceLogin = false;
    private static ShellAdapter closeAd;
    private static Shell shell;
    public ContC containerCo;
    private Label keyboard;
    private Label logoLabel;
    private Button menuBtn;
    SelectionAdapter selAd = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent evt) {
            if (evt.getSource().equals(MainSWT2.this.menuBtn)) {
                MainSWT2.this.menuBtnWS();
            }
        }
    };

    public MainSWT2(Composite parent, int style) {
        super(parent, style);
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setLayout(null);
            this.keyboard = ControlFactory.createLabel(this, 0);
            this.keyboard.setText("          ");
            this.keyboard.setBounds(95, 240, 30, 25);
            this.logoLabel = ControlFactory.createLabel(this, 0);
            this.logoLabel.setText(" ");
            this.logoLabel.setBounds(2, 243, 85, 18);
            this.containerCo = new ContC(this, 0);
            this.containerCo.setLayout(null);
            this.containerCo.setBounds(0, 0, Main.shellWidth, Main.containerHeight);
            this.menuBtn = new Button((Composite)this, 0x1000008);
            this.menuBtn.setText("Menu  ...");
            this.menuBtn.setBounds(178, 240, 57, 25);
            this.menuBtn.addSelectionListener((SelectionListener)this.selAd);
            this.layout();
            this.setSize(Main.shellWidth, Main.shellHeight);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void mainUI2() {
        try {
            MainSWT2.mainUI();
        }
        catch (Throwable e) {
            e.printStackTrace();
            if (shell == null || shell.isDisposed()) {
                shell = new Shell();
            }
            SwtCommon.alert(shell, "nieoczekiwany blad:\n" + e.getMessage());
        }
    }

    private static void mainUI() {
        System.out.println("swt v " + SWT.getVersion() + " " + SWT.getPlatform());
        Display display = Display.getDefault();
        System.out.println("ekran: " + display.getClientArea() + " dpi " + display.getDPI());
        System.out.println("Main:shellWidth, shellHeight: " + Main.shellWidth + " " + Main.shellHeight);
        System.out.println("-------------------");
        shell = Main.getShell();
        if (Main.just != null) {
            Main.just.sds.setShell(shell);
        }
        inst = new MainSWT2((Composite)shell, 0);
        if (!Main.isMobile) {
            Point p = inst.getSize();
            Point res = shell.computeSize(p.x, p.y);
            System.out.println("p:" + p + " res:" + res);
            shell.setSize(res);
        }
        shell.layout();
        closeAd = new ShellAdapter(){

            public void shellClosed(ShellEvent evt) {
                inst.onAppClose(evt);
            }
        };
        shell.addShellListener((ShellListener)closeAd);
        inst.przedPokazaniem();
        shell.open();
        inst.naStarcie();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private void przedPokazaniem() {
        Shell shell = this.getShell();
        Display display = shell.getDisplay();
        Image logo = new Image((Device)display, SwtCommon.class.getResourceAsStream("ekspert_logo2_85.png"));
        this.logoLabel.setBackground(this.getBackground());
        this.logoLabel.setImage(logo);
        if (Main.isMobile) {
            SwtCommon.fixWinCE(this);
        }
        shell.setText("Magazyn (rev " + BuildInfo2.revisionNumber + ")");
    }

    private void naStarcie() {
        this.localConf = new LocalConfig(new File(Main.currentDir, "setup.txt"), this.getShell(), "MO");
        this.localConf.czytajConfig("http://localhost:8080/Magazyn/");
        Actions.setDefaultContainer(this.containerCo);
        while (true) {
            Common.setLcl(new LocalConnectLogin(this.containerCo, this.localConf));
            Common.getLcl().polaczony();
            MagIF MAG = Common.getLcl().polaczNewClient();
            Common.getLcl().wyslijPliki();
            Common.getLcl().aktualizujStarter();
            Common.getLcl().aktualizujBiblioteki();
            Common.setMAG(MAG);
            try {
                this.zalogujDoBazy();
                if (this.isDisposed()) {
                    return;
                }
                MagClientConfig conf = this.getConfig(MAG);
                if (this.isDisposed()) {
                    return;
                }
                MainMnu mainMnu = new MainMnu(conf.maska, conf.ver);
                Sciezka odtwarzanaSciezka = this.getSciezka();
                mainMnu.runMnu(odtwarzanaSciezka);
                if (!this.isDisposed()) continue;
                return;
            }
            catch (Http401Exc e) {
                if (this.moge_wyjsc) {
                    return;
                }
                System.err.println(e);
                if (e instanceof ExitMnuExc) {
                    this.rozlacz();
                } else {
                    SwtCommon.alert(this.getShell(), "Sesja wygas\u0142a!\n\nkonieczne ponowne logowanie!");
                }
                Common.reset();
                Runtime rt = Runtime.getRuntime();
                rt.gc();
                continue;
            }
            break;
        }
    }

    private Sciezka getSciezka() {
        String odtwarzanaSciezka = this.localConf.p.getProperty("sciezka");
        if (odtwarzanaSciezka == null) {
            odtwarzanaSciezka = "";
        }
        System.out.println("sciezka: " + odtwarzanaSciezka);
        this.biezacaSciezka = new Stack();
        return new Sciezka(odtwarzanaSciezka);
    }

    private MagClientConfig getConfig(MagIF MAG) {
        MagClientConfig conf = MAG.getClientConfig();
        if (conf == null) {
            SwtCommon.alert(this.getShell(), "b\u0142\u0105d pobierania konfiguracji!!!");
            this.rozlacz();
            this.moge_wyjsc = true;
            this.getShell().close();
            return null;
        }
        Common.magClientConf = conf;
        if (Common.getLcl().zalUser.equals("s+")) {
            Common.zmienMagazynRoboczy(this.containerCo, MAG);
        }
        UtilsM.setIloscPoz(conf.ileMiejsc);
        return conf;
    }

    void zalogujDoBazy() {
        Common.bazaRobocza = this.wybierzBaze();
        if (this.isDisposed()) {
            return;
        }
        Common.getLcl().zaloguj(Common.bazaRobocza, this.forceLogin);
        Common.zalogowanyUser = Common.getLcl().zalUserF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String wybierzBaze() {
        String[] bazy = Common.getMAG().pobierzBazy();
        if (bazy == null) {
            this.dispose();
            return null;
        }
        if (bazy.length == 1) {
            return bazy[0];
        }
        WyborBazyC dlg = new WyborBazyC(this.containerCo);
        try {
            String string = dlg.wybierzBaze(bazy);
            return string;
        }
        finally {
            SwtCommon.safeDispose(dlg);
        }
    }

    protected void koniecBtnWS() {
        int ret = SwtCommon.confirm(this.getShell(), "Czy chcesz zakonczy\u0107?");
        if (ret == 64) {
            this.moge_wyjsc = true;
            if (Common.getLcl() != null && Common.getLcl().polaczony) {
                this.rozlacz();
            }
            this.getShell().close();
        }
    }

    private void rozlacz() {
        Common.getLcl().magFactory.getClient().setLastConn();
        try {
            Common.getMAG().rozlacz();
        }
        catch (Http401Exc e) {
            System.out.println("401 na wyjsciu, olal");
        }
    }

    protected void menuBtnWS() {
        SwtCommon.ustawDzieciParentaEnabled(this.containerCo, false);
        this.containerCo.setVisible(false);
        MenuC md = new MenuC(this);
        int result = md.open(this.localConf, Common.magClientConf, this.biezacaSciezka);
        if (result == 1) {
            this.koniecBtnWS();
        } else if (result == 2) {
            this.zalogujDoBazy();
        }
        if (this.isDisposed()) {
            return;
        }
        this.containerCo.setVisible(true);
        SwtCommon.ustawDzieciParentaEnabled(this.containerCo, true);
    }

    protected void onAppClose(ShellEvent evt) {
        if (!this.moge_wyjsc) {
            this.koniecBtnWS();
            if (!this.moge_wyjsc) {
                evt.doit = false;
            }
        }
    }
}

