/*
 * Decompiled with CFR 0.152.
 */
package ekspert.mobile;

import java.io.File;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;

public class MobileUtils {
    public static Exception handleUndeclaredThrowable(Exception e) {
        if (e instanceof UndeclaredThrowableException) {
            UndeclaredThrowableException e2 = (UndeclaredThrowableException)e;
            e = (Exception)e2.getUndeclaredThrowable();
        }
        return e;
    }

    public static String[] splitPreserveAllTokens(String str, char separatorChar) {
        return MobileUtils.splitWorker(str, separatorChar, true);
    }

    static String[] splitWorker(String str, char separatorChar, boolean preserveAllTokens) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int start = 0;
        boolean match = false;
        boolean lastMatch = false;
        while (i < len) {
            if (str.charAt(i) == separatorChar) {
                if (match || preserveAllTokens) {
                    list.add(str.substring(start, i));
                    match = false;
                    lastMatch = true;
                }
                start = ++i;
                continue;
            }
            lastMatch = false;
            match = true;
            ++i;
        }
        if (match || preserveAllTokens && lastMatch) {
            list.add(str.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }

    public static String mobileGetJarLocation(Class cls) {
        String currentDir = new File(cls.getProtectionDomain().getCodeSource().getLocation().getFile()).getAbsolutePath();
        if (currentDir.endsWith("jar")) {
            currentDir = currentDir.substring(0, currentDir.lastIndexOf(File.separatorChar));
        } else if (currentDir.endsWith("bin")) {
            currentDir = currentDir.substring(0, currentDir.lastIndexOf(File.separatorChar));
        } else if (currentDir.endsWith("target\\classes")) {
            currentDir = currentDir.substring(0, currentDir.length() - "target\\classes".length());
        }
        return currentDir;
    }
}

