/*
 * Decompiled with CFR 0.152.
 */
package ekspert.mobile;

import ekspert.mobile.gui.ProgressC;
import ekspert.mobile.gui.SwtCmm;
import ekspert.mobile.util.BufferedInteger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class UtilsM {
    public static final double DELTA_2_DIGITS = 1.0E-4;
    public static final double DELTA_3_DIGITS = 1.0E-5;
    public static SimpleDateFormat sdf_ymd = UtilsM.getSimpleDateFormat("yyyy-MM-dd");
    public static SimpleDateFormat sdf_hms = UtilsM.getSimpleDateFormat("HH:mm:ss");
    public static SimpleDateFormat sdf_ymdhms = UtilsM.getSimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static SimpleDateFormat sdf_log = UtilsM.getSimpleDateFormat("HH:mm:ss.SSS");
    public static SimpleDateFormat sdf_mdhms_file = UtilsM.getSimpleDateFormat("MMdd_HHmmss");
    private static final NumberFormat df = new DecimalFormat("########0.00");
    private static NumberFormat dfIlosc = new DecimalFormat("########0.00");
    private static final NumberFormat df_liczba = new DecimalFormat("#########.##");
    private static final int BUF_SIZE = 16384;
    private static BufferedInteger bufferedInteger = new BufferedInteger();

    public static String sUB(String aStr, int aLen) {
        if (aStr == null) {
            return "";
        }
        if (aStr.length() <= aLen) {
            return aStr;
        }
        return aStr.substring(0, aLen);
    }

    public static boolean czyTeSameNapisy(String s1, String s2) {
        if (s1 == null && s2 != null) {
            return false;
        }
        if (s2 == null && s1 != null) {
            return false;
        }
        if (s1 == null && s2 == null) {
            return true;
        }
        return s1.equalsIgnoreCase(s2);
    }

    public static boolean napisPustyLubTylkoSpacje(String str) {
        if (str == null) {
            return true;
        }
        return "".equals(str.trim());
    }

    public static void log(Object obj) {
        System.out.println(sdf_log.format(new Date()) + " " + obj);
    }

    public static void logE(Object obj) {
        System.err.println(sdf_log.format(new Date()) + " " + obj);
    }

    public static void showMemInfo() {
        Runtime rt = Runtime.getRuntime();
        System.out.println("MEM  used?: " + (rt.totalMemory() - rt.freeMemory()) + " free: " + rt.freeMemory() + " max:  " + rt.maxMemory() + " totalMemory:" + rt.totalMemory());
    }

    public static void setIloscPoz(int ile) {
        switch (ile) {
            case 4: {
                dfIlosc = new DecimalFormat("########0.0000");
                break;
            }
            case 3: {
                dfIlosc = new DecimalFormat("########0.000");
                break;
            }
            case 2: {
                dfIlosc = new DecimalFormat("########0.00");
                break;
            }
            case 1: {
                dfIlosc = new DecimalFormat("########0.0");
                break;
            }
            case 0: {
                dfIlosc = new DecimalFormat("########0");
                break;
            }
            default: {
                throw new NumberFormatException("nieobslugiwana ilosc miejsc po przecinku: " + ile);
            }
        }
    }

    public static SimpleDateFormat getSimpleDateFormat(String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        sdf.setLenient(false);
        return sdf;
    }

    public static String formatDoubleIlosc(double wartosc) {
        return dfIlosc.format(wartosc).replace(',', '.');
    }

    public static String formatDouble(double wartosc) {
        return df.format(wartosc).replace(',', '.');
    }

    public static String formatDoublePrzec(double wartosc) {
        return df.format(wartosc);
    }

    public static String formatLiczba(double wartosc) {
        return df_liczba.format(wartosc).replace(',', '.');
    }

    public static String formatLiczba(double wartosc, String jednostka) {
        String res = df_liczba.format(wartosc).replace(',', '.');
        if (jednostka != null && jednostka.length() > 0) {
            res = res + " " + jednostka;
        }
        return res;
    }

    public static String fillString(char c, int length) {
        if (length <= 0) {
            return "";
        }
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = c;
        }
        return new String(chars);
    }

    public static String ifNull(String wartosc) {
        return wartosc == null ? "" : wartosc;
    }

    public static String tyleZnakow(String numer, int tyle) {
        numer = numer + "                         ";
        numer = numer.substring(0, tyle);
        return numer;
    }

    public static boolean objInArr(Object str, Object[] arr) {
        if (arr == null) {
            return false;
        }
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] == null || !arr[i].equals(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean intInArr(int str, int[] arr) {
        if (arr == null) {
            return false;
        }
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] != str) continue;
            return true;
        }
        return false;
    }

    public static String intArr2Str2(int[] arr) {
        if (arr == null) {
            return "";
        }
        if (arr.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            sb.append(arr[i]);
            sb.append(", ");
        }
        return sb.substring(0, sb.length() - 2);
    }

    public static int[] strArr2intArr(String[] cz) {
        int[] idki = new int[cz.length];
        for (int i = 0; i < cz.length; ++i) {
            idki[i] = Integer.parseInt(cz[i].trim());
        }
        return idki;
    }

    public static int indArrObj(Object[] objs, Object obj) {
        if (objs == null) {
            return -1;
        }
        for (int i = 0; i < objs.length; ++i) {
            if (!objs[i].equals(obj)) continue;
            return i;
        }
        return -1;
    }

    public static int indeksWartosciWarrayStr(String[] tabela, String wartosc) {
        if (tabela == null) {
            return -1;
        }
        for (int i = 0; i < tabela.length; ++i) {
            if (!tabela[i].equals(wartosc)) continue;
            return i;
        }
        return -1;
    }

    public static void printObjArr(Object[] arr) {
        System.out.println(UtilsM.objArr2Str(arr));
    }

    public static String objArr2Str(Object[] arr) {
        if (arr == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        for (int i = 0; i < arr.length; ++i) {
            sb.append(arr[i].toString() + ", ");
        }
        sb.append("]");
        return sb.toString();
    }

    public static String[] objArr2stringArr(Object[] resultArr) {
        if (resultArr == null) {
            return null;
        }
        String[] result = new String[resultArr.length];
        for (int i = 0; i < resultArr.length; ++i) {
            result[i] = (String)resultArr[i];
        }
        return result;
    }

    public static Object[] arrayAppend(Object[] pozycje, Object newPoz) {
        Object[] ret = new Object[pozycje.length + 1];
        for (int i = 0; i < pozycje.length; ++i) {
            ret[i] = pozycje[i];
        }
        ret[pozycje.length] = newPoz;
        return ret;
    }

    public static Object[] arrayDelete(Object[] pozycje, Object toDel) {
        if (toDel == null) {
            return pozycje;
        }
        int ind = -1;
        for (int i = 0; i < pozycje.length; ++i) {
            if (!toDel.equals(pozycje[i])) continue;
            ind = i;
            break;
        }
        if (ind == -1) {
            return pozycje;
        }
        Object[] ret = new Object[pozycje.length - 1];
        int j = 0;
        for (int i = 0; i < pozycje.length; ++i) {
            if (i == ind) continue;
            ret[j++] = pozycje[i];
        }
        return ret;
    }

    public static String getIpHostname() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            return addr.getHostName() + " " + addr.getHostAddress();
        }
        catch (UnknownHostException e) {
            return "blad pobierania lokalnego adresu";
        }
    }

    public static String getHostName() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            return addr.getHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return "mobile";
        }
    }

    public static void sleep(int i) {
        try {
            Thread.sleep(i);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static boolean pobierzPlik(String remoteUrl, String localFileName, Composite shell, String connAuthData) {
        if (remoteUrl == null) {
            return false;
        }
        ProgressC p = null;
        if (shell != null) {
            p = ProgressC.showProgress(shell, "pobieranie pliku " + remoteUrl + "...");
        }
        System.out.println("pobieram " + remoteUrl);
        File fTmp = new File(localFileName + ".tmp");
        try {
            int bytes;
            HttpConnection con = (HttpConnection)Connector.open((String)remoteUrl, (int)1, (boolean)true);
            con.setRequestMethod("GET");
            con.setRequestProperty("Authorization", connAuthData);
            InputStream is = con.openInputStream();
            int responseCode = con.getResponseCode();
            System.out.println(con.getResponseCode());
            if (responseCode != 200) {
                if (shell != null) {
                    SwtCmm.alert("blad pobierania " + remoteUrl + ": " + responseCode);
                }
                System.out.println("blad pobierania " + remoteUrl + ": " + responseCode);
                if (p != null) {
                    p.dispose();
                }
                return false;
            }
            if (p != null) {
                p.setMessage("status 200");
            }
            FileOutputStream outputStream = new FileOutputStream(fTmp);
            System.out.println("zapisuje do " + fTmp.getAbsolutePath());
            long totBytes = con.getLength();
            byte[] buffer = new byte[16384];
            int sumBytes = 0;
            while ((bytes = is.read(buffer)) > 0) {
                outputStream.write(buffer, 0, bytes);
                String msg = (sumBytes += bytes) + " z " + totBytes + "  " + UtilsM.formatDouble((double)sumBytes / (double)totBytes * 100.0) + "%";
                if (p != null) {
                    p.setMessage(msg);
                    continue;
                }
                System.out.println(msg);
            }
            outputStream.close();
            con.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            if (shell != null) {
                SwtCmm.alert("blad pobierania:\n" + e.getMessage());
            } else {
                System.out.println("blad pobierania:\n" + e.getMessage());
            }
            return false;
        }
        if (p != null) {
            p.setMessage("100%");
            UtilsM.sleep(1000);
            p.dispose();
        } else {
            System.out.println("koniec");
        }
        return true;
    }

    public static boolean podmienTmp(String filePath, Shell shell) {
        File fTmp;
        boolean isOk;
        File f_dest;
        File f_old = new File(filePath + ".old");
        if (f_old.exists()) {
            System.out.println("usuwam stary " + f_old.getAbsolutePath());
            boolean deleteOk = f_old.delete();
            if (!deleteOk) {
                System.out.println("blad usuwania starego " + f_old.getAbsolutePath());
                if (shell != null) {
                    SwtCmm.alert("blad usuwania starego " + f_old.getAbsolutePath());
                }
                return false;
            }
        }
        if ((f_dest = new File(filePath)).exists()) {
            System.out.println("biezacy zamieniam na old");
            boolean isOk2 = f_dest.renameTo(f_old);
            if (!isOk2) {
                System.out.println("blad zamiany na old " + f_old);
                if (shell != null) {
                    SwtCmm.alert("blad zamiany na old " + f_old);
                }
                return false;
            }
        }
        if (!(isOk = (fTmp = new File(filePath + ".tmp")).renameTo(f_dest))) {
            System.out.println("Blad podmiany pliku " + f_dest.getAbsolutePath());
            if (shell != null) {
                SwtCmm.alert("Blad podmiany pliku " + f_dest.getAbsolutePath());
            }
            return false;
        }
        return true;
    }

    public Integer getInteger(int value) {
        return bufferedInteger.getInteger(value);
    }

    public static boolean hasFlag(int value, int flag) {
        return (value & flag) > 0;
    }

    public static int setFlag(int value, int flag, boolean cnd) {
        value = cnd ? (value |= flag) : (value &= ~flag);
        return value;
    }

    public static boolean eq2Digits(double value1, double value2) {
        double diff = value1 - value2;
        if (diff < 0.0) {
            diff = -diff;
        }
        return diff < 1.0E-4;
    }

    public static boolean eq3Digits(double value1, double value2) {
        double diff = value1 - value2;
        if (diff < 0.0) {
            diff = -diff;
        }
        return diff < 1.0E-5;
    }
}

