/*
 * Decompiled with CFR 0.152.
 */
package ekspert.mobile.common;

import ekspert.mobile.UtilsM;
import ekspert.mobile.common.KodEan128Result;
import ekspert.mobile.common.obj.KodEtykiet;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class KodEan128Parser {
    private KodEtykiet[] kodyEtykiet;
    SimpleDateFormat sdf = UtilsM.getSimpleDateFormat("yyMMdd");

    public KodEan128Parser(KodEtykiet[] kody) {
        if (kody == null) {
            return;
        }
        System.out.print("kodyEtykiet: ");
        UtilsM.printObjArr(kody);
        this.kodyEtykiet = kody;
        for (int i = 0; i < kody.length; ++i) {
            kody[i].prepare();
        }
    }

    public KodEan128Result parsuj(String wpisano) {
        if (this.kodyEtykiet == null) {
            return null;
        }
        for (int i = 0; i < this.kodyEtykiet.length; ++i) {
            if (wpisano.length() != this.kodyEtykiet[i].dlugosc) continue;
            KodEtykiet k = this.kodyEtykiet[i];
            KodEan128Result result = new KodEan128Result();
            if (k.startE > -1) {
                if (!wpisano.substring(k.startE, k.startE + 2).equals("01")) continue;
                result.eanTowaru = wpisano.substring(k.startE + 3, k.startE + 16).trim();
            }
            if (k.startP > -1) {
                if (!wpisano.substring(k.startP, k.startP + 2).equals("10")) continue;
                result.partia = wpisano.substring(k.startP + 2, k.startP + 2 + k.dlugoscP).trim();
            }
            if (k.startD > -1) {
                if (!wpisano.substring(k.startD, k.startD + 2).equals("17")) continue;
                String dataS = wpisano.substring(k.startD + 2, k.startD + 2 + 6);
                try {
                    result.data = this.sdf.parse(dataS);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                    result.data = null;
                }
            }
            if (k.startI > -1) {
                if (!wpisano.substring(k.startI, k.startI + 2).equals("37")) continue;
                String iloscS = wpisano.substring(k.startI + 2, k.startI + 2 + k.dlugoscI).trim();
                try {
                    result.ilosc_na_pal = Double.parseDouble(iloscS);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    result.ilosc_na_pal = 0.0;
                }
            }
            result.nazwaWzorca = k.nazwa;
            return result;
        }
        return null;
    }
}

