/*
 * Decompiled with CFR 0.152.
 */
package ekspert.mobile.common;

import base.composites.BaseTableComposite;
import base.controls.ControlFactory;
import base.controls.ExtendedTable;
import base.controls.ExtendedTableCallback;
import base.data.ColumnDef;
import base.data.RowConfigurator;
import ekspert.mobile.Common;
import ekspert.mobile.ContC;
import ekspert.mobile.Main;
import ekspert.mobile.UtilsM;
import ekspert.mobile.common.DialogParams;
import ekspert.mobile.common.KodEan128Result;
import ekspert.mobile.common.MagClientConfig;
import ekspert.mobile.common.MenuPozycjeWiecejCD;
import ekspert.mobile.common.obj.CechaDokkM;
import ekspert.mobile.common.obj.Dostawa;
import ekspert.mobile.common.obj.OpakKartM;
import ekspert.mobile.common.obj.Towar;
import ekspert.mobile.common.obj.TowarSzukanie;
import ekspert.mobile.common.przeglady.ButtonWithOuzPozM;
import ekspert.mobile.common.przeglady.PrzegladyUtils;
import ekspert.mobile.common.spr.SprClientConfig;
import ekspert.mobile.common.spr.SprIF;
import ekspert.mobile.common.wpr.MagS;
import ekspert.mobile.common.wpr.OUZpozM;
import ekspert.mobile.common.wpr.WprClientConfig;
import ekspert.mobile.datamodel.ManagedArray;
import ekspert.mobile.datamodel.MobileRecords;
import ekspert.mobile.dod.MainDOD;
import ekspert.mobile.gui.CompositeDialog;
import ekspert.mobile.gui.SwtCommon;
import ekspert.mobile.wpr.PozUwagiCechyC;
import java.util.ArrayList;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class PozycjeCNewer
extends CompositeDialog {
    private Label l1;
    protected Label labelEan;
    private Composite composite1;
    protected Button wiecejBtn;
    protected Button przerwijBtn;
    protected Button wpisBtn;
    protected Label dokInfo;
    private Composite cTop;
    protected Button zatwierdzBtn;
    protected Text skanujTxt;
    private Composite c2;
    protected ArrayList tableExtraEditors = new ArrayList();
    protected ArrayList tableExtraControls = new ArrayList();
    protected static final boolean DEBUG = true;
    protected ContC containerCo;
    protected BaseTableComposite listaTable;
    protected Composite cNaPodst;
    protected Color domyslny;
    protected Color szary;
    protected SprIF sprClient;
    protected DialogParams dParams = new DialogParams();
    protected boolean pozwolDodawacKartoteki = false;
    private SprClientConfig sprConf;
    protected SelectionListener selAd = new SelectionAdapter(){

        public void widgetDefaultSelected(SelectionEvent evt) {
            Object src = evt.getSource();
            if (src == PozycjeCNewer.this.skanujTxt) {
                PozycjeCNewer.this.skanujTxtWDS();
            }
            if (src == PozycjeCNewer.this.listaTable) {
                PozycjeCNewer.this.listaTableWDS();
            }
        }

        public void widgetSelected(SelectionEvent evt) {
            Object src = evt.getSource();
            if (src == PozycjeCNewer.this.wpisBtn) {
                PozycjeCNewer.this.wpisBtnWS();
            }
            if (src == PozycjeCNewer.this.przerwijBtn) {
                PozycjeCNewer.this.przerwijBtnWS();
            }
            if (src == PozycjeCNewer.this.wiecejBtn) {
                PozycjeCNewer.this.wiecejBtnWS();
            }
            if (src == PozycjeCNewer.this.zatwierdzBtn) {
                PozycjeCNewer.this.zatwierdzBtnWS();
            }
        }
    };
    private KeyListener keyAd = new KeyAdapter(){

        public void keyPressed(KeyEvent e) {
            if (e.character == '0') {
                PozycjeCNewer.this.przerwijBtnWS();
            } else if (e.character == '1') {
                PozycjeCNewer.this.zatwierdzBtnWS();
            } else if (e.character == '2') {
                PozycjeCNewer.this.wiecejBtnWS();
            } else if (e.character == '\u001b') {
                PozycjeCNewer.this.skanujTxt.setFocus();
            }
        }
    };
    protected CechaDokkM[] cechyDok;

    public PozycjeCNewer(ContC parent) {
        super(parent, 0);
        this.containerCo = parent;
        this.initGUI();
        this.sprClient = Common.getSprClient();
        boolean allowKeyShortcuts = Common.magClientConf.skroty;
        if (allowKeyShortcuts) {
            this.listaTable.addKeyListener(this.keyAd);
        }
        this.listaTable.addRemoveAllListener(new ExtendedTableCallback(){

            public void call(ExtendedTable table) {
                PozycjeCNewer.this.removeExtraEditorsAndControls();
            }
        });
    }

    protected void runUI(Control focusControl, boolean autoHide) {
        super.runUI(focusControl, autoHide);
        this.listaTable.saveColumnSettings();
    }

    public String getMultiRowFormat() {
        return null;
    }

    public boolean hasMultiRowVersion() {
        return Common.magClientConf.tblMode == 1;
    }

    public PozycjeCNewer(Shell p1) {
        this(p1, false);
    }

    public PozycjeCNewer(Shell p1, boolean allowKeyShortcuts) {
        super((Composite)p1, 0);
        this.initGUI();
        System.out.println("nie uzywan normalnie !!!");
        System.err.println("nie uzywan normalnie !!!");
    }

    protected void removeExtraEditorsAndControls() {
        int index;
        for (index = 0; index < this.tableExtraEditors.size(); ++index) {
            TableEditor e = (TableEditor)this.tableExtraEditors.get(index);
            e.dispose();
        }
        this.tableExtraEditors.clear();
        for (index = 0; index < this.tableExtraControls.size(); ++index) {
            ButtonWithOuzPozM b = (ButtonWithOuzPozM)((Object)this.tableExtraControls.get(index));
            b.dispose();
        }
        this.tableExtraControls.clear();
    }

    protected RowConfigurator getRowConfigurator() {
        return null;
    }

    protected abstract void reloadRecords();

    protected abstract ColumnDef[] getColumnsDef();

    protected abstract boolean czyNaPodstawie();

    protected void refreshShownRecords(ManagedArray array) {
        MobileRecords tableDataSet = new MobileRecords(array);
        this.listaTable.setDataSet(tableDataSet);
    }

    private void initGUI() {
        try {
            GridLayout thisLayout = new GridLayout();
            thisLayout.makeColumnsEqualWidth = true;
            thisLayout.horizontalSpacing = 0;
            thisLayout.marginHeight = 0;
            thisLayout.marginWidth = 0;
            thisLayout.verticalSpacing = 0;
            this.setLayout((Layout)thisLayout);
            GridData composite3LData = new GridData();
            composite3LData.widthHint = 240;
            composite3LData.grabExcessHorizontalSpace = true;
            composite3LData.verticalAlignment = 128;
            composite3LData.heightHint = 15;
            this.cTop = new Composite((Composite)this, 0);
            GridLayout gl_composite3 = new GridLayout(2, false);
            gl_composite3.verticalSpacing = 0;
            gl_composite3.marginWidth = 0;
            gl_composite3.marginHeight = 0;
            gl_composite3.horizontalSpacing = 0;
            this.cTop.setLayout((Layout)gl_composite3);
            this.cTop.setLayoutData((Object)composite3LData);
            this.l1 = ControlFactory.createLabel(this.cTop, 0);
            this.l1.setText("Dok:                             ");
            this.dokInfo = ControlFactory.createLabel(this.cTop, 0);
            GridData gd_dokInfo = new GridData(16384, 0x1000000, true, false, 1, 1);
            gd_dokInfo.widthHint = 220;
            this.dokInfo.setLayoutData((Object)gd_dokInfo);
            this.cNaPodst = new Composite((Composite)this, 0);
            GridData c4LD = new GridData();
            c4LD.heightHint = 14;
            c4LD.grabExcessHorizontalSpace = true;
            c4LD.verticalAlignment = 128;
            c4LD.horizontalAlignment = 4;
            this.cNaPodst.setLayoutData((Object)c4LD);
            RowLayout c4L = new RowLayout(256);
            c4L.center = true;
            c4L.marginTop = 0;
            this.cNaPodst.setLayout((Layout)c4L);
            this.c2 = new Composite((Composite)this, 0);
            RowLayout c2Layout = new RowLayout(256);
            c2Layout.marginTop = 0;
            c2Layout.center = true;
            c2Layout.marginBottom = 0;
            GridData c2LData = new GridData();
            c2LData.grabExcessHorizontalSpace = true;
            c2LData.verticalAlignment = 128;
            c2LData.horizontalAlignment = 4;
            this.c2.setLayoutData((Object)c2LData);
            this.c2.setLayout((Layout)c2Layout);
            this.labelEan = ControlFactory.createLabel(this.c2, 0);
            this.labelEan.setLayoutData((Object)new RowData());
            this.labelEan.setText("Ean:");
            RowData skanujTxtLData = new RowData();
            skanujTxtLData.width = 141;
            skanujTxtLData.height = 12;
            this.skanujTxt = new Text(this.c2, 2048);
            this.skanujTxt.setLayoutData((Object)skanujTxtLData);
            this.skanujTxt.addSelectionListener(this.selAd);
            this.wpisBtn = new Button(this.c2, 0x1000008);
            RowData wpisBtnLData = new RowData();
            wpisBtnLData.width = 45;
            wpisBtnLData.height = 24;
            this.wpisBtn.setLayoutData((Object)wpisBtnLData);
            this.wpisBtn.setText("Skanuj");
            this.wpisBtn.addSelectionListener(this.selAd);
            this.cNaPodst.setVisible(this.czyNaPodstawie());
            this.initTable();
            GridData composite1LData = new GridData();
            composite1LData.grabExcessHorizontalSpace = true;
            composite1LData.verticalAlignment = 1024;
            composite1LData.horizontalAlignment = 4;
            composite1LData.heightHint = 24;
            this.composite1 = new Composite((Composite)this, 0);
            GridLayout composite1Layout = new GridLayout();
            composite1Layout.numColumns = 3;
            composite1Layout.marginHeight = 0;
            composite1Layout.makeColumnsEqualWidth = true;
            composite1Layout.horizontalSpacing = 0;
            this.composite1.setLayout((Layout)composite1Layout);
            this.composite1.setLayoutData((Object)composite1LData);
            this.przerwijBtn = new Button(this.composite1, 0x1000008);
            this.przerwijBtn.setText("0. Przerwij");
            this.przerwijBtn.addSelectionListener(this.selAd);
            this.wiecejBtn = new Button(this.composite1, 0x1000008);
            this.wiecejBtn.setText("2. Wi\u0119cej...");
            this.wiecejBtn.addSelectionListener(this.selAd);
            this.zatwierdzBtn = new Button(this.composite1, 0x1000008);
            GridData zatwierdzBtnLData = new GridData();
            zatwierdzBtnLData.horizontalAlignment = 3;
            zatwierdzBtnLData.grabExcessHorizontalSpace = true;
            this.zatwierdzBtn.setLayoutData((Object)zatwierdzBtnLData);
            this.zatwierdzBtn.setText("1. Zatwierd\u017a");
            this.zatwierdzBtn.addSelectionListener(this.selAd);
            this.setSize(Main.shellWidth, Main.containerHeight);
            this.layout();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initTable() {
        GridData table1LData = new GridData();
        if (this.hasMultiRowVersion()) {
            this.listaTable = new TableComposite(this, 68096);
            table1LData.verticalAlignment = 4;
            table1LData.grabExcessVerticalSpace = true;
            table1LData.widthHint = 230;
            SwtCommon.setConrolFontSize((Control)this.listaTable, 8);
        } else {
            this.listaTable = new TableComposite(this, 68352);
            table1LData.grabExcessHorizontalSpace = true;
            table1LData.verticalAlignment = 4;
            table1LData.grabExcessVerticalSpace = true;
            table1LData.widthHint = 216;
        }
        this.listaTable.setLayoutData(table1LData);
        this.listaTable.addSelectionListener(this.selAd);
    }

    protected void setDokInfo(String info) {
        this.l1.setText("Dok : " + UtilsM.ifNull(info));
    }

    protected void skanujTxtWDS() {
        String wpisano = this.skanujTxt.getText();
        if (wpisano.length() == 0) {
            this.listaTable.setFocus();
            this.listaTable.select(0);
            return;
        }
        this.wpisBtnWS();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void wiecejBtnWS() {
        MenuPozycjeWiecejCD d = new MenuPozycjeWiecejCD(this.containerCo);
        try {
            boolean ukryjStateBefore = this.dParams.ukryjPozycjeOk;
            this.customizeMoreDialogParams(this.dParams);
            DialogParams dParams1 = d.open(this.dParams);
            if (this.isDisposed()) {
                return;
            }
            if (dParams1 == null) {
                return;
            }
            this.dParams = dParams1;
            if (this.dParams.akcja == 2) {
                this.usunBtnWS();
                if (this.isDisposed()) {
                    return;
                }
                this.skanujTxt.setFocus();
                return;
            }
            if (this.dParams.akcja == 1) {
                this.szukaj(this.dParams.szukajFrazy);
                if (this.isDisposed()) {
                    return;
                }
                this.skanujTxt.setFocus();
                return;
            }
            if (this.dParams.akcja == 5) {
                this.edytujCechy();
            } else if (this.dParams.akcja == 6) {
                this.zakonczUI = true;
            }
            if (ukryjStateBefore != this.dParams.ukryjPozycjeOk) {
                this.reloadRecords();
            }
            if (this.isDisposed()) {
                return;
            }
            this.skanujTxt.setFocus();
        }
        finally {
            SwtCommon.safeDispose(d);
        }
    }

    protected void customizeMoreDialogParams(DialogParams dParams2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void edytujCechy() {
        PozUwagiCechyC d = new PozUwagiCechyC(this.containerCo);
        try {
            DialogParams dParams1 = d.openDok(this.dParams, this.cechyDok, null);
            if (this.isDisposed()) {
                return;
            }
            if (dParams1 == null) {
                return;
            }
            this.dParams = dParams1;
            if (this.dParams.akcja == 4) {
                this.zapiszUwagiCechy(this.dParams);
            }
        }
        finally {
            SwtCommon.safeDispose(d);
        }
    }

    protected abstract void dodajInneZamowienie();

    protected abstract void usunBtnWS();

    protected abstract void szukaj(String var1);

    protected abstract void wpisBtnWS();

    protected abstract void zatwierdzBtnWS();

    protected void przerwijBtnWS() {
        this.zakonczUI = true;
    }

    protected abstract void listaTableWDS();

    protected abstract void zapiszUwagiCechy(DialogParams var1);

    protected void setFontSize(Integer fSize) {
        this.listaTable.setFontSize(fSize);
    }

    protected TowarSzukanie znajdzTowarIndeksNazwa(String wpisano) {
        TowarSzukanie ktory;
        TowarSzukanie[] listaTowarow = this.sprClient.szukajTowaruIndeksNazwa(wpisano, false);
        if (listaTowarow == null) {
            SwtCommon.alert(this.getShell(), "b\u0142\u0105d pobierania listy towar\u00f3w");
            return null;
        }
        if (listaTowarow.length == 0) {
            SwtCommon.alert(this.getShell(), "nie znaleziono indeksu/nazwy.");
            return null;
        }
        if (listaTowarow.length == 1) {
            ktory = listaTowarow[0];
        } else {
            ktory = PrzegladyUtils.wybierzTowar(this.containerCo, listaTowarow, this.getSprConf());
            if (ktory == null || ktory.equals(PrzegladyUtils.TOWAR_POWROC)) {
                return null;
            }
        }
        return ktory;
    }

    protected Ean128DataDesc podajDaneZEtykiety(KodEan128Result parsedEan) {
        Ean128DataDesc res = new Ean128DataDesc();
        if (!parsedEan.containsEan() && !parsedEan.containsNrPartii()) {
            res.errorDesc = "brak w kodzie ean lub partii";
            return res;
        }
        String desc = parsedEan.partia;
        if (parsedEan.containsEan()) {
            desc = desc + " ean :" + parsedEan.eanTowaru;
        }
        if (parsedEan.containsNrPartii()) {
            Dostawa dostawa = this.szukajPierwszejDostawy(parsedEan.eanTowaru, parsedEan.partia);
            if (dostawa == null) {
                res.errorDesc = "Brak partii :" + desc;
                return res;
            }
            res.dostawa = dostawa;
            res.towar = this.sprClient.szczegolyTowaruZDostawy(dostawa.id);
            return res;
        }
        TowarSzukanie ktory = this.znajdzTowarEan(parsedEan.eanTowaru);
        if (ktory == null) {
            return null;
        }
        res.towar = this.sprClient.szczegolyTowaru(ktory.id);
        return res;
    }

    protected Dostawa szukajPierwszejDostawy(String eanTowaru, String partia) {
        return this.sprClient.szukajPierwszejDostawy(eanTowaru, partia);
    }

    protected TowarSzukanie znajdzTowarEan(String wpisano) {
        TowarSzukanie ktory;
        TowarSzukanie[] listaTowarow = this.sprClient.szukajTowaruEan(wpisano);
        if (listaTowarow == null) {
            SwtCommon.alert(this.getShell(), "b\u0142\u0105d pobierania listy towar\u00f3w");
            return null;
        }
        if (listaTowarow.length == 0) {
            ktory = new MainDOD(this.sprClient, Common.getDodClient(), this.containerCo).obslugaWpisanoNieZnaleziono(wpisano, this.pozwolDodawacKartoteki);
        } else if (listaTowarow.length == 1) {
            ktory = listaTowarow[0];
        } else {
            ktory = PrzegladyUtils.wybierzTowar(this.containerCo, listaTowarow, this.getSprConf());
            if (ktory == null || ktory.equals(PrzegladyUtils.TOWAR_POWROC)) {
                return null;
            }
        }
        return ktory;
    }

    protected OpakKartM eanZopakowania(String eanWpisany, Towar sz) {
        if (eanWpisany == null) {
            return null;
        }
        OpakKartM[] opakowania = sz.opakowania;
        if (opakowania == null) {
            return null;
        }
        if (opakowania.length == 0) {
            return null;
        }
        String indeks = sz.indeks;
        ArrayList<OpakKartM> znalezioneOpakowania = new ArrayList<OpakKartM>();
        for (int i = 0; i < opakowania.length; ++i) {
            if (opakowania[i].eany == null) continue;
            for (int j = 0; j < opakowania[i].eany.length; ++j) {
                if (!opakowania[i].eany[j].equals(eanWpisany)) continue;
                znalezioneOpakowania.add(opakowania[i]);
            }
        }
        if (znalezioneOpakowania.size() == 0) {
            return null;
        }
        if (znalezioneOpakowania.size() == 1) {
            return (OpakKartM)znalezioneOpakowania.get(0);
        }
        OpakKartM ret = PrzegladyUtils.wybierzOpakowanie(this.containerCo, znalezioneOpakowania.toArray(new OpakKartM[0]), indeks, null);
        return ret;
    }

    protected boolean sprawdzBlokady(Towar szczegoly, boolean jakoPrzyjecie, MagClientConfig conf, OUZpozM poz) {
        boolean skipStateControl;
        boolean jakoWydanie;
        if (poz != null) {
            szczegoly = poz.sz;
        }
        if (szczegoly == null) {
            SwtCommon.alert(this.getShell(), "brak danych szczegolowych kartoteki!");
            return false;
        }
        if (szczegoly.akt == 0) {
            SwtCommon.alert(this.getShell(), "kartoteka " + szczegoly.nazwaSkr + " jest nieaktywna!");
            return false;
        }
        boolean bl = jakoWydanie = !jakoPrzyjecie;
        if (jakoWydanie && szczegoly.blRoz == 1) {
            SwtCommon.alert(this.getShell(), "nie mog\u0119 wyda\u0107 " + szczegoly.nazwaSkr + ", blokada rozchodu!");
            return false;
        }
        WprClientConfig wprConf = Common.getWprCC();
        boolean bl2 = this.czyNaPodstawie() ? wprConf.wydanieZeWzorcemKonrolaStanMag == 2 : (skipStateControl = wprConf.wydanieBezWzorcaKonrolaStanMag == 2);
        if (!skipStateControl && jakoWydanie && szczegoly.stan == 0.0) {
            SwtCommon.alert(this.getShell(), "nie mog\u0119 wyda\u0107 " + szczegoly.nazwaSkr + ", brak stanu na magazynie!");
            return false;
        }
        if (jakoPrzyjecie && szczegoly.blPrz == 1) {
            SwtCommon.alert(this.getShell(), "nie mog\u0119 przyj\u0105\u0107 " + szczegoly.nazwaSkr + ", blokada przychodu!");
            return false;
        }
        String nazwaMagazynu = conf.nazwaMagazynu;
        if (poz != null) {
            szczegoly = poz.sz;
            MagS m = Common.getWprClient().szukajMagazynuId(poz.idMagZam);
            nazwaMagazynu = m.nazwa;
        }
        if (szczegoly.aktM == 0) {
            SwtCommon.alert(this.getShell(), "kartoteka " + szczegoly.nazwaSkr + " NIE jest aktywna w biezacym magazynie " + nazwaMagazynu);
            return false;
        }
        if (jakoWydanie && szczegoly.blRozM == 1) {
            SwtCommon.alert(this.getShell(), "nie mog\u0119 wyda\u0107 " + szczegoly.nazwaSkr + ", blokada rozchodu w biezacym magazynie " + nazwaMagazynu);
            return false;
        }
        if (jakoPrzyjecie && szczegoly.blPrzM == 1) {
            SwtCommon.alert(this.getShell(), "nie mog\u0119 przyj\u0105\u0107 " + szczegoly.nazwaSkr + ", blokada przychodu w biezacym magazynie " + nazwaMagazynu);
            return false;
        }
        return true;
    }

    protected String getPropertyFileName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected SprClientConfig getSprConf() {
        return this.sprConf;
    }

    protected void setSprConf(SprClientConfig sprConf) {
        this.sprConf = sprConf;
    }

    protected static class Ean128DataDesc {
        public Towar towar;
        public Dostawa dostawa;
        public String errorDesc;

        protected Ean128DataDesc() {
        }
    }

    private class TableComposite
    extends BaseTableComposite {
        public TableComposite(Composite parent, int style) {
            super(parent, style);
        }

        public ColumnDef[] getColumnsDef() {
            return PozycjeCNewer.this.getColumnsDef();
        }

        public RowConfigurator getRowConfigurator() {
            return PozycjeCNewer.this.getRowConfigurator();
        }

        public boolean hasMultiRowVersion() {
            return PozycjeCNewer.this.hasMultiRowVersion();
        }

        public String getMultiRowFormat() {
            return PozycjeCNewer.this.getMultiRowFormat();
        }

        public String getPropertyFileName() {
            return PozycjeCNewer.this.getPropertyFileName();
        }
    }
}

