/*
 * Decompiled with CFR 0.152.
 */
package ekspert.mobile.common;

import base.controls.ControlFactory;
import base.controls.ExtendedTableItem;
import ekspert.mobile.ContC;
import ekspert.mobile.Main;
import ekspert.mobile.UtilsM;
import ekspert.mobile.common.FiltrComposite;
import ekspert.mobile.common.obj.DefDokM;
import ekspert.mobile.common.obj.Dostawa;
import ekspert.mobile.common.obj.MSkl;
import ekspert.mobile.common.obj.OpakKartM;
import ekspert.mobile.common.obj.StanKartMskl;
import ekspert.mobile.common.obj.StanMskl;
import ekspert.mobile.common.obj.TowarSzukanie;
import ekspert.mobile.common.obj.ZlecM;
import ekspert.mobile.common.przeglady.PrzegladyUtils;
import ekspert.mobile.common.spr.SprClientConfig;
import ekspert.mobile.common.wpr.KontrahS;
import ekspert.mobile.common.wpr.MagS;
import ekspert.mobile.gui.CompositeDialog;
import ekspert.mobile.gui.SwtCommon;
import java.util.ArrayList;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class WyborListaC
extends CompositeDialog {
    protected Label tytulLab;
    protected Table listaTable;
    private TableColumn kol0;
    private TableColumn kol1;
    private TableColumn kol2;
    private TableColumn kol3;
    private TableColumn kol4;
    private TableColumn kol5;
    private TableColumn kol6;
    private Composite dolC;
    private Button powrocBtn;
    protected Button filtrujBtn;
    private Button wybierzBtn;
    protected ContC contC;
    private static final int KOL_IDKARTOTEKA = 0;
    private static final int KOL_NAZWA = 1;
    private static final int KOL_STAN = 2;
    private static final int KOL_IDMAGAZYN = 0;
    private static final int KOL_NRMAG = 1;
    private static final int KOL_NAZWAMAG = 2;
    private static final int KOL_ID_ZLEC = 0;
    private static final int KOL_NR_ZLEC = 1;
    private static final int KOL_OPIS_ZLEC = 2;
    SelectionAdapter selAd = new SelectionAdapter(){

        public void widgetDefaultSelected(SelectionEvent evt) {
            WyborListaC.this.listaTableWDS();
        }

        public void widgetSelected(SelectionEvent evt) {
            Object src = evt.getSource();
            if (src == WyborListaC.this.powrocBtn) {
                WyborListaC.this.powrocBtnWS();
            }
            if (src == WyborListaC.this.filtrujBtn) {
                WyborListaC.this.filtrujBtnWS();
            }
            if (src == WyborListaC.this.wybierzBtn) {
                WyborListaC.this.wybierzBtnWS();
            }
        }
    };
    private String frazaFiltru;
    static final int TRYB_KONTRAH = 1;
    static final int TRYB_TOWAR = 2;
    static final int TRYB_MAGAZYN = 3;
    static final int TRYB_DOSTAWA = 4;
    static final int TRYB_OPAK = 5;
    private int trybDialogu;
    private KontrahS[] pelnaListaKontrah;
    private TowarSzukanie[] pelnaListaTowarow;
    private MagS[] pelnaListaMagazynow;
    private String pominKodMag;
    private boolean defdoksInitialized;
    private static final int KOL_NRKONTRAH = 1;
    private static final int KOL_NAZWASKR = 2;
    private static final int KOL_NIP = 3;
    private static final int KOL_MIEJSCOWOSC = 4;
    private static final int KOL_DOST_ILOSC = 0;
    private static final int KOL_DOST_DWAZN = 1;
    private static final int KOL_DOST_NRPART = 2;
    private static final int KOL_DOST_DDOST = 3;
    private static final int KOL_DOST_CENAZAK = 4;
    private static final int KOL_DOST_POLE2 = 5;
    private static final int KOL_DOST_KONTRAH = 6;
    private static final int KOL_NAZWAOPAK = 0;
    private static final int KOL_ILEWOPAK = 1;

    public WyborListaC(ContC parent) {
        super(parent, 2048);
        this.contC = parent;
        this.initGUI();
    }

    private void initGUI() {
        try {
            GridLayout thisLayout = new GridLayout();
            thisLayout.makeColumnsEqualWidth = true;
            thisLayout.horizontalSpacing = 2;
            thisLayout.marginHeight = 2;
            thisLayout.marginWidth = 2;
            thisLayout.verticalSpacing = 2;
            this.setLayout((Layout)thisLayout);
            this.tytulLab = ControlFactory.createLabel(this, 0);
            GridData tytulLabLData = new GridData();
            tytulLabLData.horizontalAlignment = 4;
            tytulLabLData.grabExcessHorizontalSpace = true;
            this.tytulLab.setLayoutData((Object)tytulLabLData);
            this.tytulLab.setText("Lista znalezionych:");
            this.listaTable = new Table((Composite)this, 68096);
            this.listaTable.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent arg0) {
                    if (arg0.character == '\u001b') {
                        WyborListaC.this.powrocBtnWS();
                    }
                }
            });
            this.listaTable.setLinesVisible(true);
            GridData table1LData = new GridData();
            table1LData.horizontalAlignment = 4;
            table1LData.grabExcessVerticalSpace = true;
            table1LData.verticalAlignment = 4;
            this.listaTable.setLayoutData((Object)table1LData);
            this.listaTable.setHeaderVisible(true);
            this.listaTable.addSelectionListener((SelectionListener)this.selAd);
            this.kol0 = new TableColumn(this.listaTable, 0);
            this.kol0.setWidth(0);
            this.kol1 = new TableColumn(this.listaTable, 16384);
            this.kol1.setMoveable(true);
            this.kol1.setWidth(20);
            this.kol2 = new TableColumn(this.listaTable, 16384);
            this.kol2.setMoveable(true);
            this.kol2.setWidth(20);
            this.kol3 = new TableColumn(this.listaTable, 16384);
            this.kol3.setMoveable(true);
            this.kol3.setWidth(20);
            this.kol4 = new TableColumn(this.listaTable, 16384);
            this.kol4.setMoveable(true);
            this.kol4.setWidth(20);
            this.kol5 = new TableColumn(this.listaTable, 16384);
            this.kol5.setMoveable(true);
            this.kol5.setWidth(0);
            this.kol6 = new TableColumn(this.listaTable, 16384);
            this.kol6.setMoveable(true);
            this.kol6.setWidth(0);
            GridData composite1LData = new GridData();
            composite1LData.horizontalAlignment = 4;
            this.dolC = new Composite((Composite)this, 0);
            FillLayout composite1Layout = new FillLayout(256);
            this.dolC.setLayout((Layout)composite1Layout);
            this.dolC.setLayoutData((Object)composite1LData);
            this.powrocBtn = new Button(this.dolC, 0x1000008);
            this.powrocBtn.setText("Powr\u00f3\u0107");
            this.powrocBtn.addSelectionListener((SelectionListener)this.selAd);
            this.filtrujBtn = new Button(this.dolC, 0x1000008);
            this.filtrujBtn.setText("Filtruj");
            this.filtrujBtn.addSelectionListener((SelectionListener)this.selAd);
            this.wybierzBtn = new Button(this.dolC, 0x1000008);
            this.wybierzBtn.setText("Wybierz");
            this.wybierzBtn.addSelectionListener((SelectionListener)this.selAd);
            this.layout();
            this.pack();
            this.setSize(Main.shellWidth, Main.containerHeight);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void filtrujBtnWS() {
        FiltrComposite f = new FiltrComposite(this.contC);
        try {
            SwtCommon.centerOnParent(f);
            this.dolC.setEnabled(false);
            this.listaTable.setEnabled(false);
            String nowaFraza = f.filtruj(this.frazaFiltru);
            this.dolC.setEnabled(true);
            this.listaTable.setEnabled(true);
            System.out.println(this.frazaFiltru);
            if (nowaFraza == null) {
                return;
            }
            this.frazaFiltru = nowaFraza;
            if (this.frazaFiltru.length() == 0) {
                this.setFiltr(null);
                this.filtrujBtn.setText("Filtruj");
                return;
            }
            this.setFiltr(this.frazaFiltru);
            this.filtrujBtn.setText("Filtruj *");
        }
        finally {
            SwtCommon.safeDispose(f);
        }
    }

    private void setFiltr(String filtr) {
        switch (this.trybDialogu) {
            case 1: {
                this.setFiltrKontrah(filtr);
                break;
            }
            case 3: {
                this.setFiltrMagazyn(filtr);
                break;
            }
            case 2: {
                this.setFiltrTowar(filtr);
                break;
            }
        }
    }

    protected void powrocBtnWS() {
        this.listaTable.deselectAll();
        this.zakonczUI = true;
    }

    protected void listaTableWDS() {
        this.wybierzBtnWS();
    }

    protected void wybierzBtnWS() {
        int ind = this.listaTable.getSelectionIndex();
        if (ind == -1) {
            return;
        }
        this.zakonczUI = true;
    }

    private KontrahS wybierzKontrahenta(KontrahS[] listaKontrah) {
        this.trybDialogu = 1;
        this.pelnaListaKontrah = listaKontrah;
        this.tytulLab.setText("Lista znalezionych kontrahent\u00f3w:");
        TableColumn[] cols = this.listaTable.getColumns();
        cols[1].setText("Nr");
        cols[2].setText("Nazwa");
        cols[3].setText("NIP");
        cols[4].setText("Miejscowo\u015b\u0107");
        this.setListaKontrah(listaKontrah);
        this.listaTable.setSelection(0);
        this.runUI((Control)this.listaTable);
        if (this.isDisposed()) {
            return null;
        }
        int ind = this.listaTable.getSelectionIndex();
        if (ind == -1) {
            return PrzegladyUtils.KONTRAH_POWROC;
        }
        return (KontrahS)this.listaTable.getItem(ind).getData();
    }

    private void setListaKontrah(KontrahS[] listaKontrah) {
        this.listaTable.removeAll();
        for (int i = 0; i < listaKontrah.length; ++i) {
            KontrahS k = listaKontrah[i];
            ExtendedTableItem item = new ExtendedTableItem(this.listaTable, 0);
            item.setText(1, k.nrKontrah);
            item.setText(2, k.nazwaskr);
            if (k.nip != null) {
                item.setText(3, k.nip);
            }
            if (k.miasto != null) {
                item.setText(4, k.miasto);
            }
            item.setData(k);
        }
        this.listaTable.getColumn(1).pack();
        this.listaTable.getColumn(2).pack();
        this.listaTable.getColumn(3).pack();
        this.listaTable.getColumn(4).pack();
    }

    private void setFiltrKontrah(String filtr) {
        if (filtr == null) {
            this.setListaKontrah(this.pelnaListaKontrah);
            return;
        }
        ArrayList<KontrahS> filtrowanaLista = new ArrayList<KontrahS>();
        for (int i = 0; i < this.pelnaListaKontrah.length; ++i) {
            if (this.pelnaListaKontrah[i].nazwaskr.indexOf(this.frazaFiltru) <= -1) continue;
            filtrowanaLista.add(this.pelnaListaKontrah[i]);
        }
        KontrahS[] aa = KontrahS.cast(filtrowanaLista);
        this.setListaKontrah(aa);
    }

    private TowarSzukanie wybierzTowar(TowarSzukanie[] listaTowarow, SprClientConfig conf) {
        this.trybDialogu = 2;
        this.pelnaListaTowarow = listaTowarow;
        this.kol1.setText(conf.pole1);
        this.kol2.setText(conf.pole2);
        this.kol3.setWidth(0);
        this.kol4.setWidth(0);
        this.tytulLab.setText("Lista znalezionych towar\u00f3w:");
        this.setListaTowarow(listaTowarow);
        this.powrocBtn.setText("Powr\u00f3\u0107");
        this.filtrujBtn.setVisible(false);
        this.listaTable.setSelection(0);
        this.runUI((Control)this.listaTable);
        if (this.isDisposed()) {
            return null;
        }
        int ind = this.listaTable.getSelectionIndex();
        if (ind == -1) {
            return null;
        }
        return (TowarSzukanie)this.listaTable.getItem(ind).getData();
    }

    private void setListaTowarow(TowarSzukanie[] listaTowarow) {
        Color szary = this.getDisplay().getSystemColor(15);
        this.listaTable.removeAll();
        for (int i = 0; i < listaTowarow.length; ++i) {
            TowarSzukanie t = listaTowarow[i];
            ExtendedTableItem item = new ExtendedTableItem(this.listaTable, 0);
            item.setText(0, Integer.toString(t.id));
            item.setText(1, t.nazwa);
            item.setText(2, t.stan);
            if (!t.aktMag()) {
                item.setForeground(szary);
            }
            item.setData(t);
        }
        this.listaTable.getColumn(1).pack();
        this.listaTable.getColumn(2).pack();
    }

    private void setFiltrTowar(String filtr) {
        if (filtr == null) {
            this.setListaTowarow(this.pelnaListaTowarow);
            return;
        }
        ArrayList<TowarSzukanie> filtrowanaLista = new ArrayList<TowarSzukanie>();
        for (int i = 0; i < this.pelnaListaTowarow.length; ++i) {
            if (this.pelnaListaTowarow[i].nazwa.indexOf(this.frazaFiltru) <= -1) continue;
            filtrowanaLista.add(this.pelnaListaTowarow[i]);
        }
        TowarSzukanie[] aa = TowarSzukanie.cast(filtrowanaLista);
        this.setListaTowarow(aa);
    }

    private MagS wybierzMagazyn(MagS[] wyszukani) {
        return this.wybierzMagazyn(wyszukani, "lista znalezionych magazyn\u00f3w:", null);
    }

    private MagS wybierzMagazyn(MagS[] wyszukani, String tytul, String pominKodMag) {
        this.trybDialogu = 3;
        this.pelnaListaMagazynow = wyszukani;
        this.pominKodMag = pominKodMag;
        this.kol1.setText("Kod");
        this.kol2.setText("Nazwa");
        this.kol3.setWidth(0);
        this.kol4.setWidth(0);
        this.filtrujBtn.setVisible(false);
        this.tytulLab.setText(tytul);
        this.setListaMagazynow(wyszukani);
        this.powrocBtn.setText("Powr\u00f3\u0107");
        this.listaTable.setSelection(0);
        this.runUI((Control)this.listaTable);
        if (this.isDisposed()) {
            return null;
        }
        int ind = this.listaTable.getSelectionIndex();
        if (ind == -1) {
            return null;
        }
        return (MagS)this.listaTable.getItem(ind).getData();
    }

    private void setListaMagazynow(MagS[] wyszukani) {
        this.listaTable.removeAll();
        for (int i = 0; i < wyszukani.length; ++i) {
            MagS m = wyszukani[i];
            if (m.oznNrWydr.equals(this.pominKodMag)) continue;
            ExtendedTableItem item = new ExtendedTableItem(this.listaTable, 0);
            item.setText(0, Integer.toString(m.id_magazyn));
            item.setText(1, m.oznNrWydr);
            item.setText(2, UtilsM.ifNull(m.nazwa));
            item.setData(m);
        }
        this.listaTable.getColumn(1).pack();
        this.listaTable.getColumn(2).pack();
    }

    private void setFiltrMagazyn(String filtr) {
        if (filtr == null) {
            this.setListaMagazynow(this.pelnaListaMagazynow);
            return;
        }
        ArrayList<MagS> filtrowanaLista = new ArrayList<MagS>();
        for (int i = 0; i < this.pelnaListaMagazynow.length; ++i) {
            if (this.pelnaListaMagazynow[i].nazwa.indexOf(this.frazaFiltru) <= -1) continue;
            filtrowanaLista.add(this.pelnaListaMagazynow[i]);
        }
        MagS[] aa = MagS.cast(filtrowanaLista);
        this.setListaMagazynow(aa);
    }

    private Dostawa wybierzDostawe(Dostawa[] dostawy, String tytul, SprClientConfig conf) {
        this.trybDialogu = 4;
        this.listaTable.getColumn(0).setText("Ilo\u015b\u0107");
        this.listaTable.getColumn(1).setText("D.wa\u017cno\u015bci");
        this.listaTable.getColumn(2).setText("Nr.partii");
        this.listaTable.getColumn(3).setText("D.dostawy");
        this.listaTable.getColumn(4).setText("Cena Zak.");
        this.listaTable.getColumn(6).setText("Kontrah");
        String pole2caption = "";
        if (conf.dostPole2 != null) {
            pole2caption = conf.dostPole2;
            this.listaTable.getColumn(5).setWidth(35);
        }
        this.listaTable.getColumn(5).setText(pole2caption);
        this.filtrujBtn.setVisible(false);
        if (tytul != null && tytul.length() > 0) {
            this.tytulLab.setText(tytul);
        } else {
            this.tytulLab.setText("Wybierz dostaw\u0119:");
        }
        this.listaTable.removeAll();
        for (int i = 0; i < dostawy.length; ++i) {
            Dostawa d = dostawy[i];
            ExtendedTableItem item = new ExtendedTableItem(this.listaTable, 0);
            item.setText(0, UtilsM.formatDoubleIlosc(d.ilosc));
            if (d.dataWazn != null) {
                item.setText(1, d.dataWazn);
            }
            item.setText(2, d.nrDost);
            item.setText(3, d.dataDost);
            if (conf.pokazujCeneDostawy) {
                item.setText(4, Double.toString(d.cenaZak));
            }
            if (d.kontrah != null) {
                item.setText(6, d.kontrah);
            }
            if (d.pole2 == null) continue;
            item.setText(5, d.pole2);
        }
        this.listaTable.getColumn(0).pack();
        this.listaTable.getColumn(1).pack();
        this.listaTable.getColumn(2).pack();
        this.listaTable.getColumn(3).pack();
        this.listaTable.getColumn(4).pack();
        this.listaTable.getColumn(6).pack();
        this.listaTable.getColumn(5).pack();
        this.powrocBtn.setText("Powr\u00f3\u0107");
        this.listaTable.setSelection(0);
        this.runUI((Control)this.listaTable);
        if (this.isDisposed()) {
            return null;
        }
        int ind = this.listaTable.getSelectionIndex();
        if (ind == -1) {
            return null;
        }
        return dostawy[ind];
    }

    private void setListaOpakowan(OpakKartM[] listaOpakowan, OpakKartM def) {
        if (listaOpakowan.length == 0) {
            this.listaTable.setVisible(false);
            this.wybierzBtn.setVisible(false);
            this.tytulLab.setText("Kartoteka nie posiada opakowa\u0144");
            this.tytulLab.pack();
            this.layout();
            return;
        }
        this.listaTable.setRedraw(false);
        for (int i = 0; i < listaOpakowan.length; ++i) {
            OpakKartM o = listaOpakowan[i];
            ExtendedTableItem item = new ExtendedTableItem(this.listaTable, 0);
            if (def != null && def.id == o.id) {
                item.setText(0, "* " + o.nazwa);
            } else {
                item.setText(0, o.nazwa);
            }
            item.setText(1, Double.toString(o.ileWopak));
        }
        this.listaTable.setRedraw(true);
        this.listaTable.getColumn(0).pack();
    }

    private OpakKartM wybierzOpakowanie(OpakKartM[] listaOpakowan, String indeks) {
        return this.wybierzOpakowanie(listaOpakowan, indeks, null);
    }

    private OpakKartM wybierzOpakowanie(OpakKartM[] listaOpakowan, String indeks, OpakKartM def) {
        this.tytulLab.setText("lista opakowa\u0144 dla " + indeks);
        this.listaTable.getColumn(0).setText("Nazwa");
        this.listaTable.getColumn(1).setText("Ilo\u015b\u0107");
        this.listaTable.getColumn(2).setWidth(0);
        this.listaTable.getColumn(3).setWidth(0);
        this.listaTable.getColumn(4).setWidth(0);
        this.setListaOpakowan(listaOpakowan, def);
        this.filtrujBtn.setEnabled(false);
        this.listaTable.setSelection(0);
        this.runUI((Control)this.listaTable);
        if (this.isDisposed()) {
            return null;
        }
        int ind = this.listaTable.getSelectionIndex();
        if (ind == -1) {
            return null;
        }
        return listaOpakowan[ind];
    }

    private StanMskl wybierzTowarZMiejscaSkladowania(StanMskl[] listaTowarow) {
        this.tytulLab.setText("Towar:");
        this.filtrujBtn.setEnabled(false);
        this.setTowaryMskl(listaTowarow);
        this.listaTable.setSelection(0);
        this.runUI((Control)this.listaTable);
        if (this.isDisposed()) {
            return null;
        }
        int ind = this.listaTable.getSelectionIndex();
        if (ind == -1) {
            return null;
        }
        return listaTowarow[ind];
    }

    private StanMskl pokazMskl(MSkl mSrc, StanMskl[] kartotekiWmiejscu) {
        this.tytulLab.setText("Mskl: " + mSrc.nazwa);
        this.wybierzBtn.setEnabled(false);
        this.filtrujBtn.setEnabled(false);
        this.kol1.setText("Indeks");
        this.kol2.setText("Ilosc");
        this.kol3.setText("Nazwa");
        this.listaTable.removeAll();
        this.setTowaryMskl(kartotekiWmiejscu);
        this.listaTable.setSelection(0);
        this.runUI((Control)this.listaTable);
        if (this.isDisposed()) {
            return null;
        }
        int ind = this.listaTable.getSelectionIndex();
        if (ind == -1) {
            return null;
        }
        return kartotekiWmiejscu[ind];
    }

    private void setTowaryMskl(StanMskl[] lista) {
        this.listaTable.removeAll();
        for (int i = 0; i < lista.length; ++i) {
            StanMskl sm = lista[i];
            ExtendedTableItem item = new ExtendedTableItem(this.listaTable, 0);
            item.setText(new String[]{"", sm.indeks, Double.toString(sm.ilosc), sm.nazwaskr});
        }
        SwtCommon.ustawAutoSzerokoscKolumn(this.listaTable);
    }

    private void pokazStany(StanKartMskl[] stany) {
        if (this.isDisposed()) {
            return;
        }
        this.wybierzBtn.setEnabled(false);
        this.filtrujBtn.setEnabled(false);
        this.kol1.setText("Mag");
        this.kol2.setText("Mskl");
        this.kol3.setText("Ilo\u015b\u0107");
        this.kol4.setResizable(false);
        this.kol5.setResizable(false);
        for (int i = 0; i < stany.length; ++i) {
            ExtendedTableItem item = new ExtendedTableItem(this.listaTable, 0);
            item.setText(1, stany[i].kodMag);
            item.setText(2, stany[i].kodMskl);
            item.setText(3, UtilsM.formatDoubleIlosc(stany[i].ilosc));
        }
        SwtCommon.ustawAutoSzerokoscKolumn(this.listaTable);
        this.listaTable.setSelection(0);
        this.runUI((Control)this.listaTable);
    }

    private void pokazRozchody(Dostawa[] dostawy) {
        if (this.isDisposed()) {
            return;
        }
        this.tytulLab.setText("Lista dostaw pozycji:");
        if (dostawy == null || dostawy.length == 0) {
            SwtCommon.alert(this.getShell(), "brak informacji o rozchodach");
            return;
        }
        this.wybierzBtn.setEnabled(false);
        this.filtrujBtn.setEnabled(false);
        this.kol1.setText("Data");
        this.kol2.setText("Ilo\u015b\u0107");
        this.kol3.setText("Nr. dost.");
        this.kol4.setText("Dok");
        for (int i = 0; i < dostawy.length; ++i) {
            ExtendedTableItem item = new ExtendedTableItem(this.listaTable, 0);
            item.setText(1, dostawy[i].dataDost);
            item.setText(2, UtilsM.formatDoubleIlosc(dostawy[i].ilosc));
            item.setText(3, dostawy[i].nrDost);
            item.setText(4, dostawy[i].sdd + " " + dostawy[i].nrdokwew);
        }
        SwtCommon.ustawAutoSzerokoscKolumn(this.listaTable);
        this.listaTable.setSelection(0);
        this.runUI((Control)this.listaTable);
    }

    private ZlecM wybierzZlecenie(ZlecM[] zlecenia) {
        this.tytulLab.setText("Wybierz zlecenie:");
        this.filtrujBtn.setEnabled(false);
        this.listaTable.getColumn(0).setWidth(0);
        this.listaTable.getColumn(3).setWidth(0);
        this.listaTable.getColumn(4).setWidth(0);
        for (int i = 0; i < zlecenia.length; ++i) {
            ExtendedTableItem item = new ExtendedTableItem(this.listaTable, 0);
            item.setText(0, Integer.toString(zlecenia[i].id_zlec));
            item.setText(1, zlecenia[i].nrzlec);
            item.setText(2, zlecenia[i].opiszlec);
        }
        this.listaTable.getColumn(1).pack();
        this.listaTable.getColumn(2).pack();
        this.listaTable.setSelection(0);
        this.runUI((Control)this.listaTable);
        if (this.isDisposed()) {
            return null;
        }
        int ind = this.listaTable.getSelectionIndex();
        if (ind == -1) {
            return null;
        }
        return zlecenia[ind];
    }

    private DefDokM wybierzDefdok(DefDokM[] defDokMs) {
        if (defDokMs == null) {
            this.dispose();
            return null;
        }
        if (defDokMs.length == 1) {
            this.dispose();
            return defDokMs[0];
        }
        if (!this.defdoksInitialized) {
            this.initializeDefDoks(defDokMs);
        }
        this.listaTable.setSelection(0);
        this.runUI((Control)this.listaTable);
        if (this.isDisposed()) {
            return null;
        }
        int ind = this.listaTable.getSelectionIndex();
        if (ind == -1) {
            return null;
        }
        return defDokMs[ind];
    }

    private void initializeDefDoks(DefDokM[] defDokMs) {
        this.tytulLab.setText("Wybierz dokument:");
        this.filtrujBtn.setEnabled(false);
        this.listaTable.getColumn(0).setWidth(20);
        this.listaTable.getColumn(1).setWidth(70);
        this.listaTable.getColumn(2).setWidth(0);
        this.listaTable.getColumn(3).setWidth(0);
        this.listaTable.getColumn(4).setWidth(0);
        this.kol0.setText("Skr\u00f3t");
        this.kol1.setText("Nazwa");
        for (int i = 0; i < defDokMs.length; ++i) {
            ExtendedTableItem item = new ExtendedTableItem(this.listaTable, 0);
            item.setText(0, defDokMs[i].skrot);
            item.setText(1, defDokMs[i].opis);
        }
        this.listaTable.getColumn(0).pack();
        this.listaTable.getColumn(1).pack();
        this.defdoksInitialized = true;
    }
}

