/*
 * Decompiled with CFR 0.152.
 */
package ekspert.mobile.common.przeglady;

import base.data.ColumnDef;
import base.data.StringDataGetter;
import ekspert.mobile.ContC;
import ekspert.mobile.UtilsM;
import ekspert.mobile.common.obj.Dostawa;
import ekspert.mobile.common.przeglady.base.RecordSelectionComposite;

class PokazRozchodow
extends RecordSelectionComposite {
    private ColumnDef[] columnsDef;

    public PokazRozchodow(ContC parent) {
        super(parent);
    }

    protected String getTitle() {
        return "Lista dostaw pozycji:";
    }

    public void pokazRozchody(Dostawa[] initList) {
        this.getChoosenRecord(initList);
    }

    protected boolean hasSelection() {
        return false;
    }

    protected ColumnDef[] getColumnsDef() {
        if (this.columnsDef != null) {
            return this.columnsDef;
        }
        ColumnDef dateColumnDef = new ColumnDef("Data", 20, new StringDataGetter(){

            public String getData(Object record) {
                return ((Dostawa)record).dataDost;
            }
        });
        ColumnDef qtyColumnDef = new ColumnDef("Ilo\u015b\u0107", 20, new StringDataGetter(){

            public String getData(Object record) {
                return UtilsM.formatDoubleIlosc(((Dostawa)record).ilosc);
            }
        });
        ColumnDef nrDostColumnDef = new ColumnDef("Nr. dost.", 20, new StringDataGetter(){

            public String getData(Object record) {
                return ((Dostawa)record).nrDost;
            }
        });
        ColumnDef docColumnDef = new ColumnDef("Dok", 20, new StringDataGetter(){

            public String getData(Object record) {
                Dostawa dostawa = (Dostawa)record;
                return (UtilsM.ifNull(dostawa.sdd) + " " + UtilsM.ifNull(dostawa.nrdokwew)).trim();
            }
        });
        this.columnsDef = new ColumnDef[]{dateColumnDef, qtyColumnDef, nrDostColumnDef, docColumnDef};
        return this.columnsDef;
    }
}

