/*
 * Decompiled with CFR 0.152.
 */
package ekspert.mobile.common.przeglady;

import base.data.ColumnDef;
import base.data.StringDataGetter;
import ekspert.mobile.Common;
import ekspert.mobile.ContC;
import ekspert.mobile.common.dod.DodIF;
import ekspert.mobile.common.obj.OpakKartM;
import ekspert.mobile.common.przeglady.base.RecordDeleteAction;
import ekspert.mobile.common.przeglady.base.RecordInsertAction;
import ekspert.mobile.common.przeglady.base.RecordSelectionComposite;
import ekspert.mobile.common.przeglady.base.RecordUpdateAction;
import ekspert.mobile.dod.DodOpakC;
import ekspert.mobile.gui.SwtCommon;

class PokazWszystkichOpakowan
extends RecordSelectionComposite {
    private InnerActions actions = new InnerActions();
    private ColumnDef[] columnsDef;

    public PokazWszystkichOpakowan(ContC parent) {
        super(parent);
    }

    protected String getTitle() {
        return "lista opakowa\u0144: ";
    }

    protected boolean hasSelection() {
        return false;
    }

    private InnerActions getActions() {
        if (this.actions == null) {
            this.actions = new InnerActions();
            return this.actions;
        }
        return this.actions;
    }

    protected RecordDeleteAction getDeleteAction() {
        return this.getActions();
    }

    protected RecordUpdateAction getDirectUpdateAction() {
        return this.getActions();
    }

    protected RecordInsertAction getInsertAction() {
        return this.getActions();
    }

    public void pokazOpakowania() {
        this.getChoosenRecord(this.actions.getRecords());
    }

    protected ColumnDef[] getColumnsDef() {
        if (this.columnsDef != null) {
            return this.columnsDef;
        }
        ColumnDef nazwaColumnDef = new ColumnDef("Nazwa", 20, new StringDataGetter(){

            public String getData(Object record) {
                return ((OpakKartM)record).nazwa;
            }
        });
        ColumnDef iloscColumnDef = new ColumnDef("Ilo\u015b\u0107", 35, new StringDataGetter(){

            public String getData(Object record) {
                return Double.toString(((OpakKartM)record).ileWopak);
            }
        });
        this.columnsDef = new ColumnDef[]{nazwaColumnDef, iloscColumnDef};
        return this.columnsDef;
    }

    private class InnerActions
    implements RecordDeleteAction,
    RecordUpdateAction,
    RecordInsertAction {
        private InnerActions() {
        }

        public Object[] getRecords() {
            DodIF Dod = Common.getDodClient();
            return Dod.pobierzWszystkieOpakowania();
        }

        public boolean recordDeleted(Object record) {
            OpakKartM opak = (OpakKartM)record;
            int ret = SwtCommon.confirm(PokazWszystkichOpakowan.this.getShell(), "Czy chcesz usun\u0105\u0107 opakowanie " + opak.nazwa + "?");
            if (ret == 64) {
                DodIF Dod = Common.getDodClient();
                String res3 = Dod.usunOpakowanie(opak.id);
                if (res3 != null) {
                    SwtCommon.alert(PokazWszystkichOpakowan.this.getShell(), "opakowanie usuniete.");
                }
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean recordUpdated(Object record) {
            DodOpakC ddo = new DodOpakC(PokazWszystkichOpakowan.this.getParent());
            try {
                OpakKartM res = ddo.dodOpak((OpakKartM)record);
                if (res != null) {
                    DodIF Dod = Common.getDodClient();
                    Dod.poprawOpakowanie(res);
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                SwtCommon.safeDispose(ddo);
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean recordInserted() {
            DodOpakC d = new DodOpakC(PokazWszystkichOpakowan.this.getParent());
            try {
                OpakKartM o = d.dodOpak(null);
                if (o == null) {
                    boolean bl = false;
                    return bl;
                }
                DodIF Dod = Common.getDodClient();
                String res = Dod.dodajOpakowanie(o);
                SwtCommon.alert(PokazWszystkichOpakowan.this.getShell(), "dodane opakowanie: " + res);
            }
            finally {
                SwtCommon.safeDispose(d);
            }
            return true;
        }
    }
}

