/*
 * Decompiled with CFR 0.152.
 */
package ekspert.mobile.common.przeglady;

import base.data.ColumnDef;
import base.data.StringDataGetter;
import ekspert.mobile.ContC;
import ekspert.mobile.UtilsM;
import ekspert.mobile.common.inw.ArkInw;
import ekspert.mobile.common.inw.DokInw;
import ekspert.mobile.common.przeglady.base.RecordSelectionComposite;

class WyborArkuszaInw
extends RecordSelectionComposite {
    private ColumnDef[] columnsDef;

    public WyborArkuszaInw(ContC parent) {
        super(parent);
    }

    protected String getTitle() {
        return "arkusze";
    }

    public ArkInw wybierzArkusz(ArkInw[] arkusze, DokInw dok) {
        this.setTitle("Arkusze: " + dok.opisInw);
        return (ArkInw)this.getChoosenRecord(arkusze);
    }

    protected ColumnDef[] getColumnsDef() {
        if (this.columnsDef != null) {
            return this.columnsDef;
        }
        ColumnDef nrColumnDef = new ColumnDef("Nr", 20, new StringDataGetter(){

            public String getData(Object record) {
                ArkInw ark = (ArkInw)record;
                return Integer.toString(ark.nr_arkusza);
            }
        });
        ColumnDef dataColumnDef = new ColumnDef("Data", 20, new StringDataGetter(){

            public String getData(Object record) {
                ArkInw ark = (ArkInw)record;
                return UtilsM.sdf_ymd.format(ark.dataUtworzenia);
            }
        });
        ColumnDef descColumnDef = new ColumnDef("Opis", 20, new StringDataGetter(){

            public String getData(Object record) {
                ArkInw ark = (ArkInw)record;
                return UtilsM.ifNull(ark.opis);
            }
        });
        this.columnsDef = new ColumnDef[]{nrColumnDef, dataColumnDef, descColumnDef};
        return this.columnsDef;
    }
}

