/*
 * Decompiled with CFR 0.152.
 */
package ekspert.mobile.common.przeglady;

import base.controls.ControlFactory;
import base.controls.ExtendedLabel;
import base.data.ColumnDef;
import base.data.RowConfiguration;
import base.data.RowConfigurator;
import base.data.StringDataGetter;
import ekspert.mobile.Common;
import ekspert.mobile.ContC;
import ekspert.mobile.common.PolaFiltruDok;
import ekspert.mobile.common.obj.NaglM;
import ekspert.mobile.common.przeglady.base.DocumentSelectionComposite;
import ekspert.mobile.common.wer.WerClientConfig;
import ekspert.mobile.common.wer.WerIF;
import ekspert.mobile.gui.DateDialog;
import ekspert.mobile.gui.SwtCommon;
import java.util.ArrayList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class WyborDokumentuDoWeryf
extends DocumentSelectionComposite {
    private boolean trybPrzyjecia;
    private ExtendedLabel label4;
    private Text numerDokTxt;
    private Button szukajBtn;
    private Button dateBtn;
    private ColumnDef[] columnsDef;
    private RowConfigurator rowConfigurator = new RowConfigurator(){
        Color blue;
        Color red;
        Color green;
        RowConfiguration configuration;
        {
            Shell shell = WyborDokumentuDoWeryf.this.getShell();
            Display display = shell.getDisplay();
            this.blue = display.getSystemColor(9);
            this.red = display.getSystemColor(3);
            this.green = display.getSystemColor(5);
            this.configuration = new RowConfiguration(){

                public Color getForeground(Object record) {
                    NaglM n = (NaglM)record;
                    if (n.status != null) {
                        if (n.status.indexOf("NZ") > -1) {
                            return blue;
                        }
                        if (n.status.indexOf("BW") > -1) {
                            return red;
                        }
                        if (n.status.indexOf("OK") > -1) {
                            return green;
                        }
                    }
                    return null;
                }
            };
        }

        public RowConfiguration getConfiguration(Object record) {
            return this.configuration;
        }
    };

    public WyborDokumentuDoWeryf(ContC parent, boolean trybPrzyjecia) {
        super(parent, "");
        this.trybPrzyjecia = trybPrzyjecia;
        this.documentFilter.pozwolCecha = true;
    }

    protected String getTitle() {
        return "Dokumenty do weryfikacji";
    }

    protected boolean hasSelection() {
        return false;
    }

    protected Control getFocusableControl() {
        return this.numerDokTxt;
    }

    protected void initTitleArea(Composite parent) {
        SelectionAdapter selAd2 = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent evt) {
                if (evt.getSource() == WyborDokumentuDoWeryf.this.numerDokTxt) {
                    WyborDokumentuDoWeryf.this.szukajBtnWidgetSelected();
                }
            }

            public void widgetSelected(SelectionEvent evt) {
                if (evt.getSource() == WyborDokumentuDoWeryf.this.szukajBtn) {
                    WyborDokumentuDoWeryf.this.szukajBtnWidgetSelected();
                } else if (evt.getSource() == WyborDokumentuDoWeryf.this.dateBtn) {
                    WyborDokumentuDoWeryf.this.datyBtnWidgetSelected();
                }
            }
        };
        this.label4 = ControlFactory.createLabel(parent, 0);
        this.label4.setText("Nr dok.:");
        this.numerDokTxt = new Text(parent, 2048);
        RowData numerDokTxtLData = new RowData();
        numerDokTxtLData.width = 65;
        numerDokTxtLData.height = 14;
        this.numerDokTxt.setLayoutData((Object)numerDokTxtLData);
        this.numerDokTxt.addSelectionListener((SelectionListener)selAd2);
        this.szukajBtn = new Button(parent, 0x1000008);
        this.szukajBtn.setText("Szukaj");
        RowData button2LData = new RowData();
        button2LData.width = 52;
        button2LData.height = 24;
        this.szukajBtn.setLayoutData((Object)button2LData);
        this.szukajBtn.addSelectionListener((SelectionListener)selAd2);
        this.dateBtn = new Button(parent, 0x1000008);
        RowData dateBtnLData = new RowData();
        dateBtnLData.width = 47;
        dateBtnLData.height = 24;
        this.dateBtn.setLayoutData((Object)dateBtnLData);
        this.dateBtn.setText("Daty");
        this.dateBtn.addSelectionListener((SelectionListener)selAd2);
    }

    protected void szukajBtnWidgetSelected() {
        String wpisano = this.numerDokTxt.getText();
        if (wpisano.length() == 0) {
            wpisano = null;
        }
        WerIF werClient = Common.getWerClient();
        this.numerDokTxt.setText("");
        Object[] dokumenty = werClient.szukajDokumentow2(wpisano, null, this.trybPrzyjecia);
        if (dokumenty == null) {
            return;
        }
        if (dokumenty.length == 1) {
            this.setShownRecords(dokumenty);
            this.listaTable.select(0);
            this.wybierzBtnWS();
            return;
        }
        this.setShownRecords(dokumenty);
        this.numerDokTxt.setFocus();
    }

    protected void datyBtnWidgetSelected() {
        String wybrana_data = DateDialog.showDateDialog(this.getShell(), "Podaj dat\u0119 dokumentu");
        if (wybrana_data.length() == 0) {
            return;
        }
        WerIF werClient = Common.getWerClient();
        Object[] zDaty = werClient.szukajDokumentow2(null, wybrana_data, this.trybPrzyjecia);
        if (zDaty == null) {
            return;
        }
        if (zDaty.length == 0) {
            SwtCommon.alert(this.getShell(), "brak dokument\u00f3w z wybranej daty");
            return;
        }
        this.setShownRecords(zDaty);
        this.numerDokTxt.setFocus();
    }

    public NaglM wybierzDokument(Integer fontSize) {
        boolean pominListeDokumentow = Common.getWerCC().pominListeDokumentow;
        if (fontSize != null) {
            SwtCommon.setConrolFontSize((Control)this.listaTable, fontSize);
        }
        Object[] initList = new NaglM[]{};
        if (!pominListeDokumentow) {
            initList = Common.getWerClient().szukajDokumentow2(null, null, this.trybPrzyjecia);
            if (initList == null) {
                return null;
            }
            if (initList.length > 0) {
                Object ostatni = initList[initList.length - 1];
                if (((NaglM)ostatni).id == -1) {
                    SwtCommon.alert(this.getShell(), "wy\u015bwietlono pierwsze " + (initList.length - 1) + " dokument\u00f3w z " + ((NaglM)ostatni).status + ". Spr\u00f3buj wybra\u0107 dokumenty z jednego dnia.");
                    NaglM[] newInitList = new NaglM[initList.length - 1];
                    System.arraycopy(initList, 0, newInitList, 0, newInitList.length);
                    initList = newInitList;
                }
            }
        }
        return (NaglM)this.getChoosenRecord(initList);
    }

    protected ColumnDef[] getColumnsDef() {
        if (this.columnsDef != null) {
            return this.columnsDef;
        }
        ArrayList<ColumnDef> cols = new ArrayList<ColumnDef>();
        cols.add(new ColumnDef("Dok", 21, new StringDataGetter(){

            public String getData(Object record) {
                return ((NaglM)record).sdd;
            }
        }));
        cols.add(new ColumnDef("Nr", 51, new StringDataGetter(){

            public String getData(Object record) {
                NaglM n = (NaglM)record;
                return WyborDokumentuDoWeryf.this.trybPrzyjecia ? n.nrDokZ : n.nrDokW;
            }
        }));
        cols.add(new ColumnDef("Data", 63, new StringDataGetter(){

            public String getData(Object record) {
                return ((NaglM)record).data;
            }
        }));
        cols.add(new ColumnDef("St", 25, new StringDataGetter(){

            public String getData(Object record) {
                return ((NaglM)record).status;
            }
        }));
        cols.add(new ColumnDef("Kontr", 10, new StringDataGetter(){

            public String getData(Object record) {
                return ((NaglM)record).kontrah;
            }
        }));
        WerClientConfig conf = Common.getWerCC();
        if (conf.jestDodatkowaCechaDok) {
            cols.add(new ColumnDef("Cecha", 10, new StringDataGetter(){

                public String getData(Object record) {
                    return ((NaglM)record).cecha;
                }
            }));
        }
        this.columnsDef = cols.toArray(new ColumnDef[cols.size()]);
        return this.columnsDef;
    }

    protected RowConfigurator getRowConfigurator() {
        return this.rowConfigurator;
    }

    protected void setFiltr(PolaFiltruDok newFilter) {
        if (newFilter == null) {
            this.setShownRecords(this.getInitialArray());
            return;
        }
        Object[] initArray = this.getInitialArray();
        ArrayList<NaglM> filtrowanaLista = new ArrayList<NaglM>();
        for (int i = 0; i < initArray.length; ++i) {
            NaglM dok = (NaglM)initArray[i];
            if (!newFilter.match(dok.nrDokW, dok.data, dok.kontrah, "", dok.cecha)) continue;
            filtrowanaLista.add(dok);
        }
        Object[] aa = NaglM.cast(filtrowanaLista.toArray());
        this.setShownRecords(aa);
    }
}

