/*
 * Decompiled with CFR 0.152.
 */
package ekspert.mobile.common.przeglady;

import base.classes.ScanMatcher;
import base.composites.BaseTableUtils;
import base.data.ColumnDef;
import base.data.StringDataGetter;
import ekspert.mobile.Common;
import ekspert.mobile.ContC;
import ekspert.mobile.UtilsM;
import ekspert.mobile.common.obj.Dostawa;
import ekspert.mobile.common.przeglady.base.RecordSelectionComposite;
import ekspert.mobile.common.spr.SprClientConfig;
import java.util.ArrayList;

class WyborDostawyC
extends RecordSelectionComposite {
    private Dostawa selectedDostawa;
    private ColumnDef[] columnsDef;

    public WyborDostawyC(ContC parent) {
        super(parent);
    }

    protected String getTitle() {
        return "Wybierz dostaw\u0119";
    }

    protected Object getSelectedRecord() {
        if (this.selectedDostawa != null) {
            return this.selectedDostawa;
        }
        return super.getSelectedRecord();
    }

    protected ScanMatcher getScanMatcher() {
        return new DostawaScanner();
    }

    public Dostawa wybierzDostawe(Dostawa[] initList, String title) {
        if (!UtilsM.napisPustyLubTylkoSpacje(title)) {
            this.setTitle(title);
        }
        return (Dostawa)this.getChoosenRecord(initList);
    }

    protected ColumnDef[] getColumnsDef() {
        boolean hasAdditionalColumn;
        if (this.columnsDef != null) {
            return this.columnsDef;
        }
        SprClientConfig sprConfig = Common.getSprCC();
        ArrayList<ColumnDef> columns = new ArrayList<ColumnDef>();
        columns.add(new ColumnDef("Ilo\u015b\u0107", 20, new StringDataGetter(){

            public String getData(Object record) {
                return UtilsM.formatDoubleIlosc(((Dostawa)record).ilosc);
            }
        }));
        columns.add(new ColumnDef("D.wa\u017cno\u015bci", 20, new StringDataGetter(){

            public String getData(Object record) {
                return UtilsM.ifNull(((Dostawa)record).dataWazn);
            }
        }));
        columns.add(new ColumnDef("Nr.partii", 20, new StringDataGetter(){

            public String getData(Object record) {
                return ((Dostawa)record).nrDost;
            }
        }));
        columns.add(new ColumnDef("D.dostawy", 20, new StringDataGetter(){

            public String getData(Object record) {
                return ((Dostawa)record).dataDost;
            }
        }));
        if (sprConfig.pokazujCeneDostawy) {
            columns.add(new ColumnDef("Cena Zak.", 20, new StringDataGetter(){

                public String getData(Object record) {
                    return UtilsM.formatDoubleIlosc(((Dostawa)record).cenaZak);
                }
            }));
        }
        columns.add(new ColumnDef("Kontrah", 20, new StringDataGetter(){

            public String getData(Object record) {
                return ((Dostawa)record).kontrah;
            }
        }));
        boolean bl = hasAdditionalColumn = !UtilsM.napisPustyLubTylkoSpacje(sprConfig.dostPole2);
        if (hasAdditionalColumn) {
            columns.add(new ColumnDef(sprConfig.dostPole2, 20, new StringDataGetter(){

                public String getData(Object record) {
                    return ((Dostawa)record).pole2;
                }
            }));
        }
        this.columnsDef = BaseTableUtils.castColumns(columns);
        return this.columnsDef;
    }

    private class DostawaScanner
    implements ScanMatcher {
        boolean correct;
        String searchedText;

        private DostawaScanner() {
        }

        public boolean matches(Object item) {
            if (!this.correct) {
                return false;
            }
            if (item == null) {
                return false;
            }
            Dostawa dostawa = (Dostawa)item;
            return this.searchedText.equalsIgnoreCase(dostawa.nrDost);
        }

        public void initializeSearch(String text) {
            this.correct = !UtilsM.napisPustyLubTylkoSpacje(text);
            this.searchedText = UtilsM.ifNull(text);
        }

        public void processFoundRecord(Object item) {
            WyborDostawyC.this.selectedDostawa = (Dostawa)item;
            WyborDostawyC.this.zakonczUI();
        }

        public String getNotFoundMessage() {
            return "Nie znaleziono dostawy o nrPartii :" + this.searchedText;
        }
    }
}

