/*
 * Decompiled with CFR 0.152.
 */
package ekspert.mobile.common.przeglady;

import base.data.ColumnDef;
import base.data.StringDataGetter;
import ekspert.mobile.ContC;
import ekspert.mobile.UtilsM;
import ekspert.mobile.common.obj.OpakKartM;
import ekspert.mobile.common.przeglady.base.RecordSelectionComposite;

class WyborOpakowania
extends RecordSelectionComposite {
    private OpakKartM defaultPackage;
    private ColumnDef[] columnsDef;

    public WyborOpakowania(ContC parent) {
        super(parent);
    }

    protected String getTitle() {
        return "Lista opakowa\u0144:";
    }

    public OpakKartM wybierzOpakowanie(OpakKartM[] initList, String indeks, OpakKartM defaultPackage) {
        this.defaultPackage = defaultPackage;
        String title = "Lista opakowa\u0144 dla " + indeks;
        if (!UtilsM.napisPustyLubTylkoSpacje(title)) {
            this.setTitle(title);
        }
        return (OpakKartM)this.getChoosenRecord(initList);
    }

    protected ColumnDef[] getColumnsDef() {
        if (this.columnsDef != null) {
            return this.columnsDef;
        }
        ColumnDef nameColumnDef = new ColumnDef("Nazwa", 20, new StringDataGetter(){

            public String getData(Object record) {
                OpakKartM currentPackage = (OpakKartM)record;
                boolean isDefault = false;
                if (WyborOpakowania.this.defaultPackage != null) {
                    isDefault = currentPackage.id == currentPackage.id;
                }
                return isDefault ? "* " + currentPackage.nazwa : currentPackage.nazwa;
            }
        });
        ColumnDef qtyColumnDef = new ColumnDef("Ilo\u015b\u0107", 80, new StringDataGetter(){

            public String getData(Object record) {
                return UtilsM.formatDoubleIlosc(((OpakKartM)record).ileWopak);
            }
        });
        this.columnsDef = new ColumnDef[]{nameColumnDef, qtyColumnDef};
        return this.columnsDef;
    }

    protected void setShownRecords(Object[] records) {
        super.setShownRecords(records);
        boolean hasRecords = false;
        if (records != null) {
            boolean bl = hasRecords = records.length > 0;
        }
        if (!hasRecords) {
            this.setTitle("Kartoteka nie posiada opakowa\u0144");
        }
    }
}

