/*
 * Decompiled with CFR 0.152.
 */
package ekspert.mobile.common.przeglady.base;

import base.data.ColumnDef;
import base.data.RowConfigurator;
import base.data.StringDataGetter;
import ekspert.mobile.ContC;
import ekspert.mobile.common.PolaFiltruDok;
import ekspert.mobile.common.przeglady.base.DocumentSelectionComposite;
import ekspert.mobile.common.wpr.OUZnaglM;
import java.util.ArrayList;

public class DocumentOuzSelectionComposite
extends DocumentSelectionComposite {
    protected boolean ukryjNazwaDok;
    private ColumnDef[] columns;

    public DocumentOuzSelectionComposite(ContC parent, String initTilte) {
        super(parent, initTilte);
    }

    protected ColumnDef getOuzNrDocColumnDef() {
        return new ColumnDef("NrDok", 20, new StringDataGetter(){

            public String getData(Object record) {
                OUZnaglM d = (OUZnaglM)record;
                if (DocumentOuzSelectionComposite.this.ukryjNazwaDok) {
                    return d.nrdok;
                }
                return d.nazwadok + " " + d.nrdok;
            }
        });
    }

    protected ColumnDef getOuzDataDocColumnDef() {
        return new ColumnDef("Data", 20, new StringDataGetter(){

            public String getData(Object record) {
                return ((OUZnaglM)record).data;
            }
        });
    }

    protected ColumnDef getOuzKontrahColumnDef(String caption) {
        return new ColumnDef(caption, 20, new StringDataGetter(){

            public String getData(Object record) {
                OUZnaglM d = (OUZnaglM)record;
                if (d.nazwadok.equals("MM-")) {
                    return d.magazyn;
                }
                if (!d.wymagaKontrahenta()) {
                    return "";
                }
                return d.kontrah;
            }
        });
    }

    protected void setFiltr(PolaFiltruDok sourceFilter) {
        if (sourceFilter == null) {
            this.setShownRecords(this.getInitialArray());
            return;
        }
        Object[] initArray = this.getInitialArray();
        ArrayList<OUZnaglM> filtrowanaLista = new ArrayList<OUZnaglM>();
        for (int i = 0; i < initArray.length; ++i) {
            OUZnaglM ouzN = (OUZnaglM)initArray[i];
            if (!sourceFilter.match(ouzN.nrdok, ouzN.data, ouzN.kontrah, ouzN.magazyn, "")) continue;
            filtrowanaLista.add(ouzN);
        }
        Object[] aa = OUZnaglM.cast(filtrowanaLista.toArray());
        this.setShownRecords(aa);
    }

    protected ColumnDef[] getColumnsDef() {
        if (this.columns != null) {
            return this.columns;
        }
        this.columns = new ColumnDef[]{this.getOuzNrDocColumnDef(), this.getOuzDataDocColumnDef(), this.getOuzKontrahColumnDef(this.getKontrahColumnName())};
        return this.columns;
    }

    protected String getKontrahColumnName() {
        return "Kontrahent";
    }

    protected RowConfigurator getRowConfigurator() {
        return null;
    }
}

