/*
 * Decompiled with CFR 0.152.
 */
package ekspert.mobile.common.przeglady.base;

import base.data.ColumnDef;
import base.data.RowConfiguration;
import base.data.RowConfigurator;
import base.data.StringDataGetter;
import ekspert.mobile.Common;
import ekspert.mobile.ContC;
import ekspert.mobile.common.FiltrListaDokC;
import ekspert.mobile.common.PolaFiltruDok;
import ekspert.mobile.common.obj.NaglM;
import ekspert.mobile.common.przeglady.base.RecordSelectionComposite;
import ekspert.mobile.common.wpr.WprClientConfig;
import ekspert.mobile.gui.SwtCommon;
import java.util.ArrayList;
import org.eclipse.swt.graphics.Color;

public class DocumentSelectionComposite
extends RecordSelectionComposite {
    protected boolean pokazujSDD = true;
    protected PolaFiltruDok documentFilter = new PolaFiltruDok();
    private RowConfigurator rowConfigurator;
    private NaglM selectedDocument;

    public DocumentSelectionComposite(ContC parent, String initTilte) {
        super(parent);
        this.documentFilter.pozwolSkan = true;
        this.setTitle(initTilte);
    }

    protected RowConfigurator getRowConfigurator() {
        if (this.rowConfigurator != null) {
            return this.rowConfigurator;
        }
        this.rowConfigurator = new RowConfigurator(){
            Color gray;
            RowConfiguration cfg;
            {
                this.gray = DocumentSelectionComposite.this.getDisplay().getSystemColor(15);
                this.cfg = new RowConfiguration(){

                    public Color getForeground(Object record) {
                        NaglM dok = (NaglM)record;
                        if (dok.status.equals("...")) {
                            return gray;
                        }
                        return null;
                    }
                };
            }

            public RowConfiguration getConfiguration(Object record) {
                return this.cfg;
            }
        };
        return this.rowConfigurator;
    }

    protected ColumnDef getNrDocColumnDef() {
        return new ColumnDef("NrDok", 20, new StringDataGetter(){
            WprClientConfig wprCC;

            public String getData(Object record) {
                String nr;
                if (this.wprCC == null) {
                    this.wprCC = Common.getWprCC();
                }
                NaglM dok = (NaglM)record;
                String string = nr = this.wprCC.nrDokWew ? dok.nrDokW : dok.nrDokZ;
                if (DocumentSelectionComposite.this.pokazujSDD) {
                    nr = dok.sdd + " " + nr;
                }
                return nr;
            }
        });
    }

    protected ColumnDef getDataDocColumnDef() {
        return new ColumnDef("Data", 20, new StringDataGetter(){

            public String getData(Object record) {
                return ((NaglM)record).data;
            }
        });
    }

    protected ColumnDef getKontrahColumnDef(String caption) {
        return new ColumnDef(caption, 20, new StringDataGetter(){

            public String getData(Object record) {
                return ((NaglM)record).kontrah;
            }
        });
    }

    protected ColumnDef getTypDocColumnDef() {
        return new ColumnDef("Typ", 0, new StringDataGetter(){

            public String getData(Object record) {
                return ((NaglM)record).sdd;
            }
        });
    }

    protected boolean hasFilter() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performFilterAction() {
        System.out.println(this.getParent());
        PolaFiltruDok newFilter = null;
        FiltrListaDokC f = new FiltrListaDokC(this.contC);
        try {
            SwtCommon.centerOnParent(f);
            this.dolC.setEnabled(false);
            this.listaTable.setEnabled(false);
            newFilter = f.filtruj(this.documentFilter);
            if (this.isDisposed()) {
                return;
            }
            this.dolC.setEnabled(true);
            this.listaTable.setEnabled(true);
            if (newFilter == null) {
                return;
            }
        }
        finally {
            SwtCommon.safeDispose(f);
        }
        this.documentFilter = newFilter;
        if (this.documentFilter.isEmpty()) {
            this.setFiltr(null);
            this.filtrujBtn.setText("Filtruj");
            this.listaTable.setFocus();
            this.listaTable.select(0);
            return;
        }
        String scanned = this.documentFilter.skan;
        int indexOfScannedDoc = this.getIndexOfScannedDocument(this.getInitialArray(), scanned);
        if (indexOfScannedDoc >= 0) {
            this.setShownRecords(this.getInitialArray());
            this.listaTable.select(indexOfScannedDoc);
            this.filtrujBtn.setText("Filtruj");
            this.selectedDocument = (NaglM)this.getInitialArray()[indexOfScannedDoc];
            this.zakonczUI();
            return;
        }
        this.setFiltr(this.documentFilter);
        if (this.documentFilter.skan.length() == 0) {
            this.filtrujBtn.setText("Filtruj *");
        }
        this.listaTable.setFocus();
        this.listaTable.select(0);
    }

    protected Object getSelectedRecord() {
        if (this.selectedDocument != null) {
            return this.selectedDocument;
        }
        return super.getSelectedRecord();
    }

    protected void setFiltr(PolaFiltruDok sourceFilter) {
        if (sourceFilter == null) {
            this.setShownRecords(this.getInitialArray());
            return;
        }
        Object[] initArray = this.getInitialArray();
        ArrayList<NaglM> filtrowanaLista = new ArrayList<NaglM>();
        for (int i = 0; i < initArray.length; ++i) {
            NaglM naglM = (NaglM)initArray[i];
            if (!sourceFilter.match(naglM.nrDokW, naglM.data, naglM.kontrah, "", "")) continue;
            filtrowanaLista.add(naglM);
        }
        Object[] aa = NaglM.cast(filtrowanaLista.toArray());
        this.setShownRecords(aa);
    }

    protected int getIndexOfScannedDocument(Object[] listaNagl, String scanned) {
        if (scanned == null) {
            return -1;
        }
        if (scanned.length() <= 0) {
            return -1;
        }
        int skan_id = 0;
        try {
            skan_id = Integer.parseInt(scanned.trim());
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return -1;
        }
        for (int i = 0; i < listaNagl.length; ++i) {
            if (skan_id != ((NaglM)listaNagl[i]).id) continue;
            return i;
        }
        return -1;
    }
}

