/*
 * Decompiled with CFR 0.152.
 */
package ekspert.mobile.common.przeglady.base;

import base.classes.ScanMatcher;
import base.composites.BaseTableComposite;
import base.controls.ControlFactory;
import base.controls.ExtendedLabel;
import base.data.ColumnDef;
import base.data.RowConfigurator;
import ekspert.mobile.Common;
import ekspert.mobile.ContC;
import ekspert.mobile.Main;
import ekspert.mobile.UtilsM;
import ekspert.mobile.common.przeglady.base.RecordDataProvider;
import ekspert.mobile.common.przeglady.base.RecordDeleteAction;
import ekspert.mobile.common.przeglady.base.RecordInsertAction;
import ekspert.mobile.common.przeglady.base.RecordUpdateAction;
import ekspert.mobile.datamodel.ManagedArray;
import ekspert.mobile.datamodel.MobileRecords;
import ekspert.mobile.gui.CompositeDialog;
import ekspert.mobile.gui.SwtCommon;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RecordSelectionComposite
extends CompositeDialog {
    protected BaseTableComposite listaTable;
    private Object[] initialArray;
    protected Label tytulLab;
    protected Button powrocBtn;
    protected Button filtrujBtn;
    protected Button nowyBtn;
    protected Button wybierzBtn;
    protected Button refreshBtn;
    protected Composite dolC;
    protected Composite goraC;
    protected ContC contC;
    protected String frazaFiltru;
    protected Text scannedEan;
    private ScanMatcher scanMatcher;
    protected KeyListener keyAd = new KeyAdapter(){

        public void keyPressed(KeyEvent arg0) {
            if (arg0.character == '\u001b') {
                RecordSelectionComposite.this.powrocBtnWS();
            }
            if (arg0.character == '2' && RecordSelectionComposite.this.hasInsertAction()) {
                RecordSelectionComposite.this.performInsertAction();
            }
        }
    };
    SelectionAdapter selAd = new SelectionAdapter(){

        public void widgetDefaultSelected(SelectionEvent evt) {
            if (((Object)((Object)RecordSelectionComposite.this.listaTable)).equals(evt.getSource())) {
                RecordSelectionComposite.this.listaTableWDS();
            }
        }

        public void widgetSelected(SelectionEvent evt) {
            Object src = evt.getSource();
            if (src == null) {
                return;
            }
            if (src == RecordSelectionComposite.this.powrocBtn) {
                RecordSelectionComposite.this.powrocBtnWS();
            }
            if (src == RecordSelectionComposite.this.refreshBtn) {
                RecordSelectionComposite.this.performRefreshAction();
            }
            if (src == RecordSelectionComposite.this.filtrujBtn) {
                if (RecordSelectionComposite.this.hasDeleteAction()) {
                    RecordSelectionComposite.this.performDeleteAction();
                } else {
                    RecordSelectionComposite.this.performFilterAction();
                }
            }
            if (src == RecordSelectionComposite.this.wybierzBtn) {
                RecordSelectionComposite.this.wybierzBtnWS();
            }
            if (src == RecordSelectionComposite.this.nowyBtn) {
                RecordSelectionComposite.this.performInsertAction();
            }
        }
    };

    public RecordSelectionComposite(ContC parent) {
        super(parent, 2048);
        this.contC = parent;
        this.scanMatcher = this.getScanMatcher();
        this.initGUI();
    }

    protected void initGUI() {
        try {
            GridLayout thisLayout = new GridLayout();
            thisLayout.makeColumnsEqualWidth = true;
            thisLayout.horizontalSpacing = 2;
            thisLayout.marginHeight = 2;
            thisLayout.marginWidth = 2;
            thisLayout.verticalSpacing = 2;
            this.setLayout((Layout)thisLayout);
            this.goraC = new Composite((Composite)this, 0);
            RowLayout composite2Layout = new RowLayout(256);
            composite2Layout.center = true;
            composite2Layout.marginBottom = 0;
            composite2Layout.marginRight = 0;
            composite2Layout.marginTop = 0;
            composite2Layout.marginLeft = 0;
            this.goraC.setLayout((Layout)composite2Layout);
            this.initTitleArea(this.goraC);
            this.listaTable = new TableComposite(this, 68096);
            if (Common.magClientConf != null && Common.magClientConf.skroty) {
                this.listaTable.addKeyListener(this.keyAd);
            }
            GridData table1LData = new GridData();
            table1LData.horizontalAlignment = 4;
            table1LData.grabExcessVerticalSpace = true;
            table1LData.verticalAlignment = 4;
            this.listaTable.setLayoutData(table1LData);
            this.listaTable.addSelectionListener((SelectionListener)this.selAd);
            GridData composite1LData = new GridData();
            composite1LData.horizontalAlignment = 4;
            this.dolC = new Composite((Composite)this, 0);
            FillLayout composite1Layout = new FillLayout(256);
            this.dolC.setLayout((Layout)composite1Layout);
            this.dolC.setLayoutData((Object)composite1LData);
            this.powrocBtn = new Button(this.dolC, 0x1000008);
            this.powrocBtn.setText("Powr\u00f3\u0107");
            this.powrocBtn.addSelectionListener((SelectionListener)this.selAd);
            if (this.hasInsertAction()) {
                this.nowyBtn = new Button(this.dolC, 0x1000008);
                this.nowyBtn.setText("2. Nowy");
                this.nowyBtn.addSelectionListener((SelectionListener)this.selAd);
            }
            if (this.hasRefreshAction()) {
                this.refreshBtn = new Button(this.dolC, 0x1000008);
                this.refreshBtn.setText("Od\u015bwie\u017c");
                this.refreshBtn.addSelectionListener((SelectionListener)this.selAd);
            }
            this.filtrujBtn = new Button(this.dolC, 0x1000008);
            this.filtrujBtn.setText(this.hasDeleteAction() ? "Usu\u0144" : "Filtruj");
            this.filtrujBtn.addSelectionListener((SelectionListener)this.selAd);
            this.filtrujBtn.setVisible(this.hasFilter() || this.hasDeleteAction());
            this.wybierzBtn = new Button(this.dolC, 0x1000008);
            this.wybierzBtn.setText("Wybierz");
            this.wybierzBtn.addSelectionListener((SelectionListener)this.selAd);
            this.wybierzBtn.setEnabled(this.hasSelection() || this.hasDirectUpdateAction());
            this.layout();
            this.pack();
            this.setSize(Main.shellWidth, Main.containerHeight);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void initTitleArea(Composite parent) {
        if (this.scanMatcher != null) {
            this.initTitleArea4Scanning(parent);
            return;
        }
        this.tytulLab = ControlFactory.createLabel(parent, 0);
        this.tytulLab.setText(this.getTitle());
        RowData label3LData = new RowData();
        label3LData.width = 225;
        label3LData.height = 14;
        this.tytulLab.setLayoutData((Object)label3LData);
    }

    protected void initTitleArea4Scanning(Composite parent) {
        ExtendedLabel lblEan = ControlFactory.createLabel(parent, 0);
        lblEan.setText("Skan:");
        lblEan.setLayoutData(new RowData(25, -1));
        this.scannedEan = new Text(parent, 2048);
        this.scannedEan.addSelectionListener((SelectionListener)this.selAd);
        this.scannedEan.setLayoutData((Object)new RowData(140, -1));
        SelectionAdapter eanSelectionListener = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent evt) {
                if (RecordSelectionComposite.this.scannedEan.equals(evt.getSource())) {
                    RecordSelectionComposite.this.performDefaultScanning(RecordSelectionComposite.this.scannedEan.getText());
                }
            }
        };
        this.scannedEan.addSelectionListener((SelectionListener)eanSelectionListener);
        final Button btnSkanuj = new Button(parent, 0);
        btnSkanuj.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (btnSkanuj.equals(event.getSource())) {
                    RecordSelectionComposite.this.performDefaultScanning(RecordSelectionComposite.this.scannedEan.getText());
                }
            }
        });
        btnSkanuj.setLayoutData((Object)new RowData(50, -1));
        btnSkanuj.setText("Skanuj");
    }

    protected void performDefaultScanning(String enteredText) {
        ScanMatcher scanMatcher = this.getScanMatcher();
        if (UtilsM.napisPustyLubTylkoSpacje(enteredText)) {
            this.showScannedRecordNotFoundNotification(scanMatcher.getNotFoundMessage());
            return;
        }
        scanMatcher.initializeSearch(enteredText);
        Object foundRecord = this.listaTable.getFirstMatched(scanMatcher);
        if (foundRecord == null) {
            this.showScannedRecordNotFoundNotification(scanMatcher.getNotFoundMessage());
        } else {
            scanMatcher.processFoundRecord(foundRecord);
        }
    }

    protected void showScannedRecordNotFoundNotification(String message) {
        SwtCommon.alert(this.getShell(), message);
        this.scannedEan.selectAll();
        this.scannedEan.forceFocus();
    }

    protected void setTitle(String title) {
        if (this.tytulLab != null) {
            this.tytulLab.setText(title);
        }
    }

    public Object getChoosenRecord(Object[] initialArray) {
        if (initialArray == null) {
            return null;
        }
        this.initialArray = initialArray;
        this.updateFilterButtonCaption();
        this.setShownRecords(this.getFilteredRecords());
        this.listaTable.setSelection(0);
        this.runUI(this.getFocusableControl());
        if (this.isDisposed()) {
            return null;
        }
        Object record = this.getSelectedRecord();
        if (record == null) {
            return this.getRecordPretendingNoAction();
        }
        return record;
    }

    protected Control getFocusableControl() {
        return this.scanMatcher == null ? this.listaTable : this.scannedEan;
    }

    protected Object getSelectedRecord() {
        int ind = this.listaTable.getSelectionIndex();
        if (ind == -1) {
            return null;
        }
        return this.listaTable.getDataSet().getRecord(ind);
    }

    protected Object getRecordPretendingNoAction() {
        return null;
    }

    protected Object[] getInitialArray() {
        return this.initialArray;
    }

    protected void setShownRecords(Object[] records) {
        MobileRecords tableDataSet = new MobileRecords(new ManagedArray(records));
        this.listaTable.setDataSet(tableDataSet);
    }

    protected boolean hasFilter() {
        return false;
    }

    protected boolean hasSelection() {
        return true;
    }

    private boolean hasRefreshAction() {
        return this.getRecordRefreshAction() != null;
    }

    private boolean hasDeleteAction() {
        return this.getDeleteAction() != null;
    }

    private boolean hasInsertAction() {
        return this.getInsertAction() != null;
    }

    private boolean hasDirectUpdateAction() {
        return this.getDirectUpdateAction() != null && !this.hasSelection();
    }

    protected RecordDeleteAction getDeleteAction() {
        return null;
    }

    protected RecordInsertAction getInsertAction() {
        return null;
    }

    protected RecordUpdateAction getDirectUpdateAction() {
        return null;
    }

    protected RecordDataProvider getRecordRefreshAction() {
        return null;
    }

    protected String getTitle() {
        return "Lista znalezionych:";
    }

    protected ColumnDef[] getColumnsDef() {
        return null;
    }

    protected RowConfigurator getRowConfigurator() {
        return null;
    }

    protected String getPropertyFileName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean hasMultiRowVersion() {
        return Common.magClientConf.tblMode == 1;
    }

    protected void powrocBtnWS() {
        this.listaTable.deselectAll();
        this.zakonczUI = true;
    }

    protected void performFilterAction() {
    }

    protected void performRefreshAction() {
        RecordDataProvider recordRefreshAction = this.getRecordRefreshAction();
        if (recordRefreshAction != null) {
            this.setShownRecords(recordRefreshAction.getRecords());
        }
    }

    protected void performDeleteAction() {
        Object selectedRecord = this.getSelectedRecord();
        RecordDeleteAction deleteAction = this.getDeleteAction();
        if (deleteAction != null && selectedRecord != null && deleteAction.recordDeleted(selectedRecord)) {
            this.setShownRecords(deleteAction.getRecords());
        }
    }

    protected void performDirectUpdateAction() {
        Object selectedRecord = this.getSelectedRecord();
        RecordUpdateAction directUpdateAction = this.getDirectUpdateAction();
        if (directUpdateAction != null && selectedRecord != null && directUpdateAction.recordUpdated(selectedRecord)) {
            this.setShownRecords(directUpdateAction.getRecords());
        }
    }

    protected void performInsertAction() {
        RecordInsertAction insertAction = this.getInsertAction();
        if (insertAction != null && insertAction.recordInserted()) {
            this.setShownRecords(insertAction.getRecords());
        }
    }

    protected void listaTableWDS() {
        this.wybierzBtnWS();
    }

    protected void wybierzBtnWS() {
        if (this.hasDirectUpdateAction()) {
            this.performDirectUpdateAction();
            return;
        }
        int ind = this.listaTable.getSelectionIndex();
        if (ind == -1) {
            return;
        }
        this.zakonczUI = true;
    }

    protected void updateFilterButtonCaption() {
    }

    protected Object[] getFilteredRecords() {
        return this.getInitialArray();
    }

    protected ScanMatcher getScanMatcher() {
        return null;
    }

    private class TableComposite
    extends BaseTableComposite {
        public TableComposite(Composite parent, int style) {
            super(parent, style);
        }

        public ColumnDef[] getColumnsDef() {
            return RecordSelectionComposite.this.getColumnsDef();
        }

        public RowConfigurator getRowConfigurator() {
            return RecordSelectionComposite.this.getRowConfigurator();
        }

        public String getPropertyFileName() {
            return RecordSelectionComposite.this.getPropertyFileName();
        }

        public boolean hasMultiRowVersion() {
            return RecordSelectionComposite.this.hasMultiRowVersion();
        }
    }
}

