/*
 * Decompiled with CFR 0.152.
 */
package ekspert.mobile.common.tra;

import ekspert.mobile.BladSerweraException;
import ekspert.mobile.Http401Exc;
import ekspert.mobile.UtilsM;
import ekspert.mobile.common.tra.JRpcClientE;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.ConnectException;
import java.net.SocketException;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import javax.microedition.io.ConnectionNotFoundException;

public class JClientFactory {
    private static final int MAX_PONOWIEN = 3;
    private final JRpcClientE client;
    private boolean objectMethodLocal;
    private int licznikPonowien;
    private final Map opisyMetod;
    private String nextDescr;
    private long tStart;
    private Object shouldRetry = new Object();
    private Exception lastRemoteError;
    static /* synthetic */ Class class$java$lang$Object;

    public JClientFactory(JRpcClientE pClient, String plikOpisy) {
        this.client = pClient;
        Properties opisy = null;
        try {
            InputStream is = this.getClass().getResourceAsStream(plikOpisy);
            if (is == null) {
                System.err.println("nie znalazlem pliku " + plikOpisy);
            } else {
                opisy = new Properties();
                opisy.load(is);
                is.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("blad ladowania opisow: " + e);
            opisy = null;
        }
        this.opisyMetod = opisy;
    }

    public JRpcClientE getClient() {
        return this.client;
    }

    public Map getOpisy() {
        return this.opisyMetod;
    }

    public boolean isObjectMethodLocal() {
        return this.objectMethodLocal;
    }

    public void setObjectMethodLocal(boolean pObjectMethodLocal) {
        this.objectMethodLocal = pObjectMethodLocal;
    }

    public Object newInstance(Class pClass) {
        return this.newInstance(Thread.currentThread().getContextClassLoader(), pClass);
    }

    public Object newInstance(ClassLoader pClassLoader, Class pClass) {
        final String pRemoteName = pClass.getName();
        return Proxy.newProxyInstance(pClassLoader, new Class[]{pClass}, new InvocationHandler(){

            public Object invoke(Object pProxy, Method pMethod, Object[] pArgs) throws Throwable {
                if (JClientFactory.this.isObjectMethodLocal() && pMethod.getDeclaringClass().equals(class$java$lang$Object == null ? (class$java$lang$Object = JClientFactory.class$("java.lang.Object")) : class$java$lang$Object)) {
                    return pMethod.invoke(pProxy, pArgs);
                }
                String methodName = pMethod.getName();
                JClientFactory.this._getPokazOpis(pRemoteName, methodName);
                JClientFactory.this.licznikPonowien = 0;
                Object result = null;
                while ((result = JClientFactory.this.invoke2(pRemoteName, pProxy, pMethod, pArgs, methodName, result)) == JClientFactory.this.shouldRetry) {
                    JClientFactory.this.licznikPonowien++;
                }
                ((JClientFactory)JClientFactory.this).client.pierwszePolaczenie = false;
                return result;
            }
        });
    }

    protected boolean _alert2(String msg) {
        System.err.println(msg);
        return false;
    }

    protected void _alert(Exception e, String msg) {
        System.err.println(msg);
    }

    protected void _nieBusy() {
    }

    protected void _busy() {
    }

    public void _getPokazOpis(String pRemoteName, String methodName) {
        if (this.opisyMetod != null) {
            String opis;
            if (this.nextDescr != null) {
                opis = this.nextDescr;
            } else {
                opis = (String)this.opisyMetod.get(methodName);
                if (opis == null) {
                    System.err.println("brak opisu dla metody " + methodName + " w " + pRemoteName);
                    opis = " .. " + pRemoteName + "." + methodName + " .. ";
                }
            }
            this.nextDescr = null;
            this._pokazOpis(opis);
        }
    }

    protected void _pokazOpis(String opis) {
        System.out.println(opis);
    }

    protected void _zamknijOpis() {
    }

    public void _setNextDescr(String str) {
        this.nextDescr = str;
    }

    public Exception getLastRemoteError() {
        return this.lastRemoteError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invoke2(String pRemoteName, Object pProxy, Method pMethod, Object[] pArgs, String methodName, Object result) throws Exception, Throwable {
        try {
            this.tStart = new Date().getTime();
            this._busy();
            result = this.client.execute(pRemoteName, methodName, pArgs, pMethod.getReturnType());
            this._nieBusy();
        }
        catch (ConnectException e) {
            result = this.handleConnExc(e.getMessage(), e, "Connect", pProxy, pMethod, pArgs);
        }
        catch (SocketException e) {
            result = this.handleConnExc(e.getMessage(), e, "Socket", pProxy, pMethod, pArgs);
        }
        catch (ConnectionNotFoundException e) {
            result = this.handleConnExc(e.getMessage(), (Exception)((Object)e), "ConnectionNotFound", pProxy, pMethod, pArgs);
        }
        catch (UndeclaredThrowableException e) {
            this.handleRemExc("blad UndeclaredThrowable:\n", e);
        }
        catch (BladSerweraException e) {
            this.handleRemExc("blad serwera:\n", e);
        }
        catch (RemoteException e) {
            this.handleRemExc("blad serwera:\n", e);
        }
        catch (IOException e) {
            System.err.println("JClientFactory.invoke2 IOException (" + e.getClass().getName() + "): " + e.getMessage());
            result = null;
        }
        finally {
            this._zamknijOpis();
        }
        return result;
    }

    private void handleRemExc(String title, Exception e) throws Http401Exc {
        this._alert(e, title + e.getMessage());
        this.lastRemoteError = e;
        if (e instanceof Http401Exc) {
            throw (Http401Exc)e;
        }
    }

    protected Object handleConnExc(String msg, Exception e, String blad, Object pProxy, Method pMethod, Object[] pArgs) throws Throwable {
        long timeout = new Date().getTime() - this.tStart;
        System.out.println("timeout: " + timeout);
        if (this.client.pierwszePolaczenie) {
            throw e;
        }
        if (this.client.ostatniePolaczenie) {
            return null;
        }
        if (this.licznikPonowien < 3) {
            System.out.println("auto retry " + this.licznikPonowien);
            UtilsM.sleep(1000);
            return this.shouldRetry;
        }
        if (this._alert2("blad po\u0142\u0105czenia " + blad + "\n" + msg + "\n" + timeout + "\n")) {
            this._zamknijOpis();
            return this.shouldRetry;
        }
        return null;
    }
}

