/*
 * Decompiled with CFR 0.152.
 */
package ekspert.mobile.common.tra;

import ekspert.mobile.BladSerweraException;
import ekspert.mobile.Http401Exc;
import ekspert.mobile.HttpNo200Exc;
import ekspert.mobile.UtilsM;
import ekspert.mobile.datamodel.json.JsonLib;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.text.ParseException;
import java.util.Date;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import sun.misc.BASE64Encoder;

public class JRpcClientE {
    boolean pierwszePolaczenie = true;
    boolean ostatniePolaczenie = false;
    private static final String SET_COOKIE = "Set-Cookie";
    String url;
    boolean debug = true;
    boolean trace = false;
    private String sessionCookie;
    private String authData;

    public JRpcClientE(String url) {
        this.url = url;
    }

    public JRpcClientE(String url, boolean debug, boolean trace) {
        this.url = url;
        this.debug = debug;
        this.trace = trace;
        UtilsM.log("JRpcClientE: " + url);
    }

    public Object execute(String serviceName, String method, Object[] params, Class returnType) throws Exception {
        String xmlData;
        HttpConnection con = null;
        InputStream in = null;
        OutputStream out = null;
        try {
            String qStr = "?s=" + serviceName + "&m=" + method;
            if (this.debug) {
                UtilsM.log("JRpcClientE: " + qStr);
            }
            String myUrl = this.url + qStr;
            con = (HttpConnection)Connector.open((String)myUrl, (int)3, (boolean)true);
            con.setRequestMethod("POST");
            if (this.sessionCookie != null) {
                con.setRequestProperty("Cookie", this.sessionCookie);
            } else {
                con.setRequestProperty("Authorization", this.authData);
            }
            String requestStr = "a1=" + JsonLib.writeArgsAsString(params);
            if (this.trace) {
                System.out.println(requestStr);
            }
            byte[] request = requestStr.getBytes("UTF-8");
            out = con.openOutputStream();
            out.write(request);
            long stRsp = new Date().getTime();
            in = con.openInputStream();
            long stpRsp = new Date().getTime();
            int responseCode = con.getResponseCode();
            if (this.debug) {
                UtilsM.log("JRpcClientE: response " + responseCode + ", " + (stpRsp - stRsp) + "ms " + con.getResponseMessage() + ", type " + con.getType() + ", available " + in.available());
            }
            xmlData = this.convertStreamToString(in);
            Runtime.getRuntime().gc();
            if (this.trace) {
                System.out.println(xmlData);
            }
            if (responseCode != 200) {
                if (this.sessionCookie == null && responseCode == 403) {
                    throw new Http401Exc(xmlData);
                }
                if (responseCode == 401) {
                    throw new Http401Exc(xmlData);
                }
                UtilsM.logE("JRpcClientE: responseCode != 200: " + responseCode);
                System.err.println(xmlData);
                throw new HttpNo200Exc(responseCode, xmlData);
            }
            if (this.sessionCookie == null) {
                this.sessionCookie = con.getHeaderField(SET_COOKIE);
                if (this.debug) {
                    System.out.println("debug nowa sesja " + this.sessionCookie);
                }
            }
            if (xmlData.startsWith("E ")) {
                if (xmlData.startsWith(Http401Exc.class.getName(), 2)) {
                    throw new Http401Exc(xmlData.substring(2 + Http401Exc.class.getName().length()));
                }
                if (xmlData.startsWith(BladSerweraException.class.getName(), 2)) {
                    throw new BladSerweraException(xmlData.substring(2 + BladSerweraException.class.getName().length()));
                }
                throw new RemoteException(xmlData);
            }
            if (!xmlData.startsWith("O ")) {
                throw new ParseException("odpowiedz serwera ani OK ani ERR: '" + xmlData + "', dlugosc: " + Integer.toString(xmlData.length()), 1);
            }
            this.silentClose(con, in, out);
        }
        catch (Exception x) {
            try {
                UtilsM.log("JRpcClientE: Exception " + x);
                UtilsM.logE("JRpcClientE: Exception " + x);
                x.printStackTrace();
                throw x;
            }
            catch (Throwable throwable) {
                this.silentClose(con, in, out);
                throw throwable;
            }
        }
        long startParse = new Date().getTime();
        String result2 = xmlData.substring(2).trim();
        Object result = JsonLib.getValue(returnType, result2);
        if (this.debug) {
            System.out.println("parsing: " + (new Date().getTime() - startParse) + "ms");
        }
        if (result instanceof Exception) {
            throw (Exception)result;
        }
        return result;
    }

    protected void silentClose(HttpConnection con, InputStream in, OutputStream out) {
        try {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
            if (con != null) {
                con.close();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String convertStreamToString(InputStream is) throws IOException {
        StringBuffer sb = null;
        String firstLine = null;
        if (is != null) {
            try {
                String tmpLine;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((tmpLine = reader.readLine()) != null) {
                    if (firstLine == null) {
                        firstLine = tmpLine;
                        continue;
                    }
                    if (sb == null) {
                        sb = new StringBuffer();
                        sb.append(firstLine);
                    }
                    sb.append(tmpLine);
                }
                if (sb != null) {
                    String string = sb.toString();
                    return string;
                }
                String string = firstLine;
                return string;
            }
            finally {
                is.close();
            }
        }
        return "";
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public String setAuthData(String user, String pass) {
        String userPassword = user + ":" + pass;
        this.authData = "Basic " + new BASE64Encoder().encode(userPassword.getBytes());
        this.sessionCookie = null;
        return this.authData;
    }

    public void setSession(String sesjaCiastko) {
        this.sessionCookie = sesjaCiastko;
    }

    public String getSession() {
        return this.sessionCookie;
    }

    public void setLastConn() {
        this.ostatniePolaczenie = true;
    }
}

