/*
 * Decompiled with CFR 0.152.
 */
package ekspert.mobile.common.tra;

import ekspert.mobile.BladSerweraException;
import ekspert.mobile.HttpNo200Exc;
import ekspert.mobile.UtilsM;
import ekspert.mobile.datamodel.json.JsonLib;
import ekspert.mobile.datamodel.json.MemOpt_JsonLib;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Date;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import sun.misc.BASE64Encoder;

public class MemOpt_JRpcClientE {
    boolean pierwszePolaczenie = true;
    boolean ostatniePolaczenie = false;
    private static final String SET_COOKIE = "Set-Cookie";
    String url;
    boolean debug = true;
    boolean trace = false;
    private String sessionCookie;
    private String authData;
    private static final String NO_DATA = "<..>";

    public MemOpt_JRpcClientE(String url) {
        this.url = url;
    }

    public MemOpt_JRpcClientE(String url, boolean debug, boolean trace) {
        this.url = url;
        this.debug = debug;
        this.trace = trace;
        UtilsM.log("JRpcClientE: " + url);
    }

    public Object execute(String serviceName, String method, Object[] params, Class returnType) throws Exception {
        Object result = null;
        HttpConnection con = null;
        InputStream in = null;
        OutputStream out = null;
        try {
            String qStr = "?s=" + serviceName + "&m=" + method;
            if (this.debug) {
                UtilsM.log("JRpcClientE: " + qStr);
            }
            String myUrl = this.url + qStr;
            con = (HttpConnection)Connector.open((String)myUrl, (int)3, (boolean)true);
            con.setRequestMethod("POST");
            if (this.sessionCookie != null) {
                con.setRequestProperty("Cookie", this.sessionCookie);
            } else {
                con.setRequestProperty("Authorization", this.authData);
            }
            String requestStr = "a1=" + JsonLib.writeArgsAsString(params);
            if (this.trace) {
                System.out.println(requestStr);
            }
            byte[] request = requestStr.getBytes("UTF-8");
            out = con.openOutputStream();
            out.write(request);
            long stRsp = new Date().getTime();
            in = con.openInputStream();
            long stpRsp = new Date().getTime();
            int responseCode = con.getResponseCode();
            if (this.debug) {
                UtilsM.log("JRpcClientE: response " + responseCode + ", " + (stpRsp - stRsp) + "ms " + con.getResponseMessage() + ", type " + con.getType() + ", available " + in.available());
            }
            if (responseCode != 200) {
                if (this.sessionCookie == null && responseCode == 403) {
                    throw new HttpNo200Exc(responseCode, NO_DATA);
                }
                throw new HttpNo200Exc(responseCode, NO_DATA);
            }
            if (this.sessionCookie == null) {
                this.sessionCookie = con.getHeaderField(SET_COOKIE);
                if (this.debug) {
                    System.out.println("debug nowa sesja " + this.sessionCookie);
                }
            }
            result = MemOpt_JsonLib.getObjectImportedFromJson(new InputStreamReader(in), returnType);
            this.silentClose(con);
            this.silentClose(in);
            this.silentClose(out);
        }
        catch (Exception x) {
            try {
                UtilsM.log("JRpcClientE: Exception " + x);
                UtilsM.logE("JRpcClientE: Exception " + x);
                x.printStackTrace();
                throw x;
            }
            catch (Throwable throwable) {
                this.silentClose(con);
                this.silentClose(in);
                this.silentClose(out);
                throw throwable;
            }
        }
        if (result != null && result instanceof Exception) {
            throw new BladSerweraException((Exception)result);
        }
        return result;
    }

    protected void silentClose(OutputStream os) {
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    protected void silentClose(InputStream is) {
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    protected void silentClose(HttpConnection con) {
        try {
            if (con != null) {
                con.close();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String convertStreamToString(InputStream is) throws IOException {
        StringBuffer sb = null;
        String firstLine = null;
        if (is != null) {
            try {
                String tmpLine;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((tmpLine = reader.readLine()) != null) {
                    if (firstLine == null) {
                        firstLine = tmpLine;
                        continue;
                    }
                    if (sb == null) {
                        sb = new StringBuffer();
                        sb.append(firstLine);
                    }
                    sb.append(tmpLine);
                }
                if (sb != null) {
                    String string = sb.toString();
                    return string;
                }
                String string = firstLine;
                return string;
            }
            finally {
                is.close();
            }
        }
        return "";
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public String setAuthData(String user, String pass) {
        String userPassword = user + ":" + pass;
        this.authData = "Basic " + new BASE64Encoder().encode(userPassword.getBytes());
        this.sessionCookie = null;
        return this.authData;
    }

    public void setSession(String sesjaCiastko) {
        this.sessionCookie = sesjaCiastko;
    }

    public String getSession() {
        return this.sessionCookie;
    }

    public void setLastConn() {
        this.ostatniePolaczenie = true;
    }
}

