/*
 * Decompiled with CFR 0.152.
 */
package ekspert.mobile.datamodel;

import ekspert.mobile.util.Matcher;
import ekspert.mobile.util.Visitor;
import java.util.ArrayList;

public class ManagedArray {
    private Object[] array;
    private ArrayList list;

    public ManagedArray(Object[] array) {
        this.array = array;
    }

    public boolean isCorrect() {
        return this.array != null;
    }

    public int getRecordCount() {
        return this.array.length + this.getListSize();
    }

    private int getListSize() {
        if (this.list == null) {
            return 0;
        }
        return this.list.size();
    }

    public Object getItem(int index) {
        if (index < this.array.length) {
            return this.array[index];
        }
        return this.list.get(index - this.array.length);
    }

    public void setItem(int index, Object item) {
        if (index < this.array.length) {
            this.array[index] = item;
        } else {
            this.list.set(index - this.array.length, item);
        }
    }

    public void addItem(Object item) {
        if (this.list == null) {
            this.list = new ArrayList();
        }
        this.list.add(item);
    }

    public void removeItem(Object item) {
        int index;
        if (this.list != null) {
            for (index = 0; index < this.list.size(); ++index) {
                if (!this.list.get(index).equals(item)) continue;
                this.list.remove(index);
                return;
            }
        }
        if (this.array != null) {
            for (index = 0; index < this.array.length; ++index) {
                if (!this.array[index].equals(item)) continue;
                Object[] newArray = new Object[this.array.length - 1];
                if (index > 0) {
                    System.arraycopy(this.array, 0, newArray, 0, index);
                }
                if (index != this.array.length - 1) {
                    System.arraycopy(this.array, index + 1, newArray, index, this.array.length - index - 1);
                }
                this.array = newArray;
            }
        }
    }

    public void visitAll(Visitor visitor) {
        int count = this.getRecordCount();
        for (int index = 0; index < count && visitor.visit(this.getItem(index)); ++index) {
        }
    }

    public Object findFirstMatched(Matcher matcher) {
        int count = this.getRecordCount();
        for (int index = 0; index < count; ++index) {
            Object item = this.getItem(index);
            if (!matcher.matches(item)) continue;
            return item;
        }
        return null;
    }
}

