/*
 * Decompiled with CFR 0.152.
 */
package ekspert.mobile.datamodel.json;

import ekspert.mobile.datamodel.json.JSONable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Date;
import org.json.me.JSONArray;
import org.json.me.JSONException;
import org.json.me.JSONObject;

public class JsonLib {
    public static Object getValue(Class returnType, String result2) throws JSONException, InstantiationException, IllegalAccessException, InstantiationError {
        Object result = null;
        if (result2.equals("null")) {
            return null;
        }
        if (returnType == Integer.TYPE || returnType == Integer.class) {
            result = new Integer(result2.trim());
        } else if (returnType == Long.TYPE || returnType == Long.class) {
            result = new Long(result2.trim());
        } else if (returnType == String.class) {
            JSONObject aa = new JSONObject("{\"a1\"=" + result2 + "}");
            result = aa.getString("a1");
        } else if (returnType == Double.TYPE || returnType == Double.class) {
            result = new Double(result2);
        } else if (returnType == Boolean.TYPE || returnType == Boolean.class) {
            result = new Boolean(result2);
        } else if (returnType.isArray()) {
            result = JsonLib.readArray(result2, returnType);
        } else if (JSONable.class.isAssignableFrom(returnType)) {
            result = JsonLib.readJson(result2, returnType);
        } else {
            throw new InstantiationError("zwrotka ani prosta ani JSONable: " + returnType);
        }
        return result;
    }

    private static Object readJson(String result2, Class returnType) throws InstantiationException, IllegalAccessException {
        Object o = returnType.newInstance();
        JsonLib.fromJSON(result2, o);
        return o;
    }

    public static String writeArgsAsString(Object[] params) throws JSONException {
        if (params == null) {
            return "null";
        }
        String separator = ",";
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            if (params[i] == null) {
                sb.append("null");
                continue;
            }
            if (params[i] instanceof JSONable) {
                sb.append(JsonLib.toJSON(params[i]));
                continue;
            }
            if (params[i].getClass().isArray()) {
                sb.append(JsonLib.writeArgsAsString((Object[])params[i]));
                continue;
            }
            sb.append(JSONObject.valueToString(params[i]));
        }
        return '[' + sb.toString() + ']';
    }

    public static String toJSON(Object obj) {
        JSONObject inner = JsonLib.pola2jsonObj(obj);
        return inner.toString();
    }

    public static void fromJSON(String jsonString, Object obj) {
        try {
            JSONObject json = new JSONObject(jsonString);
            JsonLib.json2pola(json, obj);
        }
        catch (JSONException ex) {
            ex.printStackTrace();
        }
    }

    public static JSONObject pola2jsonObj(Object obj) {
        JSONObject inner = new JSONObject();
        Field[] ff = obj.getClass().getDeclaredFields();
        try {
            for (int i = 0; i < ff.length; ++i) {
                Field field = ff[i];
                if (!JsonLib.isValidField(field)) continue;
                Object val = field.get(obj);
                if (val instanceof Date) {
                    val = new Long(((Date)val).getTime());
                } else {
                    if (val != null && val.getClass().isArray()) {
                        Object[] arrA = (Object[])val;
                        JSONArray arr = new JSONArray();
                        for (int j = 0; j < arrA.length; ++j) {
                            if (arrA[j] != null && (class$ekspert$mobile$datamodel$json$JSONable == null ? JsonLib.class$("ekspert.mobile.datamodel.json.JSONable") : class$ekspert$mobile$datamodel$json$JSONable).isAssignableFrom(arrA[j].getClass())) {
                                arr.put(JsonLib.pola2jsonObj(arrA[j]));
                                continue;
                            }
                            arr.put(arrA[j]);
                        }
                        inner.put(field.getName(), arr);
                        continue;
                    }
                    if (val != null && (class$ekspert$mobile$datamodel$json$JSONable == null ? JsonLib.class$("ekspert.mobile.datamodel.json.JSONable") : class$ekspert$mobile$datamodel$json$JSONable).isAssignableFrom(val.getClass())) {
                        inner.put(field.getName(), JsonLib.pola2jsonObj(val));
                        continue;
                    }
                }
                inner.put(field.getName(), val == null ? "null" : val.toString());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
        return inner;
    }

    public static void json2pola(JSONObject json, Object o) {
        Field[] ff = o.getClass().getDeclaredFields();
        try {
            for (int i = 0; i < ff.length; ++i) {
                Field field = ff[i];
                if (!JsonLib.isValidField(field)) continue;
                JsonLib.setValue(o, json.get(field.getName()).toString(), field);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static boolean isValidField(Field field) {
        int modifiers = field.getModifiers();
        if (!Modifier.isPublic(modifiers)) {
            return false;
        }
        if (Modifier.isFinal(modifiers)) {
            return false;
        }
        if (Modifier.isStatic(modifiers)) {
            return false;
        }
        return !Modifier.isVolatile(modifiers);
    }

    public static Object readArray(String result2, Class returnType) throws JSONException, InstantiationError, InstantiationException, IllegalAccessException {
        JSONArray aa = new JSONArray(result2);
        Class<?> elType = returnType.getComponentType();
        Object[] rA = (Object[])Array.newInstance(elType, aa.length());
        for (int j = 0; j < aa.length(); ++j) {
            if (aa.isNull(j)) continue;
            if ((class$ekspert$mobile$datamodel$json$JSONable == null ? JsonLib.class$("ekspert.mobile.datamodel.json.JSONable") : class$ekspert$mobile$datamodel$json$JSONable).isAssignableFrom(elType)) {
                Object o = elType.newInstance();
                JsonLib.json2pola(aa.getJSONObject(j), o);
                rA[j] = o;
                continue;
            }
            rA[j] = aa.get(j);
        }
        return rA;
    }

    private static void setValue(Object obj, String value, Field field) throws IllegalArgumentException, IllegalAccessException, InstantiationError, JSONException, InstantiationException {
        if (value == null || value.equals("null")) {
            return;
        }
        Class<?> typPola = field.getType();
        if (typPola == String.class) {
            field.set(obj, value);
        } else if (typPola.isArray()) {
            Object arr = JsonLib.readArray(value, typPola);
            field.set(obj, arr);
        } else if (typPola == Integer.TYPE || typPola == Integer.class) {
            field.set(obj, new Integer(value));
        } else if (typPola == Long.TYPE || typPola == Long.class) {
            field.set(obj, new Long(value));
        } else if (typPola == Double.TYPE || typPola == Double.class) {
            field.set(obj, new Double(value));
        } else if (typPola == Boolean.TYPE || typPola == Boolean.class) {
            field.set(obj, new Boolean(value));
        } else if (typPola == Date.class) {
            field.set(obj, new Date(Long.parseLong(value)));
        } else if (JSONable.class.isAssignableFrom(typPola)) {
            Object o = typPola.newInstance();
            JsonLib.json2pola(new JSONObject(value), o);
            field.set(obj, o);
        } else {
            throw new IllegalArgumentException("lk brak obslugi typu " + typPola);
        }
    }
}

