/*
 * Decompiled with CFR 0.152.
 */
package ekspert.mobile.dod;

import ekspert.mobile.Common;
import ekspert.mobile.ContC;
import ekspert.mobile.UtilsM;
import ekspert.mobile.common.dod.DodClientConfig;
import ekspert.mobile.common.dod.DodIF;
import ekspert.mobile.common.obj.OpakKartM;
import ekspert.mobile.common.obj.Towar;
import ekspert.mobile.common.obj.TowarSzukanie;
import ekspert.mobile.common.przeglady.PrzegladyUtils;
import ekspert.mobile.common.spr.SprClientConfig;
import ekspert.mobile.common.spr.SprIF;
import ekspert.mobile.dod.DodajEan2C;
import ekspert.mobile.dod.DodawanieKartotekiC;
import ekspert.mobile.dod.IleWOpakC;
import ekspert.mobile.dod.NowyKodC;
import ekspert.mobile.gui.SwtCommon;
import org.eclipse.swt.widgets.Shell;

public class MainDOD {
    public static final String STAN_DODANO_EAN = "DE";
    public static boolean DEBUG = false;
    private SprIF SPR;
    private DodIF DOD;
    private Shell shell;
    private ContC containerC;
    private boolean pozwolDodawacKartoteki;
    private DodClientConfig conf;

    public MainDOD(SprIF spr, DodIF dod2, ContC containerComposite) {
        this.SPR = spr;
        this.DOD = dod2;
        this.containerC = containerComposite;
        this.shell = this.containerC.getShell();
    }

    public TowarSzukanie obslugaWpisanoNieZnaleziono(String ean, boolean pozwolDodawacKartoteki) {
        this.conf = this.DOD.getClientConfig();
        this.pozwolDodawacKartoteki = pozwolDodawacKartoteki;
        return this.obslugaWpisanoNieZnaleziono2(ean);
    }

    public TowarSzukanie obslugaWpisanoNieZnaleziono(String ean) {
        this.conf = this.DOD.getClientConfig();
        this.pozwolDodawacKartoteki = this.conf.pozwolDodawacKartoteki;
        return this.obslugaWpisanoNieZnaleziono2(ean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TowarSzukanie obslugaWpisanoNieZnaleziono2(String ean) {
        String res2;
        Towar szczegoly;
        TowarSzukanie t;
        while (true) {
            if ((t = this.szukajDoDodania(ean)) == null) {
                return null;
            }
            szczegoly = this.SPR.szczegolyTowaru(t.id);
            int coZrobic = 0;
            NowyKodC n = new NowyKodC(this.containerC);
            try {
                coZrobic = n.pseudoDialog(ean, szczegoly);
            }
            finally {
                SwtCommon.safeDispose(n);
            }
            if (coZrobic == -1) continue;
            if (coZrobic == 2) {
                if (szczegoly.eany.length > 0 && !this.conf.pozwolWieleEan) {
                    SwtCommon.alert(this.shell, "towar ma juz przypisany kod EAN:\n " + UtilsM.objArr2Str(szczegoly.eany) + "\nnie moge ponownie przypisa\u0107!");
                    continue;
                }
                this.dodawajBezOpakowania(ean, szczegoly);
                t.stan = STAN_DODANO_EAN;
                return t;
            }
            if (szczegoly.defOpak == null) {
                if (OpakKartM.opakWarray(this.conf.skonfigurowaneDomyslne, szczegoly.opakowania)) {
                    res2 = this.DOD.ustawDomyslneOpakowanie(t.id, this.conf.skonfigurowaneDomyslne);
                    if (res2.startsWith("OK")) break;
                    SwtCommon.alert(this.shell, "blad ustawiania domyslnego opakowania " + coZrobic);
                    break;
                }
                this.przypiszOpakowanie(t, this.conf.skonfigurowaneDomyslne);
                res2 = this.DOD.ustawDomyslneOpakowanie(t.id, this.conf.skonfigurowaneDomyslne);
                if (res2.startsWith("OK")) break;
                SwtCommon.alert(this.shell, "blad ustawiania domyslnego " + coZrobic);
                break;
            }
            if (szczegoly.defOpak.eany.length <= 0 || this.conf.pozwolWieleEan) break;
            SwtCommon.alert(this.shell, "opakowanie domy\u015blne ma juz przypisany kod EAN:\n " + szczegoly.defOpak.eany[0] + "\nnie moge ponownie przypisa\u0107!");
        }
        res2 = this.DOD.dodajEanDoKartoteki(t.id, this.conf.skonfigurowaneDomyslne.id, ean);
        if (res2 == null || !res2.startsWith("OK")) {
            SwtCommon.alert(this.shell, "blad dodania ean\n" + res2);
        } else {
            SwtCommon.info(this.shell, "przypisalem do \n" + this.conf.skonfigurowaneDomyslne.nazwa + " w \n" + szczegoly.nazwaSkr);
        }
        t.stan = STAN_DODANO_EAN;
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TowarSzukanie szukajDoDodania(String ean) {
        block20: {
            if (this.containerC.isDisposed()) {
                return null;
            }
            DodajEan2C w = new DodajEan2C(this.containerC);
            try {
                TowarSzukanie towarSzukanie;
                TowarSzukanie t;
                while (true) {
                    if (w.isDisposed()) {
                        TowarSzukanie towarSzukanie2 = null;
                        return towarSzukanie2;
                    }
                    String[] wartosci = w.wyszukajDoDodaniaEan(ean, this.pozwolDodawacKartoteki);
                    w.dispose();
                    if (wartosci == null) {
                        TowarSzukanie towarSzukanie3 = null;
                        return towarSzukanie3;
                    }
                    if (wartosci == DodajEan2C.DODAJ) {
                        Towar sz = this.dodajKart(ean);
                        if (sz == null) continue;
                        TowarSzukanie towarSzukanie4 = new TowarSzukanie(sz.id, sz.nazwaSkr, "");
                        return towarSzukanie4;
                    }
                    String kod = wartosci[0];
                    String indeksNazwa = wartosci[1];
                    TowarSzukanie[] listaTowarow = kod.length() > 0 ? this.SPR.szukajTowaruEan(kod) : this.SPR.szukajTowaruIndeksNazwa(indeksNazwa, true);
                    if (listaTowarow == null) {
                        TowarSzukanie towarSzukanie5 = null;
                        return towarSzukanie5;
                    }
                    if (listaTowarow.length == 0) {
                        if (this.pozwolDodawacKartoteki) {
                            Towar sz;
                            int ret = SwtCommon.confirm(this.shell, "Nie znaleziono towaru.\nCzy chcesz doda\u0107 now\u0105 kartotek\u0119?");
                            if (ret == 128 || (sz = this.dodajKart(ean)) == null) {
                                continue;
                            }
                            break block20;
                        }
                        SwtCommon.info(this.shell, "Nie znaleziono towaru");
                        continue;
                    }
                    if (listaTowarow.length == 1) {
                        TowarSzukanie ret = listaTowarow[0];
                        return ret;
                    }
                    t = PrzegladyUtils.wybierzTowar(this.containerC, listaTowarow, Common.getSprCC());
                    if (t == PrzegladyUtils.TOWAR_POWROC) {
                        towarSzukanie = null;
                        return towarSzukanie;
                    }
                    if (t != null) break;
                }
                towarSzukanie = t;
                return towarSzukanie;
            }
            finally {
                SwtCommon.safeDispose(w);
            }
        }
        return null;
    }

    private boolean dodawajBezOpakowania(String ean, Towar szczegoly) {
        String res2 = this.DOD.dodajEanDoKartoteki(szczegoly.id, -1, ean);
        if (res2 == null || !res2.startsWith("OK")) {
            SwtCommon.alert(this.shell, "blad dodania ean " + res2);
            return false;
        }
        SwtCommon.info(this.shell, "przypisalem do \n" + szczegoly.nazwaSkr);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void przypiszOpakowanie(TowarSzukanie t, OpakKartM o) {
        IleWOpakC ile = new IleWOpakC(this.containerC);
        try {
            String res2;
            String ileWopak = ile.pseudoDialog(o);
            if (ileWopak != null) {
                o.ileWopak = Double.parseDouble(ileWopak);
            }
            if ((res2 = this.DOD.dowiazOpakowanieDoKartoteki(t.id, o)) == null || !res2.startsWith("OK")) {
                SwtCommon.alert(this.shell, "b\u0142\u0105d wiazania opakowania " + res2);
                return;
            }
        }
        finally {
            SwtCommon.safeDispose(ile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Towar dodajKart(String ean) {
        SwtCommon.setCursorBusy(this.shell);
        String indeks = this.DOD.getIndeks();
        SwtCommon.setCursorRestore(this.shell);
        if (indeks == null) {
            SwtCommon.alert(this.shell, "b\u0142\u0105d pobierania danych do dodawania kartoteki!");
            return null;
        }
        Towar sz = null;
        DodawanieKartotekiC d = new DodawanieKartotekiC(this.containerC);
        try {
            sz = d.pseudoDialog(ean, this.conf.jednostkiMiar, this.conf.stawkiVat, indeks, this.DOD);
        }
        finally {
            SwtCommon.safeDispose(d);
        }
        if (sz == null) {
            return null;
        }
        String statusIidKartoteka = this.DOD.dodajKartoteke(sz);
        if (statusIidKartoteka == null) {
            SwtCommon.alert(this.shell, "blad dodawania kartoteki");
            return null;
        }
        if (statusIidKartoteka.startsWith("OK")) {
            sz.id = Integer.parseInt(statusIidKartoteka.substring(3));
            SwtCommon.info(this.shell, "dodalem kartoteke, ID: " + sz.id);
            return sz;
        }
        if (statusIidKartoteka.startsWith("DUP")) {
            String idKartoteka = statusIidKartoteka.substring(4);
            SwtCommon.info(this.shell, "kartoteka o takim indeksie juz istnieje, ID: " + idKartoteka);
            return null;
        }
        SwtCommon.alert(this.shell, "status dodawania kartoteki: " + statusIidKartoteka);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dodajDoIndeksu(Towar szczegoly) {
        this.conf = Common.getDodCC();
        String ean = "";
        DodajEan2C w = new DodajEan2C(this.containerC);
        try {
            ean = w.eanDoIndeksu(szczegoly.indeks);
            if (w.isDisposed()) {
                boolean bl = false;
                return bl;
            }
            if (ean == null) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            SwtCommon.safeDispose(w);
        }
        TowarSzukanie[] res = this.SPR.szukajTowaruEan(ean);
        if (res == null) {
            return false;
        }
        SprClientConfig confSpr = Common.getSprCC();
        if (res.length > 0) {
            if (confSpr.DODAJ_EAN_INNY_INDEKS) {
                SwtCommon.info(this.shell, "Uwaga, ten EAN jest ju\u017c przypisany do innego towaru: " + res[0].nazwa);
            } else {
                SwtCommon.alert(this.shell, "Uwaga, ten EAN jest ju\u017c przypisany do innego towaru: " + res[0].nazwa + "\nkonfiguracja nie pozwala na dodanie");
                return false;
            }
        }
        return this.dodawajBezOpakowania(ean, szczegoly);
    }
}

