/*
 * Decompiled with CFR 0.152.
 */
package ekspert.mobile.gui;

import ekspert.mobile.gui.ActionDesc;
import ekspert.mobile.gui.BtnMnuA;
import ekspert.mobile.gui.InnerActionDesc;
import ekspert.mobile.util.SimpleCallback;
import java.util.ArrayList;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ActionMatrix {
    private boolean hasReturnAction;
    private BtnMnuA ownerMenuForm;
    ArrayList actions = new ArrayList();
    private static ActionDesc[] tmp1ItemArray = new ActionDesc[1];
    private boolean returnActionAdded;

    public void setHasReturnAction(boolean hasReturnAction) {
        this.hasReturnAction = hasReturnAction;
    }

    private ActionDesc getFirstMatchingAction(Matcher m) {
        InnerActionDesc innerActionDesc = this.getFirstMatchingInnerActionDesc(m);
        if (innerActionDesc == null) {
            return null;
        }
        return innerActionDesc.action;
    }

    public void addRowAction(ActionDesc action) {
        ActionMatrix.tmp1ItemArray[0] = action;
        this.addRowActions(tmp1ItemArray);
    }

    public void addRowActions(ActionDesc[] addedActions) {
        if (this.actions == null) {
            return;
        }
        int maxRowIndex = this.getMaxRowIndex();
        for (int index = 0; index < addedActions.length; ++index) {
            this.addAction(maxRowIndex + 1, addedActions[index]);
        }
    }

    private void addAction(int row, ActionDesc action) {
        this.actions.add(new InnerActionDesc(row, action));
    }

    private int getMaxRowIndex() {
        MaxRowVisitor maxRowVisitor = new MaxRowVisitor();
        this.visitAll(maxRowVisitor);
        return maxRowVisitor.max;
    }

    private InnerActionDesc[] getActionsOfSelectedRow(final int row) {
        final ArrayList actions = new ArrayList();
        Visitor v = new Visitor(){

            public boolean visit(InnerActionDesc desc) {
                if (desc.row == row) {
                    actions.add(desc);
                }
                return true;
            }
        };
        this.visitAll(v);
        return actions.toArray(new InnerActionDesc[actions.size()]);
    }

    public void prepareComposite(BtnMnuA ownerMenuForm, Composite parentComposite) {
        if (this.hasReturnAction && !this.returnActionAdded) {
            SimpleCallback backCallback = new SimpleCallback(){

                public void call() {
                    ActionMatrix.this.getOwnerForm().simulatePressingBackButton();
                }
            };
            ActionDesc action = new ActionDesc("Powr\u00f3\u0107", backCallback);
            action.setKeyShortcut('0');
            this.addRowAction(action);
            this.returnActionAdded = true;
        }
        this.ownerMenuForm = ownerMenuForm;
        int buttonHeight = 31;
        int maxRow = this.getMaxRowIndex();
        int maxColumns = this.getRowMaxColumnCount();
        GridLayout gridLayout = new GridLayout();
        parentComposite.setLayout((Layout)gridLayout);
        gridLayout.numColumns = maxColumns;
        gridLayout.makeColumnsEqualWidth = true;
        for (int rowIndex = 0; rowIndex <= maxRow; ++rowIndex) {
            InnerActionDesc[] rowActions = this.getActionsOfSelectedRow(rowIndex);
            for (int actionIndex = 0; actionIndex < rowActions.length; ++actionIndex) {
                InnerActionDesc innerAction = rowActions[actionIndex];
                Button b = this.createButton(ownerMenuForm, parentComposite, innerAction);
                if (b == null) continue;
                GridData gd = new GridData();
                gd.horizontalAlignment = 4;
                gd.heightHint = buttonHeight;
                if (rowActions.length == 1) {
                    gd.horizontalSpan = maxColumns;
                    gd.grabExcessHorizontalSpace = true;
                    gd.grabExcessVerticalSpace = maxRow >= 4;
                }
                b.setLayoutData((Object)gd);
            }
        }
        parentComposite.layout();
    }

    public void closeOwnerComposite() {
        if (this.ownerMenuForm != null) {
            this.ownerMenuForm.closeCompositeViaBackButton();
        }
    }

    public BtnMnuA getOwnerForm() {
        return this.ownerMenuForm;
    }

    private Button createButton(BtnMnuA ownerMenuForm, Composite parentComposite, InnerActionDesc innerAction) {
        if (innerAction.action.hasShortcut()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(innerAction.action.getKeyShortcut()).append(". ");
            buffer.append(innerAction.action.getCaption());
            Button b = new Button(parentComposite, 0x1000008);
            b.setText(buffer.toString());
            ownerMenuForm.prepareButtonsShortcutService(b, innerAction.action.getKeyShortcut());
            return b;
        }
        return null;
    }

    private int getRowMaxColumnCount() {
        int max = 1;
        int maxRowIndex = this.getMaxRowIndex();
        for (int rowIndex = 0; rowIndex <= maxRowIndex; ++rowIndex) {
            InnerActionDesc[] rowActions = this.getActionsOfSelectedRow(rowIndex);
            if (rowActions.length <= max) continue;
            max = rowActions.length;
        }
        return max;
    }

    public void reassignShortcuts(ActionDesc specialBackAction) {
        String availableChars = "1234567890ABCDEFGHIKL";
        int charIndex = 0;
        for (int index = 0; index < this.actions.size(); ++index) {
            InnerActionDesc actionDesc = (InnerActionDesc)this.actions.get(index);
            if (specialBackAction != null && specialBackAction.equals(actionDesc.action)) continue;
            if (charIndex < availableChars.length()) {
                actionDesc.action.setKeyShortcut(availableChars.charAt(charIndex));
            }
            ++charIndex;
        }
    }

    private void visitAll(Visitor v) {
        for (int index = 0; index < this.actions.size(); ++index) {
            if (v.visit((InnerActionDesc)this.actions.get(index))) continue;
            return;
        }
    }

    private InnerActionDesc getFirstMatchingInnerActionDesc(Matcher m) {
        for (int index = 0; index < this.actions.size(); ++index) {
            InnerActionDesc iad = (InnerActionDesc)this.actions.get(index);
            if (!m.matches(iad)) continue;
            return iad;
        }
        return null;
    }

    public ActionDesc getActionHavingShortCut(final char shortcut) {
        return this.getFirstMatchingAction(new Matcher(){

            public boolean matches(InnerActionDesc desc) {
                return desc.action.getKeyShortcut() == shortcut;
            }
        });
    }

    private static class MaxRowVisitor
    implements Visitor {
        int max = -1;

        private MaxRowVisitor() {
        }

        public boolean visit(InnerActionDesc desc) {
            if (desc.row > this.max) {
                this.max = desc.row;
            }
            return true;
        }
    }

    private static interface Matcher {
        public boolean matches(InnerActionDesc var1);
    }

    private static interface Visitor {
        public boolean visit(InnerActionDesc var1);
    }
}

