/*
 * Decompiled with CFR 0.152.
 */
package ekspert.mobile.gui;

import ekspert.mobile.UtilsM;
import ekspert.mobile.gui.SwtCommon;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ProgressC
extends Composite {
    private Label opisLab;
    private long startTime = -1L;
    private String msg;
    SimpleDateFormat sdf = UtilsM.getSimpleDateFormat("ss.SSS");

    protected void checkSubclass() {
    }

    private ProgressC(Composite parent, int style) {
        super(parent, style);
        this.initGUI();
    }

    private void initGUI() {
        try {
            FillLayout thisLayout = new FillLayout(256);
            thisLayout.marginHeight = 2;
            thisLayout.marginWidth = 2;
            this.setLayout((Layout)thisLayout);
            this.opisLab = new Label((Composite)this, 0);
            this.opisLab.setText("\u0141\u0105czenie...");
            this.opisLab.setAlignment(0x1000000);
            this.layout();
            this.pack();
            this.setBackground(this.getDisplay().getSystemColor(3));
            SwtCommon.centerOnParent(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setMessage(String msg) {
        if (this.startTime > -1L) {
            this.printTime();
        }
        this.startTime = new Date().getTime();
        this.moveAbove(null);
        this.setVisible(true);
        this.opisLab.setText("  " + msg + "  ");
        this.msg = msg;
        this.opisLab.pack();
        this.layout();
        this.pack();
        SwtCommon.centerOnParent(this);
        this.redraw();
        this.update();
    }

    public void close() {
        this.printTime();
        SwtCommon.setCursorRestore(this.getParent().getShell());
        SwtCommon.safeDispose(this);
    }

    private void printTime() {
        long stopTime = new Date().getTime();
        Date czasTransferu = new Date(stopTime - this.startTime);
        UtilsM.log(this.msg + ": " + this.sdf.format(czasTransferu));
    }

    public static ProgressC showProgress(Composite parent, String message) {
        ProgressC l = new ProgressC(parent, 0);
        SwtCommon.setCursorBusy(parent.getShell());
        l.moveAbove(null);
        l.setMessage(message);
        return l;
    }

    public static void showProgressPause(Composite parent, String message, int ms) {
        ProgressC l = ProgressC.showProgress(parent, message);
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        l.close();
    }
}

