/*
 * Decompiled with CFR 0.152.
 */
package ekspert.mobile.gui;

import ekspert.mobile.MobileUtils;
import ekspert.mobile.UtilsM;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Properties;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class SwtCmm {
    public static Shell mainShell;
    static Cursor cursor_busy;
    public static final String NAZWA_PLIKU = "window.properties";

    public static void setCursorBusy() {
        if (cursor_busy == null) {
            cursor_busy = new Cursor((Device)Display.getDefault(), 1);
        }
        mainShell.setCursor(cursor_busy);
    }

    public static void setCursorRestore() {
        mainShell.setCursor(null);
    }

    public static void info(String msg) {
        SwtCmm.message(msg, "", 2);
    }

    public static void alert(String msg) {
        SwtCmm.alert(msg, "");
    }

    public static void alert(String msg, String title) {
        SwtCmm.message(msg, title, 8);
    }

    public static void message(String msg, String title, int ICON) {
        MessageBox messageBox = new MessageBox(mainShell, 0x20 | ICON);
        messageBox.setMessage(msg);
        messageBox.setText(title);
        messageBox.open();
    }

    public static int confirm(String msg) {
        return SwtCmm.confirm(msg, "");
    }

    public static int confirm(String msg, String title) {
        MessageBox messageBox = new MessageBox(mainShell, 196);
        messageBox.setMessage(msg);
        messageBox.setText(title);
        return messageBox.open();
    }

    public static void czytajUstawieniaOkna(Class c, Table listaTable) {
        SwtCmm.czytajUstawieniaOkna(c.getName(), listaTable);
    }

    public static void czytajUstawieniaOkna(String cName, Table listaTable) {
        Properties p = new Properties();
        try {
            p.load(new FileInputStream(NAZWA_PLIKU));
            SwtCmm.ustawTabele(p, listaTable, cName);
        }
        catch (FileNotFoundException e) {
            System.out.println("brak pliku window.properties");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void ustawTabele(Properties p, Table table, String prefix) {
        if (table != null) {
            String widths;
            String order = p.getProperty(prefix + ".order");
            if (order != null) {
                String[] cz = MobileUtils.splitPreserveAllTokens(order, ',');
                table.setColumnOrder(UtilsM.strArr2intArr(cz));
            }
            if ((widths = p.getProperty(prefix + ".widths")) != null) {
                TableColumn kol;
                String[] cz = MobileUtils.splitPreserveAllTokens(widths, ',');
                for (int i = 0; i < cz.length && (kol = table.getColumn(i)) != null; ++i) {
                    kol.setWidth(Integer.parseInt(cz[i].trim()));
                }
            }
        }
    }

    private static void zapiszTabele(Properties p, Table table, String prefix) {
        if (table != null) {
            int[] order = table.getColumnOrder();
            p.setProperty(prefix + ".order", UtilsM.intArr2Str2(order));
            int[] szerokosci = new int[table.getColumnCount()];
            for (int i = 0; i < table.getColumnCount(); ++i) {
                szerokosci[i] = table.getColumn(i).getWidth();
            }
            p.setProperty(prefix + ".widths", UtilsM.intArr2Str2(szerokosci));
        }
    }

    public static void zapiszUstawieniaOkna(Class c, Table listaTable) {
        SwtCmm.zapiszUstawieniaOkna(c.getName(), listaTable);
    }

    public static void zapiszUstawieniaOkna(String cName, Table listaTable) {
        if (listaTable.isDisposed()) {
            return;
        }
        Properties p = new Properties();
        try {
            p.load(new FileInputStream(NAZWA_PLIKU));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SwtCmm.zapiszTabele(p, listaTable, cName);
        try {
            p.store(new FileOutputStream(NAZWA_PLIKU), "Konfiguracja okien");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("zapisane ustawienia " + cName);
    }

    public static void resetOkna() {
        File f = new File(NAZWA_PLIKU);
        boolean res = f.delete();
        System.out.println("usunieto plik window.properties: " + res);
        if (!res) {
            SwtCmm.alert("nie moglem usunac pliku " + f.getAbsolutePath());
        } else {
            SwtCmm.alert("ustawienia zresetowane");
        }
    }

    public static void ukryjKol(TableColumn[] kolumny, int od) {
        for (int i = od; i < kolumny.length; ++i) {
            kolumny[i].setWidth(0);
            kolumny[i].setResizable(false);
        }
    }

    static {
        cursor_busy = null;
    }
}

