/*
 * Decompiled with CFR 0.152.
 */
package ekspert.mobile.gui;

import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class SwtCommon {
    static Cursor cursor_busy = null;
    public static boolean testing;
    public static String lastMsg;
    public static Integer nextAnswer;

    public static void safeDispose(Composite composite) {
        if (composite != null && !composite.isDisposed()) {
            composite.dispose();
        }
    }

    public static void orzechSetMaximize(Shell shell) {
        Rectangle rec = shell.getDisplay().getClientArea();
        int shellHeight = rec.height;
        int shellWidth = rec.width;
        shell.setBounds(rec);
        shell.setSize(shellWidth, shellHeight);
    }

    public static void setConrolFontSize(Control table, int fontSize) {
        FontData fd = table.getFont().getFontData()[0];
        System.out.println("stary font: " + fd.getHeight() + " ustawiam na " + fontSize);
        fd.setHeight(fontSize);
        Font f = new Font((Device)Display.getDefault(), fd);
        table.setFont(f);
    }

    public static void setConrolFontBold(Control table) {
        FontData fd = table.getFont().getFontData()[0];
        System.out.println("stary font: " + fd.getStyle() + " ustawiam na bold");
        fd.setStyle(1);
        Font f = new Font((Device)Display.getDefault(), fd);
        table.setFont(f);
    }

    public static void setCursorBusy(Shell shell) {
        if (cursor_busy == null) {
            cursor_busy = new Cursor((Device)Display.getDefault(), 1);
        }
        shell.setCursor(cursor_busy);
    }

    public static void setCursorRestore(Shell shell) {
        shell.setCursor(null);
    }

    public static void ustawNaSrodkuEkranu(Shell shell) {
        Point size = shell.getSize();
        Rectangle shellBounds = shell.computeTrim(0, 0, size.x, size.y);
        shell.setSize(shellBounds.width, shellBounds.height);
        Rectangle pDisplayBounds = shell.getDisplay().getBounds();
        int nLeft = (pDisplayBounds.width - shellBounds.width) / 2;
        int nTop = (pDisplayBounds.height - shellBounds.height) / 2;
        shell.setLocation(nLeft, nTop);
    }

    public static void centerOnParent(Composite ten) {
        Point size = ten.getSize();
        Rectangle pParentBounds = ten.getParent().getBounds();
        int nLeft = (pParentBounds.width - size.x) / 2;
        int nTop = (pParentBounds.height - size.y) / 2;
        if (ten instanceof Shell) {
            ten.setLocation(pParentBounds.x + nLeft, pParentBounds.y + nTop);
        } else {
            ten.setLocation(nLeft, nTop);
        }
    }

    public static void ustawDzieciParentaEnabled(Composite ten, boolean enabled) {
        if (ten.isDisposed()) {
            return;
        }
        Control[] ch = ten.getParent().getChildren();
        SwtCommon.ustawEnabled(ch, ten, enabled);
    }

    private static void ustawEnabled(Control[] ch, Composite skip, boolean enabled) {
        for (int i = 0; i < ch.length; ++i) {
            if (ch[i] == skip) continue;
            ch[i].setEnabled(enabled);
            if (!(ch[i] instanceof Composite)) continue;
            SwtCommon.ustawEnabled(((Composite)ch[i]).getChildren(), null, enabled);
        }
    }

    public static void info(Shell parent, String msg) {
        SwtCommon.message(parent, msg, "", 2);
    }

    public static void alert(Shell parent, String msg) {
        SwtCommon.alert(parent, msg, "");
    }

    public static void alert(Shell parent, String msg, String title) {
        SwtCommon.message(parent, msg, title, 8);
    }

    public static void message(Shell parent, String msg, String title, int ICON) {
        if (parent == null) {
            System.err.println("WARN: SwtCommon.alert: default_shell is null!");
            Display display = Display.getDefault();
            parent = new Shell(display);
        }
        if (testing) {
            lastMsg = msg;
            return;
        }
        MessageBox messageBox = new MessageBox(parent, 0x20 | ICON);
        messageBox.setMessage(msg);
        messageBox.setText(title);
        messageBox.open();
    }

    public static int confirm(Shell parent, String msg) {
        return SwtCommon.confirm(parent, msg, "");
    }

    public static boolean confirmed(Shell parent, String msg) {
        int res = SwtCommon.confirm(parent, msg, "Komunikat");
        return res == 64;
    }

    public static int confirm(Shell parent, String msg, String title) {
        if (testing && nextAnswer != null) {
            return nextAnswer;
        }
        if (parent == null) {
            parent = new Shell(Display.getDefault());
        }
        MessageBox messageBox = new MessageBox(parent, 196);
        messageBox.setMessage(msg);
        messageBox.setText(title);
        return messageBox.open();
    }

    public static void ustawAutoSzerokoscKolumn(Table table) {
        table.setRedraw(false);
        for (int i = 0; i < table.getColumnCount(); ++i) {
            if (table.getColumn(i).getWidth() == 0) continue;
            table.getColumn(i).pack();
        }
        table.layout();
        table.setRedraw(true);
    }

    public static void fixWinCE(Composite composite) {
        Control[] ch = composite.getChildren();
        for (int i = 0; i < ch.length; ++i) {
            if (ch[i] instanceof Label) {
                ch[i].setBackground(composite.getBackground());
                continue;
            }
            if (!(ch[i] instanceof Composite)) continue;
            SwtCommon.fixWinCE((Composite)ch[i]);
        }
    }
}

