/*
 * Decompiled with CFR 0.152.
 */
package ekspert.mobile.gui.dialogs;

import ekspert.mobile.UtilsM;
import ekspert.mobile.gui.dialogs.CommonInputDialog;
import java.text.DecimalFormat;
import org.eclipse.swt.widgets.Shell;

public class DoubleInputDialog
extends CommonInputDialog {
    private int precision;
    private DecimalFormat df;

    public DoubleInputDialog(Shell parent) {
        super(parent);
    }

    public boolean executed(String title, String caption, double startValue, int precision) {
        this.precision = precision;
        return this.internalExecuted(title, caption, this.getDecimalFormat().format(startValue).replace(',', '.'));
    }

    public double getValue() {
        String strValue = UtilsM.ifNull(this.internalGetValue()).trim();
        Double doubleValue = null;
        try {
            doubleValue = new Double(strValue);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return doubleValue == null ? 0.0 : doubleValue;
    }

    protected boolean isDataCorrect() {
        String strValue = UtilsM.ifNull(this.internalGetValue()).trim().replace(',', '.');
        try {
            new Double(strValue);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public DecimalFormat getDecimalFormat() {
        if (this.df != null) {
            return this.df;
        }
        switch (this.precision) {
            case 3: {
                this.df = new DecimalFormat("########0.000");
                return this.df;
            }
            case 2: {
                this.df = new DecimalFormat("########0.00");
                return this.df;
            }
            case 1: {
                this.df = new DecimalFormat("########0.0");
                return this.df;
            }
            case 0: {
                this.df = new DecimalFormat("########0");
                return this.df;
            }
        }
        throw new RuntimeException("nieobslugiwana ilosc miejsc po przecinku: " + this.precision);
    }
}

