/*
 * Decompiled with CFR 0.152.
 */
package ekspert.mobile.inw;

import base.composites.BaseTableUtils;
import base.controls.ControlFactory;
import base.data.ColumnDef;
import base.data.StringDataGetter;
import ekspert.mobile.Common;
import ekspert.mobile.ContC;
import ekspert.mobile.Main;
import ekspert.mobile.UtilsM;
import ekspert.mobile.common.DialogParams;
import ekspert.mobile.common.KodEan128Parser;
import ekspert.mobile.common.KodEan128Result;
import ekspert.mobile.common.PozycjeCNewer;
import ekspert.mobile.common.inw.ArkInw;
import ekspert.mobile.common.inw.DokInw;
import ekspert.mobile.common.inw.InwClientConfig;
import ekspert.mobile.common.inw.InwIF;
import ekspert.mobile.common.inw.PozInw;
import ekspert.mobile.common.obj.Dostawa;
import ekspert.mobile.common.obj.MSkl;
import ekspert.mobile.common.obj.OpakKartM;
import ekspert.mobile.common.obj.Towar;
import ekspert.mobile.common.obj.TowarSzukanie;
import ekspert.mobile.common.przeglady.PrzegladyUtils;
import ekspert.mobile.common.spr.SprIF;
import ekspert.mobile.datamodel.ManagedArray;
import ekspert.mobile.gui.ProgressC;
import ekspert.mobile.gui.SwtCommon;
import ekspert.mobile.inw.SpisujC;
import ekspert.mobile.zms.SzukajMsklC;
import java.util.ArrayList;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class PozycjeInwCNewer
extends PozycjeCNewer {
    private ManagedArray positions;
    private ArkInw arkusz;
    private InwClientConfig conf;
    private MSkl mskl;
    private DokInw dok;
    private InwIF INW;
    private Button msklBtn;
    private Label mscOpisLab;
    private Label msklLab;
    private KodEan128Parser parserE;
    private ColumnDef[] columns = null;
    private KeyListener keyAdapter = new KeyAdapter(){

        public void keyPressed(KeyEvent e) {
            if (e.character == '3') {
                PozycjeInwCNewer.this.msklBtnWS();
            }
        }
    };

    public PozycjeInwCNewer(Shell parent) {
        super(parent);
        this.initGUI2();
    }

    public PozycjeInwCNewer(ContC parent) {
        super(parent);
        this.parserE = new KodEan128Parser(Common.magClientConf.kodyEtykiet);
        this.initGUI2();
    }

    protected boolean czyNaPodstawie() {
        return true;
    }

    protected ColumnDef[] getColumnsDef() {
        if (this.columns != null) {
            return this.columns;
        }
        ArrayList<ColumnDef> colList = new ArrayList<ColumnDef>();
        colList.add(new ColumnDef("Nr", 10, new StringDataGetter(){

            public String getData(Object record) {
                return Integer.toString(((PozInw)record).nr);
            }
        }));
        colList.add(new ColumnDef("Spisano", 30, new StringDataGetter(){

            public String getData(Object record) {
                return UtilsM.formatDoubleIlosc(((PozInw)record).ilSp);
            }
        }));
        colList.add(new ColumnDef("Indeks", 48, new StringDataGetter(){

            public String getData(Object record) {
                return ((PozInw)record).ind;
            }
        }));
        colList.add(new ColumnDef("Nazwa", 60, new StringDataGetter(){

            public String getData(Object record) {
                return ((PozInw)record).nazwa;
            }
        }));
        if (this.conf.ukryjStanPrzed) {
            colList.add(new ColumnDef("Stan przed", 61, new StringDataGetter(){

                public String getData(Object record) {
                    return UtilsM.formatDoubleIlosc(((PozInw)record).stan);
                }
            }));
            colList.add(new ColumnDef("Suma Spis", 40, new StringDataGetter(){

                public String getData(Object record) {
                    PozInw pozInw = (PozInw)record;
                    return UtilsM.formatDoubleIlosc(pozInw.sIS - pozInw.stan);
                }
            }));
        }
        if (this.conf.obslugaMskl && this.dok.id_mscprzygtowaru > 0) {
            colList.add(new ColumnDef("Miejsce", 20, new StringDataGetter(){

                public String getData(Object record) {
                    PozInw pozInw = (PozInw)record;
                    return pozInw.mskl;
                }
            }));
        }
        if (this.conf.obslugaDostaw) {
            colList.add(new ColumnDef("Nr dost.", 20, new StringDataGetter(){

                public String getData(Object record) {
                    PozInw pozInw = (PozInw)record;
                    return pozInw.nrP;
                }
            }));
        }
        this.columns = BaseTableUtils.castColumns(colList);
        return this.columns;
    }

    private void initGUI2() {
        this.msklBtn = new Button(this.cNaPodst, 0);
        RowData label1LData = new RowData();
        label1LData.width = 54;
        label1LData.height = 24;
        this.msklBtn.setLayoutData((Object)label1LData);
        this.msklBtn.setText("3. Mskl");
        this.msklBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                PozycjeInwCNewer.this.msklBtnWS();
            }
        });
        this.mscOpisLab = ControlFactory.createLabel(this.cNaPodst, 0);
        this.mscOpisLab.setLayoutData((Object)new RowData());
        this.mscOpisLab.setText("Mskl:");
        RowData msklLabLData = new RowData();
        msklLabLData.width = 146;
        msklLabLData.height = 14;
        this.msklLab = ControlFactory.createLabel(this.cNaPodst, 0);
        this.msklLab.setLayoutData((Object)msklLabLData);
        this.cNaPodst.layout();
        this.cNaPodst.pack();
        this.layout();
        this.listaTable.addKeyListener(this.keyAdapter);
        this.setSize(Main.shellWidth, Main.containerHeight);
    }

    protected void wpisBtnWS() {
        String ean = this.skanujTxt.getText();
        if (ean.length() == 0) {
            this.listaTable.setFocus();
            return;
        }
        this.skanujTxt.setText("");
        this.skanujTxt.setFocus();
        KodEan128Result ean128 = this.parserE.parsuj(ean);
        if (ean128 != null) {
            PozycjeCNewer.Ean128DataDesc daneZEtykiety = this.podajDaneZEtykiety(ean128);
            if (daneZEtykiety == null) {
                return;
            }
            if (!UtilsM.napisPustyLubTylkoSpacje(daneZEtykiety.errorDesc)) {
                SwtCommon.alert(this.getShell(), daneZEtykiety.errorDesc);
                return;
            }
            this.pokazDialogSpisania(daneZEtykiety.towar, daneZEtykiety.dostawa, ean);
        } else {
            TowarSzukanie tt = this.znajdzTowarEan(ean);
            if (tt != null) {
                Towar wybranyTowar = this.sprClient.szczegolyTowaru(tt.id);
                this.pokazDialogSpisania(wybranyTowar, null, ean);
            }
        }
        if (this.isDisposed()) {
            return;
        }
        this.skanujTxt.setFocus();
        this.getShell().setDefaultButton(this.wpisBtn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pokazDialogSpisania(Towar wybranyTowar, Dostawa wybranaDostawa, String eanWpisany) {
        int idDost;
        OpakKartM opakowanieWpisanegoEan;
        SpisujC ss;
        double iloscSpisana;
        PozInw pp = this.INW.pobierzPozArkInwIdKart(this.arkusz.id_arkspinw, wybranyTowar.id);
        Dostawa d = null;
        if (this.conf.obslugaDostaw) {
            Object[] dostawy = this.INW.pobierzDostawyArk(wybranyTowar.id, this.arkusz.id_arkspinw);
            if (dostawy == null) {
                return;
            }
            if (wybranaDostawa != null) {
                System.out.println("wybrana dostawa w inwentaryzacji");
                dostawy = (Dostawa[])UtilsM.arrayDelete(dostawy, wybranaDostawa);
            }
            if (dostawy.length == 0) {
                int res = SwtCommon.confirm(this.getShell(), "Brak dostaw kartoteki " + wybranyTowar.indeks + " czy chcesz doda\u0107 dostaw\u0119 nadwy\u017ckow\u0105?");
                if (res != 64) {
                    return;
                }
                d = Dostawa.NADWYZKOWA;
            } else {
                d = PrzegladyUtils.wybierzDostawe(this.containerCo, (Dostawa[])dostawy, "Wybierz dostaw\u0119  " + wybranyTowar.indeks);
                if (d == null) {
                    return;
                }
            }
        }
        if ((iloscSpisana = (ss = new SpisujC(this.containerCo)).spisujPozycje(pp, this.mskl == null ? null : this.mskl.nazwa, wybranyTowar, opakowanieWpisanegoEan = this.eanZopakowania(eanWpisany, wybranyTowar), this.conf, d)) == -1.0 || this.isDisposed()) {
            return;
        }
        String kodMskl = this.mskl == null ? null : this.mskl.kod;
        PozInw newPoz = this.INW.dodajPozInw(this.arkusz.id_arkspinw, pp.ind, iloscSpisana, kodMskl, idDost = d == null ? 0 : d.id);
        if (newPoz == null) {
            return;
        }
        this.positions.addItem(newPoz);
        this.refreshShownRecords(this.positions);
        ProgressC p = ProgressC.showProgress(this, "dodano pozycj\u0119 do arkusza");
        try {
            this.skanujTxt.setFocus();
            UtilsM.sleep(2000);
        }
        finally {
            p.close();
        }
        this.skanujTxt.setFocus();
        if (this.conf.gc) {
            UtilsM.showMemInfo();
            Runtime.getRuntime().gc();
            UtilsM.showMemInfo();
        }
    }

    public void edytujArkusz(InwIF inw, DokInw dok, ArkInw arkusz, InwClientConfig conf, SprIF spr) {
        this.setupINW(inw, dok, arkusz, conf, spr);
        if (this.positions == null) {
            return;
        }
        if (!this.setupMskl()) {
            return;
        }
        this.getShell().setDefaultButton(this.wpisBtn);
        this.runUI((Control)this.skanujTxt);
    }

    protected void reloadRecords() {
        this.positions = new ManagedArray(this.INW.pobierzPozArkInw(this.arkusz.id_arkspinw));
        this.refreshShownRecords(this.positions);
    }

    void setupINW(InwIF inw, DokInw dok, ArkInw arkusz, InwClientConfig conf, SprIF spr) {
        this.arkusz = arkusz;
        this.INW = inw;
        this.sprClient = spr;
        this.setSprConf(Common.getSprCC());
        this.dok = dok;
        this.conf = conf;
        if (conf.gc) {
            UtilsM.showMemInfo();
            Runtime.getRuntime().gc();
            UtilsM.showMemInfo();
        }
        this.reloadRecords();
        this.skanujTxt.setFocus();
        if (!conf.obslugaMskl || dok.id_mscprzygtowaru > 0) {
            this.mscOpisLab.setVisible(false);
            this.msklBtn.setVisible(false);
        }
        this.dokInfo.setText("Ark: " + arkusz.nr_arkusza + " " + UtilsM.ifNull(arkusz.opis));
    }

    private boolean setupMskl() {
        if (this.conf.obslugaMskl && this.dok.id_mscprzygtowaru != 0) {
            this.msklBtnWS();
            if (this.mskl == null) {
                return false;
            }
            if (this.isDisposed()) {
                return false;
            }
        }
        return true;
    }

    private void msklBtnWS() {
        MSkl[] miejsca;
        SzukajMsklC d = new SzukajMsklC(this.containerCo);
        while (true) {
            String szukaj = d.wyszukajMskl(false, null, "");
            if (this.isDisposed()) {
                return;
            }
            if (szukaj == "-1") {
                this.skanujTxt.setFocus();
                return;
            }
            miejsca = this.INW.szukajMiejsceSkladowania(this.dok.id_magazyn, szukaj);
            if (miejsca != null && miejsca.length > 0) break;
            SwtCommon.alert(this.getShell(), "nie znaleziono miejsca skladowania");
        }
        this.setMskl(miejsca[0]);
        this.skanujTxt.setFocus();
    }

    void setMskl(MSkl msc) {
        this.mskl = msc;
        this.msklLab.setText(this.mskl.kod);
        this.msklLab.pack();
    }

    protected void szukaj(String fraza) {
        TowarSzukanie ktory = this.znajdzTowarIndeksNazwa(fraza);
        System.out.println(ktory);
        if (ktory != null) {
            if (!ktory.aktMag()) {
                SwtCommon.alert(this.getShell(), ktory.nazwa + "\nwybrany towar nie jest aktywny na magazynie.");
                return;
            }
            Towar wybranyTowar = this.sprClient.szczegolyTowaru(ktory.id);
            this.pokazDialogSpisania(wybranyTowar, null, null);
        }
        if (this.isDisposed()) {
            return;
        }
        this.skanujTxt.setFocus();
        this.getShell().setDefaultButton(this.wpisBtn);
    }

    protected void dodajInneZamowienie() {
    }

    protected void usunBtnWS() {
    }

    protected void zatwierdzBtnWS() {
        this.zakonczUI = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void listaTableWDS() {
        int ind = this.listaTable.getSelectionIndex();
        if (ind == -1) {
            return;
        }
        PozInw poz = (PozInw)this.positions.getItem(ind);
        Towar tsz = this.sprClient.szczegolyTowaru(poz.idK);
        SpisujC ss = new SpisujC(this.containerCo);
        try {
            ss.pokazPozycje(poz, poz.mskl, tsz, this.conf);
        }
        finally {
            SwtCommon.safeDispose(ss);
        }
    }

    protected void ukryjPozycjeOkBtnWS() {
    }

    protected void zapiszUwagiCechy(DialogParams params) {
    }
}

