/*
 * Decompiled with CFR 0.152.
 */
package ekspert.mobile.paleta;

import base.classes.ScanMatcher;
import ekspert.mobile.Common;
import ekspert.mobile.ContC;
import ekspert.mobile.common.paleta.Paleta;
import ekspert.mobile.gui.SwtCommon;
import ekspert.mobile.paleta.PokazPalet;

public class PaletyDoZaladunku
extends PokazPalet {
    public PaletyDoZaladunku(ContC parent) {
        super(parent);
        this.wybierzBtn.setText("Za\u0142aduj");
    }

    protected String getTitle() {
        return "Palety do za\u0142adunku";
    }

    protected ScanMatcher getScanMatcher() {
        return new PokazPalet.PaletaScanner(){

            public void processFoundRecord(Object item) {
                if (PaletyDoZaladunku.this.markPaletAsLoaded((Paleta)item, true)) {
                    PaletyDoZaladunku.this.scannedEan.setText("");
                }
                PaletyDoZaladunku.this.scannedEan.selectAll();
                PaletyDoZaladunku.this.scannedEan.forceFocus();
            }
        };
    }

    protected void wybierzBtnWS() {
        Paleta paleta = (Paleta)this.listaTable.getSelectedRecord();
        if (paleta == null) {
            return;
        }
        this.markPaletAsLoaded(paleta, true);
    }

    protected boolean markPaletAsLoaded(Paleta paleta, boolean showDialog) {
        if (showDialog && !SwtCommon.confirmed(this.getShell(), "Czy za\u0142adowa\u0107 palet\u0119?")) {
            return false;
        }
        if (Common.getPaletaClient().zmienStatusPalety(paleta.id_xxx_paleta, 3) != null) {
            this.listaTable.removeRecord(paleta);
        }
        return true;
    }

    protected Paleta[] getReloadedData() {
        return Common.getPaletaClient().getListaPaletDoZaladowania();
    }

    protected boolean hasFilter() {
        return false;
    }

    protected boolean needDefaultEanScanning() {
        return true;
    }

    protected void analiseFoundPalet(Paleta paleta) {
        if (this.markPaletAsLoaded(paleta, false)) {
            this.scannedEan.setText("");
        }
        this.scannedEan.selectAll();
        this.scannedEan.forceFocus();
    }
}

