/*
 * Decompiled with CFR 0.152.
 */
package ekspert.mobile.paleta;

import base.classes.ScanMatcher;
import base.data.ColumnDef;
import base.data.StringDataGetter;
import ekspert.mobile.Common;
import ekspert.mobile.ContC;
import ekspert.mobile.common.paleta.Paleta;
import ekspert.mobile.common.przeglady.base.RecordSelectionComposite;
import ekspert.mobile.gui.SwtCommon;
import ekspert.mobile.paleta.PaletaFiltr;
import ekspert.mobile.paleta.PaletaFiltrComposite;
import java.util.ArrayList;

public class PokazPalet
extends RecordSelectionComposite {
    protected PaletaFiltr paletaFiltr = new PaletaFiltr();
    protected Paleta directlySelectedRecord;
    private ColumnDef[] columnsDef;

    public PokazPalet(ContC parent) {
        super(parent);
        this.setTitle("Lista palet");
    }

    protected Paleta[] getReloadedData() {
        return Common.getPaletaClient().getListaPalet();
    }

    public Paleta wybierzPalete() {
        Object[] initList = this.getReloadedData();
        return (Paleta)this.getChoosenRecord(initList);
    }

    protected ColumnDef[] getColumnsDef() {
        if (this.columnsDef != null) {
            return this.columnsDef;
        }
        ColumnDef dataColumnDef = new ColumnDef("Nr", 10, new StringDataGetter(){

            public String getData(Object record) {
                return Integer.toString(((Paleta)record).nr_palety);
            }
        });
        ColumnDef idColumnDef = new ColumnDef("Id", 10, new StringDataGetter(){

            public String getData(Object record) {
                return Integer.toString(((Paleta)record).id_xxx_paleta);
            }
        });
        ColumnDef statusColumnDef = new ColumnDef("Status", 10, new StringDataGetter(){

            public String getData(Object record) {
                return ((Paleta)record).getPelenOpisStatusu();
            }
        });
        ColumnDef nazwaMagColumnDef = new ColumnDef("Magazyn", 20, new StringDataGetter(){

            public String getData(Object record) {
                return ((Paleta)record).nazwaMag;
            }
        });
        ColumnDef nazwaKtrColumnDef = new ColumnDef("Kontrahent", 20, new StringDataGetter(){

            public String getData(Object record) {
                return ((Paleta)record).nazwaKtr;
            }
        });
        this.columnsDef = new ColumnDef[]{dataColumnDef, idColumnDef, statusColumnDef, nazwaKtrColumnDef, nazwaMagColumnDef};
        return this.columnsDef;
    }

    protected ScanMatcher getScanMatcher() {
        return new PaletaScanner();
    }

    protected Object getSelectedRecord() {
        if (this.directlySelectedRecord != null) {
            return this.directlySelectedRecord;
        }
        return super.getSelectedRecord();
    }

    protected boolean hasFilter() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performFilterAction() {
        PaletaFiltr nowyFiltr = null;
        PaletaFiltrComposite filtrComposite = new PaletaFiltrComposite(this.contC);
        SwtCommon.centerOnParent(filtrComposite);
        this.listaTable.setEnabled(false);
        try {
            nowyFiltr = filtrComposite.filtruj(this.paletaFiltr);
        }
        finally {
            this.listaTable.setEnabled(true);
        }
        if (nowyFiltr == null) {
            return;
        }
        this.paletaFiltr = nowyFiltr;
        if (this.paletaFiltr.isEmpty()) {
            this.setShownRecords(this.getInitialArray());
            this.updateFilterButtonCaption();
            return;
        }
        this.updateFilterButtonCaption();
        this.setShownRecords(this.getFilteredRecords());
    }

    protected void updateFilterButtonCaption() {
        if (this.filtrujBtn != null && this.paletaFiltr != null) {
            this.filtrujBtn.setText(this.paletaFiltr.isEmpty() ? "Filtruj" : "Filtruj *");
        }
    }

    protected Object[] getFilteredRecords() {
        ArrayList<Paleta> resList = new ArrayList<Paleta>();
        Object[] initArray = this.getInitialArray();
        for (int index = 0; index < initArray.length; ++index) {
            Paleta paleta = (Paleta)initArray[index];
            if (!this.paletaFiltr.matches(paleta)) continue;
            resList.add(paleta);
        }
        return resList.toArray(new Paleta[0]);
    }

    protected class PaletaScanner
    implements ScanMatcher {
        boolean correct;
        int searchedId;

        protected PaletaScanner() {
        }

        public void initializeSearch(String text) {
            this.correct = false;
            Integer boxedId = null;
            try {
                boxedId = new Integer(text.trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (boxedId != null) {
                this.correct = true;
                this.searchedId = boxedId;
            }
        }

        public boolean matches(Object item) {
            if (!this.correct) {
                return false;
            }
            if (item == null) {
                return false;
            }
            Paleta paleta = (Paleta)item;
            return paleta.id_xxx_paleta == this.searchedId;
        }

        public String getNotFoundMessage() {
            return "Nie znaleziono palety.";
        }

        public void processFoundRecord(Object item) {
            PokazPalet.this.directlySelectedRecord = (Paleta)item;
            PokazPalet.this.zakonczUI();
        }
    }
}

