/*
 * Decompiled with CFR 0.152.
 */
package ekspert.mobile.spr;

import base.controls.ControlFactory;
import base.controls.ExtendedLabel;
import base.controls.ExtendedTableItem;
import base.controls.ExtendedText;
import ekspert.mobile.Common;
import ekspert.mobile.ContC;
import ekspert.mobile.Main;
import ekspert.mobile.UtilsM;
import ekspert.mobile.common.KodEan128Parser;
import ekspert.mobile.common.KodEan128Result;
import ekspert.mobile.common.UstawieniaOkna;
import ekspert.mobile.common.obj.Dostawa;
import ekspert.mobile.common.obj.StanKartMskl;
import ekspert.mobile.common.obj.StanMskl;
import ekspert.mobile.common.obj.Towar;
import ekspert.mobile.common.obj.TowarSzukanie;
import ekspert.mobile.common.print.PrnIF;
import ekspert.mobile.common.przeglady.PrzegladyUtils;
import ekspert.mobile.common.spr.SprClientConfig;
import ekspert.mobile.common.spr.SprIF;
import ekspert.mobile.dod.MainDOD;
import ekspert.mobile.gui.CompositeDialog;
import ekspert.mobile.gui.SwtCommon;
import ekspert.mobile.gui.dialogs.StringInputDialog;
import ekspert.mobile.spr.SprWiecejCD;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class SprMainDialog
extends CompositeDialog {
    private Text eanText;
    private Label indeksL;
    private Label nazwaskrL;
    private Label jmL;
    private Label opakL;
    private Label eanOpakL;
    private Label eanL;
    private SprClientConfig conf;
    private ExtendedText cechaT;
    private Label nazwaDlL;
    private Label stan2L;
    private Label stanL;
    private Label vatL;
    private Label cenaL;
    private Label stan2descL;
    private Towar szczegoly;
    private TabFolder tabFolder;
    private TabItem podstTab;
    private TabItem stanyTab;
    private Table stanyT;
    private Table dostawyT;
    private Button btnPowroc;
    private Button btnSkanuj;
    private Button btnSzukajWiecej;
    private TabItem dostawyTab;
    private Button dod2giBtn;
    private Composite cTop;
    private ExtendedText cecha2T;
    private Button btnZmienMSKL;
    private int newIdMskl;
    private String newKodMskl;
    static final int K_D_DATA = 0;
    static final int K_D_WAZN = 1;
    static final int K_D_ILOSC = 2;
    static final int K_D_NR = 3;
    static final int K_D_DOK = 4;
    static final int K_D_CENA = 5;
    static final int K_D_POLE2 = 6;
    static final int K_D_KONTR = 7;
    static final int ST_MA = 0;
    static final int ST_MS = 1;
    static final int ST_IL = 2;
    private Button btnDruk;
    private Label lNieaktywny;
    private Label lNazwyCech;
    private Composite c1;
    private Composite c3;
    private Button dodEanB;
    private SprIF SPR;
    private StanKartMskl[] stany;
    private Dostawa[] dostawy;
    private KodEan128Parser parserE;
    private ContC contC;
    SelectionAdapter selAd = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent evt) {
            if (evt.getSource() == SprMainDialog.this.btnPowroc) {
                SprMainDialog.this.zakonczUI = true;
            } else if (evt.getSource() == SprMainDialog.this.btnSkanuj) {
                SprMainDialog.this.szukaj();
            } else if (evt.getSource() == SprMainDialog.this.btnSzukajWiecej) {
                SprMainDialog.this.szukajWiecej();
            } else if (evt.getSource() == SprMainDialog.this.tabFolder) {
                SprMainDialog.this.onAfterPanelChanged();
            } else if (evt.getSource() == SprMainDialog.this.dod2giBtn) {
                if (SprMainDialog.this.szczegoly == null) {
                    return;
                }
                new MainDOD(Common.getSprClient(), Common.getDodClient(), SprMainDialog.this.contC).obslugaWpisanoNieZnaleziono(SprMainDialog.this.zeskanowanyEan);
            } else if (evt.getSource() == SprMainDialog.this.btnDruk) {
                if (SprMainDialog.this.szczegoly == null) {
                    return;
                }
                SprMainDialog.this.drukEtykiety();
            } else if (evt.getSource() == SprMainDialog.this.dodEanB) {
                if (SprMainDialog.this.szczegoly == null) {
                    return;
                }
                SprMainDialog.this.dodajEan();
            } else if (evt.getSource() == SprMainDialog.this.dostawyT) {
                int ind = SprMainDialog.this.dostawyT.getSelectionIndex();
                if (ind == -1) {
                    SprMainDialog.this.btnZmienMSKL.setEnabled(false);
                } else {
                    SprMainDialog.this.btnZmienMSKL.setEnabled(true);
                }
            } else if (evt.getSource() == SprMainDialog.this.btnZmienMSKL) {
                SprMainDialog.this.zmianaMiejscaSkladowania();
            }
            if (!SprMainDialog.this.isDisposed()) {
                SprMainDialog.this.eanText.setFocus();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            if (e.getSource() == SprMainDialog.this.eanText) {
                SprMainDialog.this.szukaj();
            } else if (e.getSource() == SprMainDialog.this.dostawyT) {
                SprMainDialog.this.dostawyTwDS();
            }
            if (!SprMainDialog.this.isDisposed()) {
                SprMainDialog.this.eanText.setFocus();
            }
        }
    };
    KeyAdapter keyList = new KeyAdapter(){

        public void keyPressed(KeyEvent arg0) {
            if (arg0.keyCode == 27) {
                SprMainDialog.this.zakonczUI = true;
            } else if (arg0.keyCode == 0x1000001) {
                int curr = SprMainDialog.this.tabFolder.getSelectionIndex();
                if (curr < SprMainDialog.this.tabFolder.getItemCount() - 1) {
                    SprMainDialog.this.tabFolder.setSelection(curr + 1);
                    SprMainDialog.this.onAfterPanelChanged();
                }
            } else if (arg0.keyCode == 0x1000002) {
                int curr = SprMainDialog.this.tabFolder.getSelectionIndex();
                if (curr > 0) {
                    SprMainDialog.this.tabFolder.setSelection(curr - 1);
                    SprMainDialog.this.onAfterPanelChanged();
                }
            } else {
                return;
            }
        }
    };
    FocusListener focList = new FocusAdapter(){

        public void focusLost(FocusEvent e) {
            if (SprMainDialog.this.szczegoly == null) {
                return;
            }
            Object src = e.getSource();
            if (src == SprMainDialog.this.cechaT) {
                String cecha1 = SprMainDialog.this.cechaT.getText();
                if (!cecha1.equals(((SprMainDialog)SprMainDialog.this).szczegoly.cecha)) {
                    ((SprMainDialog)SprMainDialog.this).szczegoly.cecha = cecha1;
                    SprMainDialog.this.SPR.zapiszCeche(((SprMainDialog)SprMainDialog.this).szczegoly.id, ((SprMainDialog)SprMainDialog.this).szczegoly.cecha, null);
                }
            } else if (src == SprMainDialog.this.cecha2T) {
                String cecha2 = SprMainDialog.this.cecha2T.getText();
                if (!cecha2.equals(((SprMainDialog)SprMainDialog.this).szczegoly.cecha2)) {
                    ((SprMainDialog)SprMainDialog.this).szczegoly.cecha2 = cecha2;
                    SprMainDialog.this.SPR.zapiszCeche(((SprMainDialog)SprMainDialog.this).szczegoly.id, null, ((SprMainDialog)SprMainDialog.this).szczegoly.cecha2);
                }
            } else {
                System.err.println("nieznane zrodlo " + src);
            }
        }
    };
    private String zeskanowanyEan;

    public SprMainDialog(ContC parent) {
        super(parent, 0);
        this.contC = parent;
        this.initGUI();
    }

    void initGUI() {
        this.setLayout((Layout)new FormLayout());
        this.cTop = new Composite((Composite)this, 0);
        FormData fd_cTop = new FormData();
        fd_cTop.right = new FormAttachment(100, -8);
        fd_cTop.top = new FormAttachment(0);
        fd_cTop.left = new FormAttachment(0);
        this.cTop.setLayoutData((Object)fd_cTop);
        RowLayout rl_cTop = new RowLayout(256);
        rl_cTop.marginBottom = 0;
        rl_cTop.marginTop = 0;
        rl_cTop.marginRight = 0;
        rl_cTop.marginLeft = 0;
        rl_cTop.spacing = 1;
        rl_cTop.center = true;
        this.cTop.setLayout((Layout)rl_cTop);
        this.createGora(this.cTop);
        this.mkBaseTab();
        this.mkExtTab();
        this.stanyTab = new TabItem(this.tabFolder, 0);
        this.stanyTab.setText("Stany");
        this.stanyT = this.createStany();
        this.stanyTab.setControl((Control)this.stanyT);
        this.dostawyTab = new TabItem(this.tabFolder, 0);
        this.dostawyTab.setText("Dostawy");
        this.dostawyT = this.createDostawy();
        this.dostawyTab.setControl((Control)this.dostawyT);
        Composite cDol = new Composite((Composite)this, 0);
        FormData fd_cDol = new FormData();
        fd_cDol.top = new FormAttachment(100, -27);
        fd_cDol.bottom = new FormAttachment(100);
        fd_cDol.right = new FormAttachment(100);
        fd_cDol.left = new FormAttachment(0);
        cDol.setLayoutData((Object)fd_cDol);
        RowLayout rl_cDol = new RowLayout(256);
        rl_cDol.marginTop = 0;
        rl_cDol.marginRight = 0;
        rl_cDol.marginLeft = 0;
        cDol.setLayout((Layout)rl_cDol);
        this.btnPowroc = new Button(cDol, 0);
        this.btnPowroc.addSelectionListener((SelectionListener)this.selAd);
        this.btnPowroc.setText("Powr\u00f3\u0107");
        this.btnZmienMSKL = new Button(cDol, 0);
        this.btnZmienMSKL.addSelectionListener((SelectionListener)this.selAd);
        this.btnZmienMSKL.setText("MSKL");
        this.btnZmienMSKL.setVisible(false);
        this.dod2giBtn = new Button(cDol, 0x1000000);
        this.dod2giBtn.addSelectionListener((SelectionListener)this.selAd);
        this.dod2giBtn.setText("Dod 2gi ind");
        this.btnDruk = new Button(cDol, 0);
        this.btnDruk.addSelectionListener((SelectionListener)this.selAd);
        this.btnDruk.setText(" Druk ");
        this.setSize(Main.shellWidth, Main.containerHeight);
    }

    Table createStany() {
        this.stanyT = new Table((Composite)this.tabFolder, 67584);
        this.stanyT.setHeaderVisible(true);
        this.stanyT.setLinesVisible(true);
        TableColumn tcMag = new TableColumn(this.stanyT, 0);
        tcMag.setWidth(69);
        tcMag.setText("Magazyn");
        TableColumn tcMiejsce = new TableColumn(this.stanyT, 0);
        tcMiejsce.setWidth(80);
        tcMiejsce.setText("Miejsce");
        TableColumn tcIlosc = new TableColumn(this.stanyT, 0);
        tcIlosc.setMoveable(true);
        tcIlosc.setWidth(76);
        tcIlosc.setText("Ilo\u015b\u0107");
        return this.stanyT;
    }

    Table createDostawy() {
        this.dostawyT = new Table((Composite)this.tabFolder, 67586);
        this.dostawyT.setLinesVisible(true);
        this.dostawyT.setHeaderVisible(true);
        this.dostawyT.addSelectionListener((SelectionListener)this.selAd);
        TableColumn tcData = new TableColumn(this.dostawyT, 0);
        tcData.setMoveable(true);
        tcData.setWidth(45);
        tcData.setText("Data");
        TableColumn tcWaznosc = new TableColumn(this.dostawyT, 0);
        tcWaznosc.setMoveable(true);
        tcWaznosc.setWidth(55);
        tcWaznosc.setText("Wa\u017cno\u015b\u0107");
        TableColumn tcStan = new TableColumn(this.dostawyT, 0);
        tcStan.setMoveable(true);
        tcStan.setWidth(47);
        tcStan.setText("Stan");
        TableColumn tcNrdost = new TableColumn(this.dostawyT, 0);
        tcNrdost.setMoveable(true);
        tcNrdost.setWidth(60);
        tcNrdost.setText("Nr. dost.");
        TableColumn tcDok = new TableColumn(this.dostawyT, 0);
        tcDok.setMoveable(true);
        tcDok.setWidth(51);
        tcDok.setText("Dok.");
        TableColumn tcCena = new TableColumn(this.dostawyT, 0);
        tcCena.setMoveable(true);
        tcCena.setWidth(35);
        tcCena.setText("Cena");
        TableColumn tcPole2 = new TableColumn(this.dostawyT, 0);
        tcPole2.setMoveable(true);
        tcPole2.setWidth(35);
        tcPole2.setText("Pole2");
        TableColumn tcKontrah = new TableColumn(this.dostawyT, 0);
        tcKontrah.setMoveable(true);
        tcKontrah.setWidth(35);
        tcKontrah.setText("Kontrah");
        return this.dostawyT;
    }

    private void createGora(Composite compositeTop) {
        ExtendedLabel lblEan = ControlFactory.createLabel(compositeTop, 0);
        lblEan.setText("EAN:");
        this.eanText = new Text(compositeTop, 2048);
        this.eanText.addSelectionListener((SelectionListener)this.selAd);
        this.eanText.setLayoutData((Object)new RowData(111, -1));
        this.eanText.addKeyListener((KeyListener)this.keyList);
        this.btnSkanuj = new Button(compositeTop, 0);
        this.btnSkanuj.addSelectionListener((SelectionListener)this.selAd);
        this.btnSkanuj.setText("Skanuj");
        this.btnSzukajWiecej = new Button(compositeTop, 0);
        this.btnSzukajWiecej.addSelectionListener((SelectionListener)this.selAd);
        this.btnSzukajWiecej.setLayoutData((Object)new RowData(30, -1));
        this.btnSzukajWiecej.setText("...");
        this.tabFolder = new TabFolder((Composite)this, 1024);
        this.tabFolder.addSelectionListener((SelectionListener)this.selAd);
        FormData fd_compositeData = new FormData();
        fd_compositeData.bottom = new FormAttachment(100, -27);
        fd_compositeData.right = new FormAttachment(100);
        fd_compositeData.top = new FormAttachment(0, 24);
        fd_compositeData.left = new FormAttachment(0);
        this.tabFolder.setLayoutData((Object)fd_compositeData);
    }

    private void mkExtTab() {
        TabItem tiRozsz = new TabItem(this.tabFolder, 0);
        tiRozsz.setText("Rozsz");
        Composite c1 = new Composite((Composite)this.tabFolder, 0);
        tiRozsz.setControl((Control)c1);
        GridLayout gl_c1 = new GridLayout(2, false);
        gl_c1.verticalSpacing = 3;
        c1.setLayout((Layout)gl_c1);
        ExtendedLabel l4 = ControlFactory.createLabel(c1, 0);
        GridData gd_l4 = new GridData(16384, 128, false, false, 1, 1);
        gd_l4.minimumWidth = 100;
        l4.setLayoutData(gd_l4);
        l4.setText("Nazwa Dl:");
        this.nazwaDlL = ControlFactory.createLabel(c1, 64);
        this.nazwaDlL.setText("    ");
        GridData gd_nazwaDlLab = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_nazwaDlLab.widthHint = 161;
        gd_nazwaDlLab.heightHint = 68;
        this.nazwaDlL.setLayoutData((Object)gd_nazwaDlLab);
        ExtendedLabel l8 = ControlFactory.createLabel(c1, 0);
        l8.setText("EAN opak:");
        this.eanOpakL = ControlFactory.createLabel(c1, 0);
        this.eanOpakL.setText("      ");
        GridData gd_eanOpakLab = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_eanOpakLab.widthHint = 159;
        this.eanOpakL.setLayoutData((Object)gd_eanOpakLab);
        ExtendedLabel l9 = ControlFactory.createLabel(c1, 0);
        l9.setText("EAN:");
        this.c3 = new Composite(c1, 0);
        GridLayout gl_c3 = new GridLayout(2, false);
        gl_c3.verticalSpacing = 0;
        gl_c3.marginWidth = 0;
        gl_c3.marginHeight = 0;
        gl_c3.horizontalSpacing = 0;
        this.c3.setLayout((Layout)gl_c3);
        this.c3.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.eanL = ControlFactory.createLabel(this.c3, 0);
        GridData gd_eanL = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_eanL.widthHint = 140;
        this.eanL.setLayoutData((Object)gd_eanL);
        this.eanL.setText("     ");
        this.dodEanB = new Button(this.c3, 0x800000);
        GridData gd_dodEanB = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_dodEanB.heightHint = 20;
        gd_dodEanB.widthHint = 20;
        this.dodEanB.setLayoutData((Object)gd_dodEanB);
        this.dodEanB.setText("+");
        this.dodEanB.addSelectionListener((SelectionListener)this.selAd);
        this.dodEanB.setVisible(false);
        ExtendedLabel l7 = ControlFactory.createLabel(c1, 0);
        l7.setText("VAT:");
        this.vatL = ControlFactory.createLabel(c1, 0);
        GridData gd_VAT = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_VAT.widthHint = 45;
        this.vatL.setLayoutData((Object)gd_VAT);
        this.vatL.setText("5%");
        ExtendedLabel l3 = ControlFactory.createLabel(c1, 0);
        l3.setText("Cena:");
        this.cenaL = ControlFactory.createLabel(c1, 0);
        GridData gd_cenaLab = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_cenaLab.widthHint = 68;
        this.cenaL.setLayoutData((Object)gd_cenaLab);
        this.cenaL.setText("1320");
    }

    private void mkBaseTab() {
        this.podstTab = new TabItem(this.tabFolder, 0);
        this.podstTab.setText("Podst");
        Composite c2 = new Composite((Composite)this.tabFolder, 0);
        this.podstTab.setControl((Control)c2);
        GridLayout gl_c2 = new GridLayout(2, false);
        gl_c2.verticalSpacing = 3;
        c2.setLayout((Layout)gl_c2);
        ExtendedLabel l1 = ControlFactory.createLabel(c2, 0);
        l1.setText("Indeks:");
        this.indeksL = ControlFactory.createLabel(c2, 0);
        GridData gd_indeksLab = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_indeksLab.widthHint = 145;
        gd_indeksLab.minimumWidth = 100;
        this.indeksL.setLayoutData((Object)gd_indeksLab);
        this.indeksL.setSize(150, 15);
        ExtendedLabel l3 = ControlFactory.createLabel(c2, 0);
        l3.setText("NazwaSkr:");
        this.nazwaskrL = ControlFactory.createLabel(c2, 0);
        GridData gd_nazwaskrLab = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_nazwaskrLab.widthHint = 146;
        this.nazwaskrL.setLayoutData((Object)gd_nazwaskrLab);
        this.nazwaskrL.setText("   ");
        ExtendedLabel l5 = ControlFactory.createLabel(c2, 0);
        l5.setText("JM:");
        this.jmL = ControlFactory.createLabel(c2, 0);
        GridData gd_jmL = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_jmL.widthHint = 114;
        this.jmL.setLayoutData((Object)gd_jmL);
        this.jmL.setText("");
        ExtendedLabel l2 = ControlFactory.createLabel(c2, 0);
        l2.setText("Opak.:");
        this.opakL = ControlFactory.createLabel(c2, 0);
        GridData gd_opakLab = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_opakLab.widthHint = 100;
        this.opakL.setLayoutData((Object)gd_opakLab);
        this.opakL.setText("     ");
        this.c1 = new Composite(c2, 0);
        GridLayout gl_composite = new GridLayout(4, false);
        gl_composite.verticalSpacing = 1;
        gl_composite.marginWidth = 1;
        gl_composite.marginHeight = 1;
        this.c1.setLayout((Layout)gl_composite);
        this.c1.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        ExtendedLabel label_10 = ControlFactory.createLabel(this.c1, 0);
        label_10.setText("Stan:");
        this.stanL = ControlFactory.createLabel(this.c1, 0);
        this.stanL.setText("                    ");
        this.stan2descL = ControlFactory.createLabel(this.c1, 0);
        this.stan2descL.setText("Stan Dysp:");
        this.stan2L = ControlFactory.createLabel(this.c1, 0);
        this.stan2L.setText("                   ");
        this.lNazwyCech = ControlFactory.createLabel(c2, 0);
        this.lNazwyCech.setText(" ");
        this.lNazwyCech.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.cechaT = ControlFactory.createText(c2, 2048);
        this.cechaT.setLayoutData(new GridData(4, 0x1000000, true, false, 2, 1));
        this.cechaT.addFocusListener(this.focList);
        this.cecha2T = ControlFactory.createText(c2, 2048);
        this.cecha2T.setLayoutData(new GridData(4, 0x1000000, true, false, 2, 1));
        this.lNieaktywny = ControlFactory.createLabel(c2, 0);
        this.lNieaktywny.setForeground(this.getDisplay().getSystemColor(3));
        this.lNieaktywny.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        SwtCommon.setConrolFontBold((Control)this.lNieaktywny);
        this.lNieaktywny.setVisible(true);
        this.cecha2T.addFocusListener(this.focList);
        this.cechaT.setMaxLength(35);
        this.cecha2T.setMaxLength(35);
    }

    protected void onAfterPanelChanged() {
        if (this.szczegoly == null) {
            return;
        }
        TabItem selectedTab = this.tabFolder.getItem(this.tabFolder.getSelectionIndex());
        if (selectedTab == this.stanyTab) {
            if (this.stany == null) {
                this.pokazStany();
            }
        } else if (selectedTab == this.dostawyTab) {
            if (this.dostawy == null) {
                this.pokazDostawy();
            }
            this.btnZmienMSKL.setVisible(true);
            this.btnZmienMSKL.setEnabled(false);
        }
    }

    protected void dodajEan() {
        boolean res = new MainDOD(Common.getSprClient(), Common.getDodClient(), this.contC).dodajDoIndeksu(this.szczegoly);
        if (res) {
            this.szczegoly = this.SPR.szczegolyTowaru(this.szczegoly.id);
            this.pokazDane(this.szczegoly);
        }
    }

    protected void dostawyTwDS() {
        int ind = this.dostawyT.getSelectionIndex();
        if (ind == -1) {
            return;
        }
        Dostawa d = (Dostawa)this.dostawyT.getItem(ind).getData();
        String res = this.SPR.dostawaInfo(d.id);
        if (res != null && res.length() > 0) {
            SwtCommon.info(this.getShell(), res);
        }
    }

    void pokazStany() {
        this.stany = this.SPR.getStanyMskl(this.szczegoly.id);
        if (this.stany == null) {
            return;
        }
        this.stanyT.setRedraw(false);
        for (int i = 0; i < this.stany.length; ++i) {
            ExtendedTableItem item = new ExtendedTableItem(this.stanyT, 0);
            item.setText(0, this.stany[i].kodMag);
            item.setText(1, this.stany[i].kodMskl);
            item.setText(2, UtilsM.formatDoubleIlosc(this.stany[i].ilosc));
        }
        this.stanyT.getColumn(2).setAlignment(131072);
        SwtCommon.ustawAutoSzerokoscKolumn(this.stanyT);
        this.stanyT.setRedraw(true);
    }

    void pokazDostawy() {
        this.dostawy = this.SPR.pobierzDostawy(this.szczegoly.id);
        if (this.dostawy == null) {
            return;
        }
        this.dostawyT.setRedraw(false);
        for (int i = 0; i < this.dostawy.length; ++i) {
            ExtendedTableItem item = new ExtendedTableItem(this.dostawyT, 0);
            item.setText(0, this.dostawy[i].dataDost);
            String dataW = this.dostawy[i].dataWazn;
            if (!"1899-12-30".equals(dataW)) {
                item.setText(1, dataW);
            }
            item.setText(2, UtilsM.formatDoubleIlosc(this.dostawy[i].ilosc));
            item.setText(3, this.dostawy[i].nrDost);
            item.setText(4, this.dostawy[i].sdd + " " + this.dostawy[i].nrdokwew);
            if (this.conf.pokazujCeneDostawy) {
                item.setText(5, Double.toString(this.dostawy[i].cenaZak));
            }
            if (this.conf.dostPole2 != null && this.conf.dostPole2.length() > 0) {
                item.setText(6, this.dostawy[i].pole2);
            }
            if (this.dostawy[i].kontrah != null) {
                item.setText(7, this.dostawy[i].kontrah);
            }
            item.setData(this.dostawy[i]);
        }
        this.dostawyT.getColumn(2).setAlignment(131072);
        if (this.conf.dostPole2 != null && this.conf.dostPole2.length() > 0) {
            this.dostawyT.getColumn(6).setText(this.conf.dostPole2);
        } else {
            this.dostawyT.getColumn(6).setText("");
            this.dostawyT.getColumn(6).setWidth(0);
        }
        this.dostawyT.setRedraw(true);
    }

    protected void szukaj() {
        String kod = this.eanText.getText();
        if (kod.length() == 0) {
            this.szukajWiecej();
            return;
        }
        this.eanText.setText("");
        KodEan128Result res2 = this.parserE.parsuj(kod);
        if (res2 != null) {
            this.obslugaEtykiety(res2);
            return;
        }
        this.szukajEan(kod);
    }

    public void szukajEan(String kod) {
        TowarSzukanie[] listaTowarow = this.SPR.szukajTowaruEan(kod);
        if (listaTowarow == null) {
            SwtCommon.alert(this.getShell(), "b\u0142\u0105d pobierania listy towar\u00f3w");
            return;
        }
        if (listaTowarow.length == 0) {
            int ret = SwtCommon.confirm(this.getShell(), "nie znaleziono kodu ean, czy chcesz dodac?");
            if (ret != 64) {
                return;
            }
            MainDOD dod = new MainDOD(this.SPR, Common.getDodClient(), this.contC);
            TowarSzukanie dodany = dod.obslugaWpisanoNieZnaleziono(kod);
            if (dodany != null) {
                this.szukajEan(kod);
            }
            return;
        }
        this.znalezionoTowar(listaTowarow, kod);
    }

    private void obslugaEtykiety(KodEan128Result res2) {
        if (res2.eanTowaru != null && res2.partia == null) {
            this.szukajEan(res2.eanTowaru);
            return;
        }
        Towar towar = this.SPR.szukajTowarNrPartii(res2.partia);
        if (towar == null) {
            SwtCommon.alert(this.getShell(), "blad pobierania szczeg\u00f3\u0142\u00f3w");
            return;
        }
        if (towar.id == -3) {
            SwtCommon.alert(this.getShell(), "brak dostawy lub dostawa zostala rozchodowana");
            return;
        }
        this.pokazDanePartii(towar, res2.partia);
    }

    private void znalezionoTowar(TowarSzukanie[] listaTowarow, String zeskanowanyEan) {
        TowarSzukanie ktory;
        if (this.isDisposed()) {
            return;
        }
        if (listaTowarow.length == 1) {
            ktory = listaTowarow[0];
        } else {
            ktory = PrzegladyUtils.wybierzTowar(this.contC, listaTowarow, this.conf);
            if (ktory == null || ktory == PrzegladyUtils.TOWAR_POWROC) {
                return;
            }
        }
        System.out.println("ktory: " + ktory);
        Towar szczegoly = this.SPR.szczegolyTowaru(ktory.id);
        if (szczegoly == null) {
            SwtCommon.alert(this.getShell(), "blad pobierania szczeg\u00f3\u0142\u00f3w");
            return;
        }
        this.pokazDane(szczegoly);
        this.zeskanowanyEan = zeskanowanyEan;
        this.tabFolder.setSelection(0);
    }

    private void pokazDanePartii(Towar szczegoly2, String partia) {
        this.pokazDane(szczegoly2);
        this.pokazDostawy();
        if (this.dostawy == null) {
            return;
        }
        for (int i = 0; i < this.dostawy.length; ++i) {
            if (!this.dostawy[i].nrDost.equals(partia)) continue;
            this.dostawyT.select(i);
            this.dostawyT.showSelection();
            TableItem it = this.dostawyT.getItem(i);
            SprMainDialog.setItemFontBold(it);
        }
        this.tabFolder.setSelection(this.dostawyTab);
        this.dostawyT.setFocus();
        this.onAfterPanelChanged();
    }

    public static void setItemFontBold(TableItem table) {
        FontData fd = table.getFont().getFontData()[0];
        System.out.println("stary font: " + fd.getStyle() + " ustawiam na bold");
        fd.setStyle(1);
        Font f = new Font((Device)Display.getDefault(), fd);
        table.setFont(f);
    }

    private void pokazDane(Towar szczegoly) {
        this.szczegoly = szczegoly;
        this.stany = null;
        this.stanyT.removeAll();
        this.dostawy = null;
        this.dostawyT.removeAll();
        if (szczegoly.akt == 0) {
            this.lNieaktywny.setVisible(true);
            this.lNieaktywny.setText("NIEAKTYWNA !!!");
        } else if (szczegoly.aktM == 0) {
            this.lNieaktywny.setVisible(true);
            this.lNieaktywny.setText("INNY MAGAZYN !!!");
        } else {
            this.lNieaktywny.setVisible(false);
        }
        this.indeksL.setText(szczegoly.indeks);
        this.nazwaskrL.setText(szczegoly.nazwaSkr);
        this.nazwaDlL.setText(szczegoly.nazwaDl);
        if (szczegoly.vat != null) {
            this.vatL.setText(szczegoly.vat);
        } else {
            this.vatL.setText("!!?!!");
        }
        if (this.conf.pokazCenaN) {
            this.cenaL.setText(Double.toString(szczegoly.cenaN) + " (N)");
        } else {
            this.cenaL.setText(Double.toString(szczegoly.cenaB) + " (B)");
        }
        this.jmL.setText(szczegoly.jm);
        String nazwyCech = "";
        this.cechaT.setEnabled(this.conf.nazwaCechy != null);
        if (this.conf.nazwaCechy != null) {
            nazwyCech = this.conf.nazwaCechy;
            this.cechaT.setText(UtilsM.ifNull(szczegoly.cecha));
        }
        this.cecha2T.setEnabled(this.conf.nazwa2Cechy != null);
        if (this.conf.nazwa2Cechy != null) {
            nazwyCech = UtilsM.napisPustyLubTylkoSpacje(nazwyCech) ? this.conf.nazwa2Cechy : nazwyCech + " / " + this.conf.nazwa2Cechy;
            this.cecha2T.setText(UtilsM.ifNull(szczegoly.cecha2));
        }
        this.lNazwyCech.setText(nazwyCech);
        this.stanL.setText(UtilsM.formatDoubleIlosc(szczegoly.stan));
        if (this.conf.stanDrugi.startsWith("D")) {
            this.stan2descL.setText("Stan Dysp.");
            this.stan2L.setText(UtilsM.formatDoubleIlosc(szczegoly.stanDysp));
        } else if (this.conf.stanDrugi.startsWith("T")) {
            this.stan2descL.setText("Stan Total");
            this.stan2L.setText(UtilsM.formatDoubleIlosc(szczegoly.stanTotal));
        } else {
            this.stan2descL.setVisible(false);
            this.stan2L.setVisible(false);
        }
        if (szczegoly.defOpak != null) {
            String opis = "(" + szczegoly.defOpak.ileWopak + ") " + szczegoly.defOpak.nazwa;
            this.opakL.setText(opis);
            if (szczegoly.defOpak.eany != null && szczegoly.defOpak.eany.length > 0) {
                this.eanOpakL.setText(szczegoly.defOpak.eany[0]);
            } else {
                this.eanOpakL.setText("");
            }
        } else {
            this.opakL.setText("");
            this.eanOpakL.setText("");
        }
        if (szczegoly.eany != null && szczegoly.eany.length > 0) {
            this.eanL.setText(szczegoly.eany[0]);
            this.dodEanB.setVisible(false);
        } else {
            this.dodEanB.setVisible(true);
            this.eanL.setText("");
        }
    }

    protected void szukajWiecej() {
        SprWiecejCD w = new SprWiecejCD(this.contC);
        String[] resultStrings = w.open();
        if (resultStrings == null) {
            return;
        }
        String indeksNazwa = resultStrings[0] + resultStrings[1];
        TowarSzukanie[] listaTowarow = this.SPR.szukajTowaruIndeksNazwa(indeksNazwa, false);
        if (listaTowarow == null) {
            SwtCommon.alert(this.getShell(), "b\u0142\u0105d pobierania listy towar\u00f3w");
            return;
        }
        if (listaTowarow.length != 0) {
            this.znalezionoTowar(listaTowarow, "");
            return;
        }
        SwtCommon.alert(this.getShell(), "nie znaleziono towaru!");
    }

    protected void drukEtykiety() {
        PrnIF PRN = Common.getPrnClient();
        String res = PRN.drukujEtykieteKart(this.szczegoly.id);
        System.out.println("drukowanie etykiety: " + res);
        if (res == null) {
            return;
        }
        if (res.startsWith("ERR")) {
            SwtCommon.alert(this.getShell(), "B\u0142ad drukowania:\n" + res);
        }
    }

    protected void zmianaMiejscaSkladowania() {
        int ind = this.dostawyT.getSelectionIndex();
        if (ind == -1) {
            return;
        }
        this.newIdMskl = -1;
        Dostawa d = (Dostawa)this.dostawyT.getItem(ind).getData();
        String kodMskl = this.SPR.szukajKodMSKLDostawy(d.id);
        StringInputDialog dialog = new StringInputDialog(this.getShell()){

            protected String getValidationError() {
                SprMainDialog.this.newKodMskl = super.getValue();
                if (SprMainDialog.this.newKodMskl.equals("")) {
                    return "Podaj kod MSKL";
                }
                SprMainDialog.this.newIdMskl = SprMainDialog.this.SPR.szukajIdMSKL(SprMainDialog.this.newKodMskl);
                if (SprMainDialog.this.newIdMskl == 0) {
                    return "Niew\u0142a\u015bciwy kod MSKL";
                }
                return "";
            }
        };
        if (dialog.executed("Kod miejsca sk\u0142adowania  ", "Podaj kod miejsca sk\u0142adowania", kodMskl) && this.newKodMskl != null) {
            if (!this.newKodMskl.equals(kodMskl) && this.newIdMskl > 0) {
                System.out.println("Nowe MSKL " + this.newKodMskl);
                this.SPR.zmienIdMSKLDostawy(d.id, this.newIdMskl);
                this.dostawyT.removeAll();
                this.pokazDostawy();
            } else {
                return;
            }
        }
    }

    public void sprawdzaj(SprIF spr, SprClientConfig conf) {
        this.setupSprawdzaj(spr, conf);
        UstawieniaOkna.czytaj(((Object)((Object)this)).getClass().getName() + "_stany", this.stanyT);
        UstawieniaOkna.czytaj(((Object)((Object)this)).getClass().getName() + "_dostawy", this.dostawyT);
        this.runUI((Control)this.eanText);
        UstawieniaOkna.zapisz(((Object)((Object)this)).getClass().getName() + "_dostawy", this.dostawyT);
        UstawieniaOkna.zapisz(((Object)((Object)this)).getClass().getName() + "_stany", this.stanyT);
    }

    void setupSprawdzaj(SprIF spr, SprClientConfig conf) {
        this.conf = conf;
        this.SPR = spr;
        this.parserE = new KodEan128Parser(Common.magClientConf.kodyEtykiet);
        this.dod2giBtn.setEnabled(conf.DODAJ_EAN_INNY_INDEKS);
    }

    public void info(SprIF spr, SprClientConfig conf2, StanMskl doPokazania) {
        this.SPR = spr;
        this.conf = conf2;
        this.cTop.setVisible(false);
        this.dod2giBtn.setVisible(false);
        TowarSzukanie towar = this.SPR.szukajTowaruIndeks(doPokazania.indeks);
        Towar szczegoly = this.SPR.szczegolyTowaru(towar.id);
        this.pokazDane(szczegoly);
        this.tabFolder.addKeyListener((KeyListener)this.keyList);
        this.runUI((Control)this.tabFolder);
    }

    public void infoWpr(SprIF spr, SprClientConfig conf2, Towar sz) {
        this.SPR = spr;
        this.conf = conf2;
        this.cTop.setVisible(false);
        this.dod2giBtn.setVisible(false);
        this.szczegoly = sz;
        this.pokazDane(this.szczegoly);
        this.tabFolder.addKeyListener((KeyListener)this.keyList);
        this.runUI((Control)this.tabFolder);
    }
}

