/*
 * Decompiled with CFR 0.152.
 */
package ekspert.mobile.util;

public class BufferedInteger {
    private static final int MAX_SIZE = 512;
    private int minValue;
    private int maxValue;
    private Integer[] buffer;

    public BufferedInteger(int minValue, int maxValue) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.checkMaxSize();
        this.buffer = new Integer[maxValue - minValue + 1];
    }

    public BufferedInteger() {
        this(-128, 127);
    }

    private void checkMaxSize() {
        if (this.maxValue - this.minValue + 1 > 512) {
            throw new RuntimeException("Przekroczona wartosc MAX_SIZE");
        }
    }

    public Integer getInteger(int value) {
        if (value >= this.minValue && value <= this.maxValue) {
            int index = value - this.minValue;
            if (this.buffer[index] != null) {
                return this.buffer[index];
            }
            this.buffer[index] = new Integer(value);
            return this.buffer[index];
        }
        return new Integer(value);
    }
}

