/*
 * Decompiled with CFR 0.152.
 */
package ekspert.mobile.wer;

import ekspert.mobile.Common;
import ekspert.mobile.ContC;
import ekspert.mobile.LocalConfig;
import ekspert.mobile.common.obj.NaglM;
import ekspert.mobile.common.print.PrnIF;
import ekspert.mobile.common.przeglady.PrzegladyUtils;
import ekspert.mobile.common.wer.StatMsgVal;
import ekspert.mobile.common.wer.WerClientConfig;
import ekspert.mobile.common.wer.WerIF;
import ekspert.mobile.gui.SwtCommon;
import ekspert.mobile.wer.LpAwiC;
import ekspert.mobile.wer.PozycjeWerCNewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class MainWER {
    static Color red;
    static Color green;
    static Color blue;
    static Color black;
    static Color yellow;
    private static Shell shell;
    Image logo;
    public ContC containerC;
    private LocalConfig localConf;
    public WerClientConfig conf = null;
    private WerIF WER;
    LocalConfig c = null;

    public MainWER(LocalConfig localConf2, ContC container) {
        this.containerC = container;
        shell = container.getShell();
        Display display = shell.getDisplay();
        red = display.getSystemColor(3);
        green = display.getSystemColor(5);
        blue = display.getSystemColor(9);
        black = display.getSystemColor(2);
        yellow = display.getSystemColor(8);
        this.localConf = localConf2;
        this.WER = Common.getWerClient();
        this.conf = Common.getWerCC();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mainLoop(boolean trybPrzyjecia) {
        Integer fSize = this.localConf.getLocalFontSize();
        while (!this.containerC.isDisposed()) {
            NaglM doWeryfikacji = PrzegladyUtils.wybierzeDokumentDoWeryfikacji(this.containerC, trybPrzyjecia, fSize);
            if (doWeryfikacji == null) {
                return;
            }
            StatMsgVal res = this.WER.otworzDokWer(doWeryfikacji.id);
            if (res == null) continue;
            if (res.status == 10) {
                SwtCommon.alert(shell, "Niepowodzenie preweryfikacji: " + res.msg);
                continue;
            }
            if (res.msg != null && res.msg.length() > 0) {
                SwtCommon.alert(shell, "Komunikat preweryfikacji: " + res.msg);
            }
            PozycjeWerCNewer pozWer = new PozycjeWerCNewer(this.containerC, doWeryfikacji, trybPrzyjecia, fSize, this.conf);
            try {
                pozWer.weryfikujDokument();
                continue;
            }
            finally {
                SwtCommon.safeDispose(pozWer);
                continue;
            }
            break;
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void werLP() {
        Integer fSize = this.localConf.getLocalFontSize();
        while (!this.containerC.isDisposed()) {
            NaglM[] listaDok = this.WER.listaLP();
            NaglM doWeryfikacji = PrzegladyUtils.wybierzListePrzewozowa(this.containerC, listaDok, "Listy przewozowe do weryfikacji");
            if (doWeryfikacji == null) {
                return;
            }
            String res = this.WER.sprawdzZgodnoscLP(doWeryfikacji.id);
            if (res == null) continue;
            if (res.startsWith("ERR")) {
                int yes = SwtCommon.confirm(shell, "b\u0142\u0105d zgodno\u015bci listu:\n" + res + "\nCzy chcesz rozpocz\u0105\u0107 weryfikacj\u0119 od nowa?");
                if (yes != 64) continue;
                this.WER.resetujLP(doWeryfikacji.id);
            }
            PozycjeWerCNewer p = new PozycjeWerCNewer(this.containerC, doWeryfikacji, true, null, this.conf);
            try {
                p.weryfikujListe(false);
                continue;
            }
            finally {
                SwtCommon.safeDispose(p);
                continue;
            }
            break;
        }
        return;
    }

    public void drukowanieLP() {
        PrnIF PRN = Common.getPrnClient();
        while (!this.containerC.isDisposed()) {
            NaglM[] listaDok = PRN.pobierzDokumentyDoDruku("LP");
            if (listaDok == null) {
                return;
            }
            NaglM res2 = PrzegladyUtils.wybierzDokumentDoDruku(this.containerC, listaDok, "Dokumenty LP do druku");
            if (this.containerC.isDisposed()) {
                return;
            }
            if (res2 == null) {
                return;
            }
            String res = PRN.drukujEtykieteLP(res2.id);
            System.out.println(res);
            if (res == null) continue;
            System.out.println(res);
            SwtCommon.alert(shell, "wydrukowane");
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awiLP() {
        while (!this.containerC.isDisposed()) {
            NaglM[] listaDok = this.WER.listaAwiLP();
            NaglM doAwi = PrzegladyUtils.wybierzListePrzewozowa(this.containerC, listaDok, "Listy przewozowe do awizacji");
            if (doAwi == null) {
                return;
            }
            String[] cechy = this.WER.otworzListAwi(doAwi.id);
            if (cechy == null) continue;
            String[] res = null;
            LpAwiC p = new LpAwiC(this.containerC);
            try {
                res = p.awizujLP(doAwi, cechy);
                if (res == null) {
                    continue;
                }
            }
            finally {
                SwtCommon.safeDispose(p);
                continue;
            }
            String msg = this.WER.zapiszListAwi(doAwi.id, res);
            if (msg == null || msg.length() <= 0) continue;
            SwtCommon.alert(shell, msg);
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awiWerLP() {
        while (!this.containerC.isDisposed()) {
            NaglM[] listaDok = this.WER.listaAwiWerLP();
            NaglM doAwiWer = PrzegladyUtils.wybierzListePrzewozowa(this.containerC, listaDok, "Listy do weryfikacji awizacji");
            if (doAwiWer == null) {
                return;
            }
            PozycjeWerCNewer p = new PozycjeWerCNewer(this.containerC, doAwiWer, true, null, this.conf);
            try {
                p.weryfikujListe(true);
                continue;
            }
            finally {
                SwtCommon.safeDispose(p);
                continue;
            }
            break;
        }
        return;
    }
}

