/*
 * Decompiled with CFR 0.152.
 */
package ekspert.mobile.wer;

import base.classes.BaseUtils;
import base.controls.ControlFactory;
import base.controls.ExtendedLabel;
import base.data.ColumnDef;
import base.data.RowConfiguration;
import base.data.RowConfigurator;
import base.data.StringDataGetter;
import ekspert.mobile.Common;
import ekspert.mobile.ContC;
import ekspert.mobile.MultiRowCode;
import ekspert.mobile.UtilsM;
import ekspert.mobile.common.DialogParams;
import ekspert.mobile.common.KodEan128Parser;
import ekspert.mobile.common.KodEan128Result;
import ekspert.mobile.common.PozycjeCNewer;
import ekspert.mobile.common.obj.NaglM;
import ekspert.mobile.common.obj.TowarSzukanie;
import ekspert.mobile.common.wer.PozWerM;
import ekspert.mobile.common.wer.StatMsgVal;
import ekspert.mobile.common.wer.WerClientConfig;
import ekspert.mobile.common.wer.WerIF;
import ekspert.mobile.datamodel.ManagedArray;
import ekspert.mobile.gui.SwtCommon;
import ekspert.mobile.util.Visitor;
import ekspert.mobile.wer.EdycjaCechCD;
import ekspert.mobile.wer.MainWER;
import ekspert.mobile.wer.WeryfikujC;
import ekspert.mobile.wer.WyborPozycjiWerC;
import ekspert.mobile.wer.WyszukPozWer;
import java.util.ArrayList;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;

public class PozycjeWerCNewer
extends PozycjeCNewer {
    protected boolean trybPrzyjecia;
    protected ManagedArray positions;
    protected WerIF werClient;
    protected WerClientConfig conf;
    protected NaglM doWeryfikacji;
    protected KodEan128Parser parserE;
    private boolean trybLP;
    private boolean trybAwi;
    private String[] cechyNagl;
    private static final StringDataGetter NAZWA_DL_GETTER = new StringDataGetter(){

        public String getData(Object record) {
            return ((PozWerM)record).sz.nazwaDl;
        }
    };
    private static final StringDataGetter NAZWA_SKR_GETTER = new StringDataGetter(){

        public String getData(Object record) {
            return ((PozWerM)record).sz.nazwaSkr;
        }
    };
    private ColumnDef[] columnDef = null;
    private RowConfigurator configurator = new RowConfigurator(){
        RowConfiguration configuration = new RowConfiguration(){

            public Color getForeground(Object record) {
                PozWerM pozWer = (PozWerM)record;
                return PozycjeWerCNewer.this.getPozColor(pozWer);
            }
        };

        public RowConfiguration getConfiguration(Object record) {
            return this.configuration;
        }
    };

    protected PozycjeWerCNewer(Shell p) {
        super(p);
    }

    public PozycjeWerCNewer(ContC parent, NaglM doWeryfikacji, boolean trybPrzyjecia, Integer fSize, WerClientConfig conf) {
        super(parent);
        this.trybPrzyjecia = trybPrzyjecia;
        this.conf = conf;
        this.doWeryfikacji = doWeryfikacji;
        this.werClient = Common.getWerClient();
        this.cechyNagl = this.werClient.getCechyNagl(doWeryfikacji.id);
        this.parserE = new KodEan128Parser(Common.magClientConf.kodyEtykiet);
        this.dParams.ukryjPozycjeOk = true;
        this.dParams.moznaCechy = false;
        this.dParams.moznaUkrywac = true;
        this.dParams.moznaUwagi = false;
        this.getShell().setDefaultButton(this.wpisBtn);
        if (fSize != null && this.listaTable != null) {
            this.listaTable.setFontSize(fSize);
        }
        this.initGui2();
        this.cNaPodst.setVisible(true);
        this.setDokInfo(doWeryfikacji.nrDokW);
    }

    protected void initGui2() {
        ExtendedLabel l3a = ControlFactory.createLabel(this.cNaPodst, 0);
        l3a.setText(this.doWeryfikacji.kontrah);
        this.cNaPodst.layout();
        this.layout();
    }

    protected String getPropertyFileName() {
        String baseString = super.getPropertyFileName();
        if (this.trybLP) {
            return baseString + "_Lp";
        }
        return baseString;
    }

    public void weryfikujDokument() {
        this.trybLP = false;
        this.reloadRecords();
        if (this.positions == null) {
            return;
        }
        this.runUI((Control)this.skanujTxt);
    }

    public void weryfikujListe(boolean trybAwi) {
        this.trybLP = true;
        this.trybAwi = trybAwi;
        this.reloadRecords();
        if (this.positions == null) {
            return;
        }
        this.runUI((Control)this.skanujTxt);
    }

    protected boolean czyNaPodstawie() {
        return false;
    }

    protected void reloadRecords() {
        Object[] pobranePoz = null;
        pobranePoz = this.trybLP ? this.werClient.otworzList(this.doWeryfikacji.id, true, this.trybAwi) : this.werClient.pobierzPozycje(this.doWeryfikacji.id, this.trybPrzyjecia);
        if (pobranePoz == null) {
            return;
        }
        Object[] uzywanePoz = pobranePoz;
        int iloscPozycjiDoPominiecia = this.getIloscPozycjiDoPominiecia((PozWerM[])pobranePoz);
        if (iloscPozycjiDoPominiecia > 0) {
            uzywanePoz = new PozWerM[pobranePoz.length - iloscPozycjiDoPominiecia];
            int destIndex = 0;
            for (int sourceIndex = 0; sourceIndex < pobranePoz.length; ++sourceIndex) {
                Object tested = pobranePoz[sourceIndex];
                if (this.czyPozycjaPoprawnieWpisana((PozWerM)tested)) continue;
                uzywanePoz[destIndex] = tested;
                ++destIndex;
            }
        }
        if (this.conf.ostrzegajBrakiEan) {
            for (int index = 0; index < uzywanePoz.length; ++index) {
                if (!MainWER.yellow.equals((Object)this.getPozColor((PozWerM)uzywanePoz[index]))) continue;
                SwtCommon.alert(this.getShell(), "UWAGA!\nniekt\u00f3re pozycje nie maj\u0105 przypisanych kod\u00f3w ean,\nzaznaczone na \u017c\u00f3\u0142to");
                break;
            }
        }
        this.positions = new ManagedArray(uzywanePoz);
        this.refreshShownRecords();
    }

    private void refreshShownRecords() {
        super.refreshShownRecords(this.positions);
    }

    private int getIloscPozycjiDoPominiecia(PozWerM[] pobranePoz) {
        if (pobranePoz == null) {
            return 0;
        }
        if (!this.dParams.ukryjPozycjeOk) {
            return 0;
        }
        int ilosc = 0;
        for (int index = 0; index < pobranePoz.length; ++index) {
            if (!this.czyPozycjaPoprawnieWpisana(pobranePoz[index])) continue;
            ++ilosc;
        }
        return ilosc;
    }

    protected boolean czyPozycjaPoprawnieWpisana(PozWerM poz) {
        return poz != null && poz.ilosc == poz.ilosc_wpisana;
    }

    public String getMultiRowFormat() {
        return this.conf.formatPozycji;
    }

    protected ColumnDef[] getColumnsDef() {
        if (this.columnDef != null) {
            return this.columnDef;
        }
        ArrayList<ColumnDef> cols = new ArrayList<ColumnDef>();
        cols.add(new ColumnDef(MultiRowCode.NAZWA, "Nazwa", 120, Common.magClientConf.pozNazwaDl ? NAZWA_DL_GETTER : NAZWA_SKR_GETTER));
        cols.add(new ColumnDef(MultiRowCode.INDEKS, "Ind", 20, new StringDataGetter(){

            public String getData(Object record) {
                PozWerM poz = (PozWerM)record;
                return UtilsM.ifNull(poz.indeks);
            }
        }));
        cols.add(new ColumnDef(MultiRowCode.ILOSC, "Ile", 20, new StringDataGetter(){

            public String getData(Object record) {
                return UtilsM.formatDoubleIlosc(((PozWerM)record).ilosc);
            }
        }));
        cols.add(new ColumnDef(MultiRowCode.ILOSC_ZAM, this.trybPrzyjecia ? "Prz." : "Wyd.", 20, new StringDataGetter(){

            public String getData(Object record) {
                return UtilsM.formatDoubleIlosc(((PozWerM)record).ilosc_wpisana);
            }
        }));
        if (this.conf.nazwaCechy != null) {
            cols.add(new ColumnDef(MultiRowCode.CECHA, this.conf.nazwaCechy, 20, new StringDataGetter(){

                public String getData(Object record) {
                    return ((PozWerM)record).cecha;
                }
            }));
        }
        if (this.conf.nazwaCechySort != null) {
            cols.add(new ColumnDef(MultiRowCode.CECHA_SORT, this.conf.nazwaCechySort, 20, new StringDataGetter(){

                public String getData(Object record) {
                    return ((PozWerM)record).cechaSort;
                }
            }));
        }
        if (this.conf.nazwaCechy2nr != null && this.conf.cecha2lista) {
            cols.add(new ColumnDef(MultiRowCode.CECHA_SORT, this.conf.nazwaCechySort, 20, new StringDataGetter(){

                public String getData(Object record) {
                    return ((PozWerM)record).cecha2nr;
                }
            }));
        }
        if (this.hasMultiRowVersion()) {
            cols.add(new ColumnDef(MultiRowCode.JM, "Jm", 5, new StringDataGetter(){

                public String getData(Object record) {
                    PozWerM poz = (PozWerM)record;
                    if (poz.sz == null) {
                        return "";
                    }
                    return poz.sz.jm;
                }
            }));
        }
        this.columnDef = new ColumnDef[cols.size()];
        cols.toArray(this.columnDef);
        BaseUtils.updatePackableFlag(this.columnDef, false);
        return this.columnDef;
    }

    private Color getPozColor(PozWerM pozWer) {
        if (pozWer.ilosc < pozWer.ilosc_wpisana) {
            return MainWER.red;
        }
        if (pozWer.ilosc > pozWer.ilosc_wpisana) {
            if (pozWer.sz.eany.length == 0) {
                return MainWER.yellow;
            }
            return MainWER.black;
        }
        return MainWER.blue;
    }

    protected RowConfigurator getRowConfigurator() {
        return this.configurator;
    }

    protected void zatwierdzBtnWS() {
        int res;
        if (!this.czyWszystkoWydanoOk() && (res = SwtCommon.confirm(null, "NIE wszystkie pozycje zosta\u0142y zweryfikowane poprawnie.\nCzy zako\u0144czy\u0107 weryfikacj\u0119 dokumentu ?", "Komunikat")) != 64) {
            return;
        }
        if (!this.trybLP && !this.sprawdzCechyNaglowka()) {
            return;
        }
        if (this.trybLP) {
            String res2 = this.werClient.zakonczDokumentLP(this.doWeryfikacji.id, true, this.trybAwi);
            if (this.trybAwi && res2 != null && res2.length() > 0) {
                SwtCommon.alert(this.getShell(), res2);
            }
            this.zakonczUI = true;
        } else {
            this.zakonczUI = this.zakonczDokWer();
        }
    }

    private boolean czyWszystkoWydanoOk() {
        int posCount = this.positions.getRecordCount();
        for (int i = 0; i < posCount; ++i) {
            PozWerM current = (PozWerM)this.positions.getItem(i);
            if (this.czyPozycjaPoprawnieWpisana(current)) continue;
            return false;
        }
        return true;
    }

    boolean zakonczDokWer() {
        return this.zakonczDokWer(false);
    }

    boolean zakonczDokWer(boolean force) {
        StatMsgVal res = this.werClient.zakonczDokument(this.doWeryfikacji.id, true, force);
        if (res == null) {
            return false;
        }
        if (res.status == 0 || res.status == 1) {
            if (res.msg != null && res.msg.length() > 0) {
                SwtCommon.info(this.getShell(), res.msg);
            }
            return true;
        }
        if (res.status == 10) {
            if (res.msg != null && res.msg.length() > 0) {
                SwtCommon.alert(this.getShell(), "blad postweryfikacji: " + res.msg);
            }
            return false;
        }
        if (res.status == 11) {
            int forceI = SwtCommon.confirm(this.getShell(), res.msg);
            if (forceI != 64) {
                return false;
            }
            return this.zakonczDokWer(true);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sprawdzCechyNaglowka() {
        if (this.conf.cechyNaglowka != null && this.conf.cechyNaglowka.length > 0) {
            EdycjaCechCD dlg = new EdycjaCechCD(this.containerCo);
            try {
                String[] resWartosci = dlg.open(this.conf.cechyNaglowka, this.cechyNagl);
                if (this.isDisposed()) {
                    boolean bl = true;
                    return bl;
                }
                if (resWartosci == null) {
                    boolean bl = false;
                    return bl;
                }
                this.cechyNagl = resWartosci;
                this.werClient.zapiszCechyNagl(this.doWeryfikacji.id, this.cechyNagl);
            }
            finally {
                SwtCommon.safeDispose(dlg);
            }
        }
        return true;
    }

    protected void zapiszUwagiCechy(DialogParams params) {
    }

    protected void szukaj(String fraza) {
        this.szukajIweryfikuj(fraza, false);
    }

    protected void listaTableWDS() {
        if (this.conf.pozwolEdytowacPozycje) {
            this.wpisBtnWS();
        }
    }

    protected void usunBtnWS() {
    }

    protected void dodajInneZamowienie() {
    }

    protected void wpisBtnWS() {
        String ean = this.skanujTxt.getText();
        this.skanujTxt.setText("");
        if (UtilsM.napisPustyLubTylkoSpacje(ean)) {
            if (!this.conf.pozwolEdytowacPozycje) {
                return;
            }
            PozWerM selectedPos = (PozWerM)this.listaTable.getSelectedRecord();
            if (selectedPos == null) {
                return;
            }
            this.pokazDialogWeryfikacji(new WyszukPozWer(selectedPos, 0.0, null), true, null);
            if (this.isDisposed()) {
                return;
            }
            this.sprawdzKomplet();
            this.skanujTxt.setFocus();
            this.getShell().setDefaultButton(this.wpisBtn);
            return;
        }
        this.szukajIweryfikuj(ean, true);
        if (this.isDisposed()) {
            return;
        }
        this.skanujTxt.setFocus();
        this.getShell().setDefaultButton(this.wpisBtn);
    }

    private void szukajIweryfikuj(String ean, boolean jakoEan) {
        if (jakoEan && this.conf.werDostawaJedna) {
            this.werDostawa(ean);
            return;
        }
        WyszukPozWer wp = null;
        if (this.conf.szukajEanWgPozycji) {
            ArrayList wysz = jakoEan ? this.szukajEanWsrodPozycji(ean) : this.szukajIndeksNazwaWsrodPozycji(ean);
            if (wysz.size() == 0) {
                SwtCommon.alert(this.getShell(), "ustawiono szukanie wsr\u00f3d pozycji dokumentu, brak kodu " + ean);
                return;
            }
            if (wysz.size() == 1) {
                wp = (WyszukPozWer)wysz.get(0);
            } else {
                WyborPozycjiWerC dlg = new WyborPozycjiWerC(this.containerCo);
                wp = dlg.wybierz2(wysz);
                if (this.isDisposed()) {
                    return;
                }
            }
        } else {
            TowarSzukanie ll = jakoEan ? this.znajdzTowarEan(ean) : this.znajdzTowarIndeksNazwa(ean);
            if (ll == null) {
                return;
            }
            if (ll.stan == "DE") {
                this.reloadRecords();
            }
            wp = ll.hasFlag(1) ? this.szukajPozycjiNaDok(ean, false, ll) : this.szukajPozycjiNaDok(ean, jakoEan, ll);
        }
        if (wp != null) {
            this.pokazDialogWeryfikacji(wp, false, null);
        }
        if (this.isDisposed()) {
            return;
        }
        this.sprawdzKomplet();
    }

    private void werDostawa(String kod128) {
        KodEan128Result res2 = this.parserE.parsuj(kod128);
        if (res2 == null) {
            SwtCommon.alert(this.getShell(), "zeskanuj etykiete z numerem partii");
            return;
        }
        ArrayList rr = this.szukajPartiiWsrodPozycji(res2);
        if (rr.size() == 0) {
            SwtCommon.alert(this.getShell(), "brak partii '" + res2.partia + "' na pozycjach dokumentu");
            return;
        }
        if (rr.size() > 1) {
            SwtCommon.alert(this.getShell(), "TODO obsluga wielu partii o jednym numerze");
            return;
        }
        WyszukPozWer wp = (WyszukPozWer)rr.get(0);
        this.pokazDialogWeryfikacji(wp, false, res2.partia);
    }

    private ArrayList szukajPartiiWsrodPozycji(final KodEan128Result ean128) {
        final boolean containsEan = ean128.containsEan();
        final boolean containsNrPartii = ean128.containsNrPartii();
        final ArrayList wyszukane = new ArrayList();
        Visitor v = new Visitor(){

            public boolean visit(Object item) {
                PozWerM p = (PozWerM)item;
                if (containsEan && !p.containsEan(ean128.eanTowaru)) {
                    return true;
                }
                if (containsNrPartii) {
                    if (p.nrPartii == null) {
                        return true;
                    }
                    if (!p.nrPartii.equalsIgnoreCase(ean128.partia)) {
                        return true;
                    }
                }
                wyszukane.add(new WyszukPozWer(p, 0.0, null));
                return true;
            }
        };
        this.positions.visitAll(v);
        return wyszukane;
    }

    private void sprawdzKomplet() {
        int res;
        if (this.czyWszystkoWydanoOk() && (res = SwtCommon.confirm(this.getShell(), "Wszystkie pozycje zosta\u0142y zweryfikowane poprawnie.\nCzy zako\u0144czy\u0107 weryfikacj\u0119 dokumentu ?", "Komunikat")) == 64) {
            if (!this.trybLP && !this.sprawdzCechyNaglowka()) {
                return;
            }
            if (this.trybLP) {
                String res2 = this.werClient.zakonczDokumentLP(this.doWeryfikacji.id, true, this.trybAwi);
                if (this.trybAwi && res2 != null && res2.length() > 0) {
                    SwtCommon.alert(this.getShell(), res2);
                }
                this.zakonczUI = true;
            } else {
                this.zakonczUI = this.zakonczDokWer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pokazDialogWeryfikacji(WyszukPozWer wp, boolean jakoEdycja, String nrPartii) {
        double iloscD;
        int ret;
        if (wp.poz.ilosc <= wp.poz.ilosc_wpisana && (ret = SwtCommon.confirm(this.getShell(), "wydano ju\u017c wszystko z tej pozycji,\nczy chcesz wyda\u0107 wi\u0119cej?")) != 64) {
            return;
        }
        boolean trybEAN = false;
        WeryfikujC.ResultWeryfikacji result = null;
        if (this.conf.trybSzybki && !jakoEdycja) {
            boolean blokadaWydanPowyzej;
            double qtyDiff = 1.0;
            if (wp.o != null) {
                qtyDiff = wp.o.ileWopak;
            } else if (wp.iloscWazona > 0.0 && !UtilsM.eq2Digits(wp.iloscWazona, 0.0)) {
                qtyDiff = wp.iloscWazona;
            }
            iloscD = wp.poz.ilosc_wpisana + qtyDiff;
            if (!this.trybPrzyjecia && wp.poz != null && wp.poz.ilosc < iloscD && (blokadaWydanPowyzej = Common.getWerCC().blokadaIlosciPowyzej)) {
                SwtCommon.alert(this.getShell(), "Za du\u017ca ilo\u015b\u0107 !");
                return;
            }
        } else {
            int res;
            WeryfikujC w = new WeryfikujC(this.containerCo);
            result = w.weryfikujPozycje(wp.poz, wp.iloscWazona, jakoEdycja, wp.o, !this.trybPrzyjecia, this.conf, nrPartii);
            if (this.isDisposed()) {
                return;
            }
            if (result.iloscStr == null) {
                return;
            }
            iloscD = new Double(result.iloscStr);
            if (this.conf.zatwierdzKolejnyEanJako1) {
                if (this.conf.szukajEanWgPozycji) {
                    ArrayList pozycje = this.szukajEanWsrodPozycji(result.iloscStr);
                    if (pozycje.size() > 0) {
                        trybEAN = true;
                        iloscD = 1.0;
                    }
                } else {
                    TowarSzukanie[] tt = this.sprClient.szukajTowaruEan(result.iloscStr);
                    if (tt.length > 0) {
                        trybEAN = true;
                        iloscD = 1.0;
                    }
                }
            }
            if (!trybEAN && iloscD > (double)this.conf.maxIloscOstrzegaj && (res = SwtCommon.confirm(this.getShell(), "wprowadzono du\u017c\u0105 ilo\u015b\u0107 (" + result.iloscStr + "), czy chcesz POMIN\u0104\u0106?")) != 128) {
                this.pokazDialogWeryfikacji(wp, jakoEdycja, nrPartii);
                return;
            }
            if (result.o != null) {
                iloscD *= result.o.ileWopak;
            }
            if (!jakoEdycja) {
                iloscD += wp.poz.ilosc_wpisana;
            }
            if (!this.trybLP && this.conf.cechyPozycji != null && this.conf.cechyPozycji.length > 0) {
                EdycjaCechCD dlg = new EdycjaCechCD(this.containerCo);
                try {
                    String[] resWartosci = dlg.open(this.conf.cechyPozycji, wp.poz.cechyPoz);
                    if (this.isDisposed()) {
                        return;
                    }
                    if (resWartosci != null) {
                        wp.poz.cechyPoz = resWartosci;
                    }
                }
                finally {
                    SwtCommon.safeDispose(dlg);
                }
            }
        }
        if (this.trybLP) {
            this.werClient.zapiszPozycjeLP(wp.poz.id_poz, iloscD);
        } else {
            this.werClient.zapiszPozycje(wp.poz.id_poz, wp.poz.cechyPoz, iloscD);
        }
        wp.poz.ilosc_wpisana = iloscD;
        this.updatePositionWithinList(wp.poz);
        if (trybEAN) {
            this.skanujTxt.setText(result.iloscStr);
            this.skanujTxt.forceFocus();
            Event event = new Event();
            event.display = Display.getDefault();
            event.type = 1;
            event.keyCode = 13;
            event.item = event.widget = this.skanujTxt;
            event.count = 1;
            Display.getDefault().post(event);
            event.type = 2;
            Display.getDefault().post(event);
        }
    }

    protected PozWerM getPositionByIdPoz(int id_poz) {
        int posCount = this.positions.getRecordCount();
        for (int index = 0; index < posCount; ++index) {
            PozWerM tested = (PozWerM)this.positions.getItem(index);
            if (tested.id_poz != id_poz) continue;
            return tested;
        }
        return null;
    }

    private void updatePositionWithinList(PozWerM newPos) {
        if (newPos == null) {
            return;
        }
        PozWerM foundPosition = this.getPositionByIdPoz(newPos.id_poz);
        if (foundPosition != null) {
            if (this.czyPozycjaPoprawnieWpisana(foundPosition) && this.dParams.ukryjPozycjeOk) {
                this.positions.removeItem(foundPosition);
            } else {
                foundPosition.ilosc_wpisana = newPos.ilosc_wpisana;
            }
            this.refreshShownRecords();
        }
    }

    private WyszukPozWer szukajPozycjiNaDok(String ean, boolean jakoEan, TowarSzukanie ll) {
        WyszukPozWer wp;
        ArrayList pozycje = this.szukajPozycji(ll, jakoEan, ean);
        if (pozycje.size() == 0) {
            SwtCommon.alert(this.getShell(), "nie znaleziono " + ll.nazwa + "(" + ean + ") wsrod pozycji dokumentu");
            return null;
        }
        if (pozycje.size() == 1) {
            wp = (WyszukPozWer)pozycje.get(0);
        } else {
            WyborPozycjiWerC dlg = new WyborPozycjiWerC(this.containerCo);
            wp = dlg.wybierz2(pozycje);
            if (this.isDisposed()) {
                return null;
            }
        }
        return wp;
    }

    private ArrayList szukajPozycji(final TowarSzukanie towarSzukanie, final boolean jakoEan, final String ean) {
        final ArrayList wyszukane = new ArrayList();
        Visitor v = new Visitor(){

            public boolean visit(Object item) {
                PozWerM poz = (PozWerM)item;
                if (poz.id_kartoteka == towarSzukanie.id) {
                    if (jakoEan) {
                        PozycjeWerCNewer.this.szukajEanNaPozycji(ean, wyszukane, poz);
                    } else {
                        double iloscWazono = 0.0;
                        boolean saWazone = towarSzukanie.hasFlag(1);
                        if (saWazone && towarSzukanie.ilosc != null) {
                            iloscWazono = towarSzukanie.ilosc;
                        }
                        wyszukane.add(new WyszukPozWer(poz, saWazone ? iloscWazono : 0.0, null));
                    }
                }
                return true;
            }
        };
        this.positions.visitAll(v);
        return wyszukane;
    }

    private void szukajEanNaPozycji(String ean, ArrayList wyszukane, PozWerM poz) {
        if (UtilsM.objInArr(ean, poz.sz.eany)) {
            wyszukane.add(new WyszukPozWer(poz, 0.0, null));
        }
        if (poz.sz.opakowania != null) {
            for (int j = 0; j < poz.sz.opakowania.length; ++j) {
                if (!UtilsM.objInArr(ean, poz.sz.opakowania[j].eany)) continue;
                wyszukane.add(new WyszukPozWer(poz, 0.0, poz.sz.opakowania[j]));
            }
        }
    }

    private ArrayList szukajEanWsrodPozycji(final String ean) {
        final ArrayList wyszukane = new ArrayList();
        Visitor v = new Visitor(){

            public boolean visit(Object item) {
                PozycjeWerCNewer.this.szukajEanNaPozycji(ean, wyszukane, (PozWerM)item);
                return true;
            }
        };
        this.positions.visitAll(v);
        return wyszukane;
    }

    private ArrayList szukajIndeksNazwaWsrodPozycji(final String co) {
        final ArrayList wyszukane = new ArrayList();
        Visitor v = new Visitor(){

            public boolean visit(Object item) {
                PozWerM p = (PozWerM)item;
                if (co.equalsIgnoreCase(p.sz.indeks) || co.equalsIgnoreCase(p.sz.nazwaSkr) || p.sz.nazwaSkr.toUpperCase().indexOf(co.toUpperCase()) > -1 || co.equalsIgnoreCase(p.sz.nazwaDl) || p.sz.nazwaDl.toUpperCase().indexOf(co.toUpperCase()) > -1) {
                    wyszukane.add(new WyszukPozWer(p, 0.0, null));
                }
                return true;
            }
        };
        this.positions.visitAll(v);
        return wyszukane;
    }

    protected void przerwijBtnWS() {
        if (this.trybLP) {
            String res = this.werClient.zakonczDokumentLP(this.doWeryfikacji.id, false, this.trybAwi);
            if (this.trybAwi && res != null && res.length() > 0) {
                SwtCommon.alert(this.getShell(), res);
            }
        } else {
            this.werClient.zakonczDokument(this.doWeryfikacji.id, false, false);
        }
        this.zakonczUI();
    }
}

