/*
 * Decompiled with CFR 0.152.
 */
package ekspert.mobile.wpr;

import base.composites.BaseTableComposite;
import base.composites.BaseTableUtils;
import base.controls.ControlFactory;
import base.controls.ExtendedLabel;
import base.data.ColumnDef;
import base.data.RowConfiguration;
import base.data.RowConfigurator;
import base.data.StringDataGetter;
import ekspert.mobile.Common;
import ekspert.mobile.ContC;
import ekspert.mobile.MobileUtils;
import ekspert.mobile.MultiRowCode;
import ekspert.mobile.UtilsM;
import ekspert.mobile.common.DialogParams;
import ekspert.mobile.common.EditMode;
import ekspert.mobile.common.KodEan128Parser;
import ekspert.mobile.common.KodEan128Result;
import ekspert.mobile.common.PozycjeCNewer;
import ekspert.mobile.common.obj.Dostawa;
import ekspert.mobile.common.obj.NaglM;
import ekspert.mobile.common.obj.OpakKartM;
import ekspert.mobile.common.obj.StanKartMskl;
import ekspert.mobile.common.obj.Towar;
import ekspert.mobile.common.obj.TowarSzukanie;
import ekspert.mobile.common.obj.ZlecM;
import ekspert.mobile.common.paleta.Paleta;
import ekspert.mobile.common.przeglady.ButtonWithOuzPozM;
import ekspert.mobile.common.przeglady.PrzegladyUtils;
import ekspert.mobile.common.spr.SprIF;
import ekspert.mobile.common.wer.StatMsgVal;
import ekspert.mobile.common.wpr.OUZnaglM;
import ekspert.mobile.common.wpr.OUZpozM;
import ekspert.mobile.common.wpr.Rezerwacja;
import ekspert.mobile.common.wpr.WprClientConfig;
import ekspert.mobile.common.wpr.WprIF;
import ekspert.mobile.datamodel.ManagedArray;
import ekspert.mobile.gui.ActionDesc;
import ekspert.mobile.gui.ActionMatrix;
import ekspert.mobile.gui.ProgressC;
import ekspert.mobile.gui.SwtCommon;
import ekspert.mobile.paleta.PaletaUtils;
import ekspert.mobile.util.Matcher;
import ekspert.mobile.util.SimpleCallback;
import ekspert.mobile.util.Visitor;
import ekspert.mobile.wpr.PozUwagiCechyC;
import ekspert.mobile.wpr.WpiszIloscC;
import ekspert.mobile.wpr.WprUtils;
import ekspert.mobile.wpr.WymagalnoscCech;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public abstract class PozycjeOuzCNewer
extends PozycjeCNewer {
    private ManagedArray initPositions;
    private ManagedArray positions;
    boolean jakoPrzyjecie;
    private boolean jakoZamowienie;
    private OUZnaglM nagl;
    WprIF WPR;
    private KodEan128Parser parserE;
    public WprClientConfig conf;
    protected Color czerwony;
    protected Color niebieski;
    protected Color zolty;
    private Paleta aktualnaPaleta;
    private Label razemSzt;
    private Label dokOnInfo;
    private ColumnDef[] columns = null;
    private static final String HKL_C3_TAK = "tak";
    private RowConfigurator rowConfigurator = new RowConfigurator(){
        private SelectionListener selAd2 = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ButtonWithOuzPozM b = (ButtonWithOuzPozM)((Object)arg0.getSource());
                OUZpozM p = b.getOuzPozM();
                p.cecha3 = b.getSelection() ? PozycjeOuzCNewer.HKL_C3_TAK : "nie";
                String res = (this).PozycjeOuzCNewer.this.WPR.aktualizujPozycjeOUZ_vPominDrukowanie(p, ((PozycjeOuzCNewer)(this).PozycjeOuzCNewer.this).nagl.id);
                UtilsM.log("ptaszek " + p.cecha3 + " res " + res);
            }
        };
        RowConfiguration configuration = new RowConfiguration(){

            public Color getForeground(Object record) {
                OUZpozM p = (OUZpozM)record;
                return PozycjeOuzCNewer.this.getPozColor(p);
            }

            public void customizeTableItem(BaseTableComposite table, TableItem tableItem, Object record) {
                if (!(this).PozycjeOuzCNewer.this.conf.hklMode) {
                    return;
                }
                if (!PozycjeOuzCNewer.this.czyNaPodstawie()) {
                    return;
                }
                OUZpozM p = (OUZpozM)record;
                ButtonWithOuzPozM checkButton = new ButtonWithOuzPozM((Composite)PozycjeOuzCNewer.this.listaTable, 32);
                checkButton.setOuzPozM(p);
                checkButton.pack();
                checkButton.addSelectionListener(selAd2);
                int hklColIndex = table.getColumnCount() - 1;
                TableEditor editor = new TableEditor((Table)PozycjeOuzCNewer.this.listaTable);
                editor.minimumWidth = checkButton.getSize().x + 20;
                editor.horizontalAlignment = 0x1000000;
                editor.setEditor((Control)checkButton, tableItem, hklColIndex);
                PozycjeOuzCNewer.this.tableExtraEditors.add(editor);
                PozycjeOuzCNewer.this.tableExtraControls.add(checkButton);
                if (p.cecha3 != null && p.cecha3.equals(PozycjeOuzCNewer.HKL_C3_TAK)) {
                    checkButton.setSelection(true);
                } else {
                    checkButton.setSelection(false);
                }
            }
        };

        public RowConfiguration getConfiguration(Object record) {
            return this.configuration;
        }
    };
    private ActionMatrix moreDialogOptions;

    public PozycjeOuzCNewer(ContC parent) {
        super(parent);
        this.parserE = new KodEan128Parser(Common.magClientConf.kodyEtykiet);
        this.aktualnaPaleta = null;
        this.czerwony = this.getDisplay().getSystemColor(3);
        this.niebieski = this.getDisplay().getSystemColor(9);
        this.szary = this.getDisplay().getSystemColor(15);
        this.zolty = this.getDisplay().getSystemColor(8);
        this.initGui2();
    }

    protected void reloadRecords() {
        Object[] readPositions = this.WPR.pobierzPozycjeOUZ(this.nagl.id);
        if (readPositions != null) {
            Matcher m;
            this.positions = new ManagedArray(readPositions);
            this.initPositions = new ManagedArray(readPositions);
            if (this.conf.ostrzegajBrakiEan && this.positions.findFirstMatched(m = new Matcher(){

                public boolean matches(Object item) {
                    return PozycjeOuzCNewer.this.zolty.equals((Object)PozycjeOuzCNewer.this.getPozColor((OUZpozM)item));
                }
            }) != null) {
                SwtCommon.alert(this.getShell(), "UWAGA!\nniekt\u00f3re pozycje nie maj\u0105 przypisanych kod\u00f3w ean,\nzaznaczone na \u017c\u00f3\u0142to");
            }
            this.refreshShownRecords();
        }
    }

    private void refreshShownRecords() {
        ManagedArray filteredArray = this.getFilteredArray(this.positions);
        super.refreshShownRecords(filteredArray);
    }

    private ManagedArray getFilteredArray(ManagedArray srcArray) {
        if (!this.dParams.ukryjPozycjeOk && !this.conf.ukryj_zerowe_stany_magazynowe) {
            return srcArray;
        }
        FilteredPosCounter posCounter = new FilteredPosCounter();
        srcArray.visitAll(posCounter);
        if (posCounter.count == 0) {
            return srcArray;
        }
        Object[] destArray = new OUZpozM[srcArray.getRecordCount() - posCounter.count];
        FilteredPosCopier copier = new FilteredPosCopier();
        copier.destArray = destArray;
        srcArray.visitAll(copier);
        return new ManagedArray(destArray);
    }

    private boolean czyPozycjaDoOdfiltrowania(OUZpozM p) {
        double stanMag = p.sz.stanTotal;
        boolean usun = false;
        if (this.conf.ukryj_zerowe_stany_magazynowe && stanMag <= 0.0 && !this.jakoPrzyjecie && this.czyNaPodstawie() || this.dParams.ukryjPozycjeOk && this.czyPozycjaPoprawnieWydana(p)) {
            usun = true;
        }
        return usun;
    }

    protected boolean czyPaletowanie() {
        if (!this.jakoPrzyjecie && this.czyNaPodstawie()) {
            return Common.getWprCC().paletowanie;
        }
        return false;
    }

    public String getMultiRowFormat() {
        if (this.czyNaPodstawie()) {
            return this.conf.formatNP;
        }
        return this.conf.format;
    }

    protected ColumnDef[] getColumnsDef() {
        if (this.columns != null) {
            return this.columns;
        }
        ArrayList<ColumnDef> colList = new ArrayList<ColumnDef>();
        colList.add(new ColumnDef(MultiRowCode.LP, "Lp", 5, new StringDataGetter(){

            public String getData(Object record) {
                return Integer.toString(((OUZpozM)record).lp);
            }
        }));
        colList.add(new ColumnDef(MultiRowCode.INDEKS, "Indeks", 15, new StringDataGetter(){

            public String getData(Object record) {
                return ((OUZpozM)record).kodtow;
            }
        }));
        boolean showCechaLokacja = false;
        if (this.czyNaPodstawie()) {
            boolean bl = showCechaLokacja = !UtilsM.napisPustyLubTylkoSpacje(this.conf.cechaLokacja);
        }
        if (showCechaLokacja) {
            colList.add(new ColumnDef(MultiRowCode.CECHA, this.conf.cechaLokacja, 20, new StringDataGetter(){

                public String getData(Object record) {
                    return ((OUZpozM)record).lokacja;
                }
            }));
        }
        colList.add(new ColumnDef(MultiRowCode.ILOSC, "Ilo\u015b\u0107", 15, new StringDataGetter(){

            public String getData(Object record) {
                return UtilsM.formatDoubleIlosc(((OUZpozM)record).ilosc);
            }
        }));
        if (this.czyNaPodstawie()) {
            colList.add(new ColumnDef(MultiRowCode.ILOSC_ZAM, "IlZam", 20, new StringDataGetter(){

                public String getData(Object record) {
                    return UtilsM.formatDoubleIlosc(((OUZpozM)record).iloscZam);
                }
            }));
        }
        colList.add(new ColumnDef(MultiRowCode.NAZWA, "Nazwa", 20, Common.magClientConf.pozNazwaDl ? new nazwaDlGetter() : new nazwaSkrGetter()));
        if (this.jakoPrzyjecie) {
            colList.add(new ColumnDef(MultiRowCode.TERMIN, "Termin", 20, new StringDataGetter(){

                public String getData(Object record) {
                    return ((OUZpozM)record).dtWazn;
                }
            }));
        }
        if (!UtilsM.napisPustyLubTylkoSpacje(this.conf.pole2nazwa)) {
            colList.add(new ColumnDef(MultiRowCode.POLE_2, this.conf.pole2nazwa, 20, new StringDataGetter(){

                public String getData(Object record) {
                    return ((OUZpozM)record).pole2;
                }
            }));
        }
        if (this.czyNaPodstawie() && this.conf.hklMode) {
            colList.add(new ColumnDef("", 30, new StringDataGetter(){

                public String getData(Object record) {
                    return "";
                }
            }));
        }
        if (this.hasMultiRowVersion()) {
            colList.add(new ColumnDef(MultiRowCode.JM, "Jm", 5, new StringDataGetter(){

                public String getData(Object record) {
                    OUZpozM poz = (OUZpozM)record;
                    if (poz.sz == null) {
                        return "";
                    }
                    return poz.sz.jm;
                }
            }));
        }
        this.columns = BaseTableUtils.castColumns(colList);
        return this.columns;
    }

    private Color getPozColor(OUZpozM p) {
        if (this.czyPozycjaPoprawnieWydana(p) && p.ilosc > 0.0) {
            return this.szary;
        }
        if (p.iloscZam == 0.0) {
            return this.niebieski;
        }
        if (p.ilosc != 0.0) {
            return this.czerwony;
        }
        if (p.sz.eany.length == 0) {
            return this.zolty;
        }
        return null;
    }

    protected RowConfigurator getRowConfigurator() {
        if (!this.czyNaPodstawie()) {
            return null;
        }
        return this.rowConfigurator;
    }

    protected void initGui2() {
        ExtendedLabel l3a = ControlFactory.createLabel(this.cNaPodst, 0);
        l3a.setText("Na podst:");
        RowData label3LData = new RowData();
        label3LData.width = 49;
        label3LData.height = 14;
        l3a.setLayoutData(label3LData);
        this.dokOnInfo = ControlFactory.createLabel(this.cNaPodst, 0);
        this.dokOnInfo.setLayoutData((Object)new RowData(130, -1));
        this.dokOnInfo.setText("  ");
        ExtendedLabel l4 = ControlFactory.createLabel(this.cNaPodst, 0);
        l4.setLayoutData(new RowData(34, -1));
        l4.setText("R:");
        this.razemSzt = ControlFactory.createLabel(this.cNaPodst, 0);
        this.razemSzt.setLayoutData((Object)new RowData(20, 14));
        this.razemSzt.setText("   ");
        this.cNaPodst.layout();
        this.layout();
    }

    protected void listaTableWDS() {
        OUZpozM p = (OUZpozM)this.listaTable.getSelectedRecord();
        if (p == null) {
            return;
        }
        this.edytujPozycje(p);
        if (this.isDisposed()) {
            return;
        }
        this.skanujTxt.setFocus();
    }

    protected void wpisBtnWS() {
        String wpisano = this.skanujTxt.getText();
        this.skanujTxt.setText("");
        if (wpisano.length() == 0) {
            this.listaTable.setFocus();
            return;
        }
        KodEan128Result res2 = this.parserE.parsuj(wpisano);
        if (res2 != null) {
            this.obslugaEtykiety(res2);
        } else {
            TowarSzukanie ktory = this.znajdzTowarEan(wpisano);
            if (ktory != null) {
                if (this.conf.wyszukInneZamDost && this.czyNaPodstawie() && !this.jakoPrzyjecie) {
                    String info = this.WPR.getPozZamDostInfo(ktory.id, this.nagl.id);
                    if (info == null) {
                        return;
                    }
                    UtilsM.log(info);
                    if (info.startsWith("INNE")) {
                        int ret = SwtCommon.confirm(this.getShell(), "kartoteka " + ktory.nazwa + " znajduje sie na innych zamowieniach kontrahenta:\n" + info + "\n czy chcesz doda\u0107?");
                        if (ret != 64) {
                            return;
                        }
                        String[] parts = MobileUtils.splitPreserveAllTokens(info, ' ');
                        String nrZam = parts[1];
                        this.dParams.akcja = 6;
                        this.dParams.noweZamowienie = this.WPR.pobierzZamNr(nrZam, "ZAMDOST");
                        this.zakonczUI = true;
                        return;
                    }
                }
                Towar sz = this.sprClient.szczegolyTowaru(ktory.id);
                this.obslugaWpisania(wpisano, ktory.ilosc, sz);
            }
        }
        if (this.isDisposed()) {
            return;
        }
        this.skanujTxt.setFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void edytujPozycje(OUZpozM p) {
        StanKartMskl[] stany = this.sprClient.getStanyMskl(p.sz.id);
        if (p.iloscZam > 0.0 && this.czyNaPodstawie()) {
            this.obslugaWpisaniaNaPodstawie(p, null, stany, new Double(p.ilosc), EditMode.EDIT);
            return;
        }
        if (!this.jakoZamowienie && !this.jakoPrzyjecie && this.conf.rozchodWgDostaw) {
            Dostawa d = this.wybierzDostawe2(p.sz, p.ilosc, p);
            if (d == null) {
                return;
            }
            WpiszIloscC iloscComposite = new WpiszIloscC(this.containerCo, EditMode.EDIT, this.conf, this.nagl, p);
            try {
                iloscComposite.wpisz(p.sz, null, this.jakoPrzyjecie, stany, new Double(0.0), this.jakoZamowienie);
                if (!iloscComposite.dialogConfirmed()) {
                    return;
                }
                p.ustawMiejsceSkladowania(iloscComposite.getResultMiejsceSkladowania());
                p.idDost = d.id;
                p.ilosc = iloscComposite.getResultIlosc();
            }
            finally {
                SwtCommon.safeDispose(iloscComposite);
            }
        }
        WpiszIloscC iloscComposite = new WpiszIloscC(this.containerCo, EditMode.EDIT, this.conf, this.nagl, p);
        try {
            String errorMessage;
            iloscComposite.wpisz(p.sz, null, this.jakoPrzyjecie, stany, new Double(p.ilosc), this.jakoZamowienie);
            if (!iloscComposite.dialogConfirmed()) {
                return;
            }
            p.ustawMiejsceSkladowania(iloscComposite.getResultMiejsceSkladowania());
            double nowaIlosc = iloscComposite.getResultIlosc();
            p.sz = this.sprClient.szczegolyTowaruMag(p.sz.id, p.idMagZam);
            if (!this.jakoPrzyjecie && !UtilsM.napisPustyLubTylkoSpacje(errorMessage = WprUtils.getStateControlErrorMessage(p.sz, this.czyNaPodstawie(), nowaIlosc))) {
                SwtCommon.alert(this.getShell(), errorMessage);
                return;
            }
            p.ilosc = nowaIlosc;
        }
        finally {
            iloscComposite.dispose();
        }
        String res = this.WPR.aktualizujPozycjeOUZ(p, this.nagl.id);
        if (res == null || !res.startsWith("OK")) {
            if (res != null) {
                SwtCommon.alert(this.getShell(), res);
            }
            return;
        }
        this.refreshOrReloadRecords();
    }

    private void refreshOrReloadRecords() {
        if (this.conf.refresh) {
            this.reloadRecords();
        } else {
            this.refreshShownRecords();
            if (!this.hasMultiRowVersion()) {
                SwtCommon.ustawAutoSzerokoscKolumn(this.listaTable);
            }
        }
        if (!this.czyNaPodstawie()) {
            this.listaTable.setSelection(this.listaTable.getItemCount() - 1);
        }
    }

    protected void szukaj(String fraza) {
        TowarSzukanie ktory = this.znajdzTowarIndeksNazwa(fraza);
        if (this.isDisposed()) {
            return;
        }
        if (ktory == null) {
            return;
        }
        Towar szczegoly = this.sprClient.szczegolyTowaru(ktory.id);
        this.obslugaWpisania(fraza, new Double(0.0), szczegoly);
        if (this.isDisposed()) {
            return;
        }
        this.moveAbove(null);
        this.skanujTxt.setFocus();
    }

    protected void zatwierdzBtnWS() {
        this.zatwierdzBtnWS(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zatwierdzBtnWS(boolean ask) {
        int ret;
        boolean forceOrderSelection;
        WymagalnoscCech w = new WymagalnoscCech(this.getShell());
        if (!w.sprawdzWymagalnoscCechNagl(this.cechyDok, this.dParams)) {
            PozUwagiCechyC d = new PozUwagiCechyC(this.containerCo);
            try {
                DialogParams dParams1 = d.openDok(this.dParams, this.cechyDok, w);
                if (this.isDisposed()) {
                    return;
                }
                if (dParams1 == null) {
                    return;
                }
                this.dParams = dParams1;
                this.zapiszUwagiCechy(this.dParams);
                this.zatwierdzBtnWS();
            }
            finally {
                SwtCommon.safeDispose(d);
            }
            return;
        }
        boolean bl = forceOrderSelection = this.conf.pwWymusZlec && this.nagl.nazwadok.equals("PW") || this.conf.rwWymusZlec && this.nagl.nazwadok.equals("RW");
        if (forceOrderSelection) {
            ZlecM[] zlecenia = this.WPR.getListaZlec();
            if (zlecenia == null) {
                return;
            }
            ZlecM wybraneZlec = PrzegladyUtils.wybierzZlecenie(this.containerCo, zlecenia);
            if (this.isDisposed()) {
                return;
            }
            if (wybraneZlec == null) {
                return;
            }
            String res = this.WPR.ustawZlecenie(this.nagl.id, wybraneZlec);
            if (res == null || !res.equals("OK")) {
                return;
            }
        }
        if (ask && (ret = SwtCommon.confirm(this.getShell(), "Czy chcesz zatwierdzi\u0107 dokument?")) != 64) {
            return;
        }
        String res = this.zatwierdzRetry();
        if (res == null) {
            return;
        }
        this.zakonczUI = true;
    }

    private String zatwierdzRetry() {
        String res = this.WPR.zatwierdzDokument(this.nagl.id);
        if (res != null && res.startsWith("WAIT ")) {
            SwtCommon.info(this.getShell(), "Trwa przetwarzanie innych dokument\u00f3w, spr\u00f3buj za chwil\u0119\n" + res);
            return null;
        }
        return res;
    }

    protected void usunBtnWS() {
        if (this.czyNaPodstawie()) {
            return;
        }
        OUZpozM p = (OUZpozM)this.listaTable.getSelectedRecord();
        if (p == null) {
            return;
        }
        int ret = SwtCommon.confirm(this.getShell(), "Czy chcesz usun\u0105\u0107 pozycj\u0119 " + p.kodtow + "' ?");
        if (ret != 64) {
            return;
        }
        String res = this.WPR.usunPozycjeOUZ(p.id);
        if (res == null) {
            return;
        }
        SwtCommon.info(this.getShell(), "usunalem pozycje " + res);
        this.positions.removeItem(p);
        this.initPositions.removeItem(p);
        this.refreshOrReloadRecords();
    }

    protected void przerwijBtnWS() {
        this.WPR.przerwijOUZ(this.nagl.id);
        this.zakonczUI = true;
    }

    public NaglM edytujDokument(OUZnaglM nagl, WprClientConfig conf, WprIF wpr, SprIF spr, Integer fSize) {
        this.setupOUZ(nagl, conf, wpr, spr, fSize);
        this.cechyDok = wpr.getCechyPerNagl(nagl.id);
        if (this.czyNaPodstawie()) {
            return this.edytujDokumentNaPodstawie();
        }
        this.reloadRecords();
        if (this.positions == null) {
            return null;
        }
        this.setupOuzBezPodst();
        this.listaTable.setSelection(this.listaTable.getItemCount() - 1);
        this.runUI((Control)this.skanujTxt);
        return null;
    }

    void setupOuzBezPodst() {
        this.dParams.moznaUkrywac = false;
        this.dParams.moznaUsuwac = true;
        this.dParams.moznaCechy = true;
        this.dParams.moznaUwagi = true;
    }

    void setupOUZ(OUZnaglM nagl, WprClientConfig conf, WprIF wpr, SprIF spr, Integer fSize) {
        this.setSprConf(Common.getSprCC());
        this.nagl = nagl;
        this.conf = conf;
        this.WPR = wpr;
        this.sprClient = spr;
        this.jakoPrzyjecie = UtilsM.objInArr(nagl.nazwadok, OUZnaglM.SKROTY_PRZYJECIA);
        this.jakoZamowienie = UtilsM.objInArr(nagl.nazwadok, OUZnaglM.SKROTY_ZAMOWIEN);
        this.dParams.uwagi = nagl.uwagi;
        this.dParams.cecha1 = nagl.cecha1;
        this.dParams.cecha2 = nagl.cecha2;
        this.dParams.cecha3 = nagl.cecha3;
        this.ustawDokInfo(nagl);
        this.setFontSize(fSize);
        if (this.jakoPrzyjecie) {
            this.pozwolDodawacKartoteki = conf.dodawKart;
        }
    }

    private NaglM edytujDokumentNaPodstawie() {
        this.setupOuzNaPodst();
        this.reloadRecords();
        if (this.positions == null) {
            return null;
        }
        this.dParams.akcja = -1;
        boolean zakoncz = this.sprawdzWszystkiePozycje(this.jakoPrzyjecie);
        if (zakoncz) {
            return null;
        }
        if (!this.czyPaletaPoprawnieWybrana()) {
            return null;
        }
        this.runUI((Control)this.skanujTxt);
        if (this.isDisposed()) {
            return null;
        }
        if (this.dParams.akcja == 6) {
            return this.dParams.noweZamowienie;
        }
        return null;
    }

    private boolean czyPaletaPoprawnieWybrana() {
        Paleta paleta;
        if (!this.czyPaletowanie()) {
            return true;
        }
        while (true) {
            if ((paleta = PrzegladyUtils.wybierzPalateKontrahenta(this.containerCo, this.nagl)) == null) {
                return false;
            }
            if (1 == paleta.status || paleta.isSpecial()) break;
            SwtCommon.alert(this.getShell(), "Niepoprawny status palety.");
        }
        Common.getPaletaClient().powiazPaleteZUrzZewNagl(paleta.id_xxx_paleta, this.nagl.id);
        this.aktualnaPaleta = paleta;
        return true;
    }

    protected void customizeMoreDialogParams(DialogParams params) {
        if (this.czyPaletowanie()) {
            if (this.moreDialogOptions == null) {
                this.moreDialogOptions = new ActionMatrix();
                this.moreDialogOptions.setHasReturnAction(true);
                this.moreDialogOptions.addRowAction(new ActionDesc("Nowa paleta", new SimpleCallback(){

                    public void call() {
                        if (SwtCommon.confirm(PozycjeOuzCNewer.this.getShell(), "Czy utworzyc palet\u0119?") == 64) {
                            if (PozycjeOuzCNewer.this.aktualnaPaleta != null) {
                                Common.getPaletaClient().zmienStatusPalety(((PozycjeOuzCNewer)PozycjeOuzCNewer.this).aktualnaPaleta.id_xxx_paleta, 2);
                            }
                            PozycjeOuzCNewer.this.aktualnaPaleta = PaletaUtils.utworzNowaPaleta(((PozycjeOuzCNewer)PozycjeOuzCNewer.this).nagl.nrKontrah, ((PozycjeOuzCNewer)PozycjeOuzCNewer.this).nagl.id);
                            PozycjeOuzCNewer.this.moreDialogOptions.closeOwnerComposite();
                        }
                    }
                }));
                this.moreDialogOptions.addRowAction(new ActionDesc("Zmie\u0144 palet\u0119", new SimpleCallback(){

                    public void call() {
                        Paleta paleta = PrzegladyUtils.wybierzPalateKontrahenta(PozycjeOuzCNewer.this.containerCo, PozycjeOuzCNewer.this.nagl);
                        if (paleta != null) {
                            PozycjeOuzCNewer.this.aktualnaPaleta = paleta;
                            Common.getPaletaClient().powiazPaleteZUrzZewNagl(paleta.id_xxx_paleta, ((PozycjeOuzCNewer)PozycjeOuzCNewer.this).nagl.id);
                        }
                    }
                }));
                this.moreDialogOptions.addRowAction(new ActionDesc("Wzn\u00f3w wydruk", new SimpleCallback(){

                    public void call() {
                        if (PozycjeOuzCNewer.this.aktualnaPaleta == null) {
                            SwtCommon.alert(PozycjeOuzCNewer.this.getShell(), "Zadna z palet nie jest wybrana.");
                        } else {
                            PaletaUtils.drukujEtykietePalety(PozycjeOuzCNewer.this.aktualnaPaleta);
                        }
                    }
                }));
                this.moreDialogOptions.reassignShortcuts(null);
            }
            params.extraActions = this.moreDialogOptions;
        }
    }

    protected String getPropertyFileName() {
        String baseName = super.getPropertyFileName();
        if (this.czyNaPodstawie()) {
            return baseName + "_Np";
        }
        return baseName;
    }

    void setupOuzNaPodst() {
        this.dParams.moznaUsuwac = false;
        this.dParams.moznaUkrywac = true;
        this.dParams.moznaUwagi = true;
        this.dParams.moznaCechy = true;
        this.dParams.ukryjPozycjeOk = true;
        this.dParams.dodajInneZamowienie = true;
        this.dokOnInfo.setText(this.nagl.dot_nazwadok + " " + this.nagl.dot_nrdok);
    }

    private void ustawDokInfo(OUZnaglM nagl) {
        if (nagl.nazwadok.equals("MM-")) {
            this.dokInfo.setText(nagl.nazwadok + " " + nagl.nrdok + " m:" + nagl.magazyn);
        } else if (nagl.nazwadok.equals("RW") || nagl.nazwadok.equals("ZAWEW") || nagl.nazwadok.equals("PW")) {
            this.dokInfo.setText(nagl.nazwadok + " " + nagl.nrdok);
        } else {
            this.dokInfo.setText(nagl.nazwadok + " " + nagl.nrdok + " k:" + nagl.kontrah);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void obslugaWpisania(String eanWpisany, Double iloscWazona, Towar sz) {
        String errorMessage;
        double iloscWpisana;
        OUZpozM poz;
        String res;
        if (this.conf.procPrzedPoz && (res = this.WPR.przedDodaniemPoz(sz.id, this.nagl.id)) != null && res.length() > 0) {
            if (this.conf.hklMode) {
                while (this.getDisplay().readAndDispatch()) {
                }
                ProgressC p = ProgressC.showProgress(this.containerCo, " !!! " + res + "  !!! ");
                Toolkit.getDefaultToolkit().beep();
                UtilsM.sleep(3000);
                p.close();
            } else {
                SwtCommon.alert(this.getShell(), res);
            }
        }
        OUZpozM selectedPoz = this.szukajPozycji(sz);
        if (this.czyNaPodstawie()) {
            if (selectedPoz == null) {
                if (!this.conf.naPodstSpoza) {
                    SwtCommon.alert(this.getShell(), "na zamowieniu brak kartoteki " + sz.indeks + ", nie mog\u0119 doda\u0107!");
                    return;
                }
                int ret = SwtCommon.confirm(this.getShell(), "na zamowieniu brak kartoteki " + sz.indeks + ", czy chcesz doda\u0107?");
                if (ret != 64) {
                    return;
                }
            } else {
                OUZpozM zrealizowanaPoz = selectedPoz;
                selectedPoz = this.szukajPozycjiDoRealizacji(sz);
                if (selectedPoz == null) {
                    int ret = SwtCommon.confirm(this.getShell(), "pozycja " + sz.indeks + " juz zrealizowana. Czy edytowa\u0107 mimo to?");
                    if (ret != 64) {
                        return;
                    }
                    selectedPoz = zrealizowanaPoz;
                }
            }
        }
        OpakKartM opakowanieWpisanegoEan = this.eanZopakowania(eanWpisany, sz);
        StanKartMskl[] stany = this.sprClient.getStanyMskl(sz.id);
        if (this.czyNaPodstawie() && selectedPoz != null) {
            this.obslugaWpisaniaNaPodstawie(selectedPoz, opakowanieWpisanegoEan, stany, iloscWazona, EditMode.INSERT);
            return;
        }
        if (!this.sprawdzBlokady(sz, this.jakoPrzyjecie, Common.magClientConf, null)) {
            return;
        }
        if (!this.jakoPrzyjecie && this.conf.rozchodWgDostaw && selectedPoz == null) {
            selectedPoz = null;
        } else if (selectedPoz != null) {
            if (this.conf.zbijaniePoz == 1) {
                selectedPoz = null;
            } else if (this.conf.zbijaniePoz == 2 && !SwtCommon.confirmed(this.getShell(), "Istnieje pozycja z kartotek\u0105.\nCzy dopisa\u0107 do niej?")) {
                selectedPoz = null;
            }
        }
        if (selectedPoz == null) {
            poz = new OUZpozM();
            poz.dtWazn = null;
            poz.kodtow = sz.indeks;
            poz.sz = sz;
            if (this.conf.autoNrDost) {
                poz.nrPartii = "<auto>";
            }
        } else {
            poz = selectedPoz;
        }
        if (iloscWazona == null) {
            iloscWazona = new Double(0.0);
        }
        if (!this.jakoZamowienie && !this.jakoPrzyjecie && this.conf.rozchodWgDostaw) {
            Dostawa d = this.wybierzDostawe2(sz, iloscWazona, poz);
            if (d == null) {
                return;
            }
            this.sprawdzDostaweNaPozycjach(d);
            poz.idDost = d.id;
            WpiszIloscC iloscComposite = new WpiszIloscC(this.containerCo, EditMode.EDIT, this.conf, this.nagl, poz);
            try {
                iloscComposite.wpisz(sz, null, this.jakoPrzyjecie, stany, iloscWazona == null ? new Double(0.0) : iloscWazona, this.jakoZamowienie);
                if (!iloscComposite.dialogConfirmed()) return;
                iloscWpisana = iloscComposite.getResultIlosc();
                poz.ustawMiejsceSkladowania(iloscComposite.getResultMiejsceSkladowania());
            }
            finally {
                SwtCommon.safeDispose(iloscComposite);
            }
        }
        WpiszIloscC iloscComposite = new WpiszIloscC(this.containerCo, EditMode.INSERT, this.conf, this.nagl, poz);
        try {
            iloscComposite.wpisz(sz, opakowanieWpisanegoEan, this.jakoPrzyjecie, stany, iloscWazona, this.jakoZamowienie);
            if (!iloscComposite.dialogConfirmed()) return;
            iloscWpisana = iloscComposite.getResultIlosc();
            poz.ustawMiejsceSkladowania(iloscComposite.getResultMiejsceSkladowania());
        }
        finally {
            SwtCommon.safeDispose(iloscComposite);
        }
        if (this.isDisposed()) {
            return;
        }
        if (selectedPoz == null) {
            this.dodajNowaPozycje(sz, poz, iloscWpisana, true);
            return;
        }
        if (!this.jakoPrzyjecie && !UtilsM.napisPustyLubTylkoSpacje(errorMessage = WprUtils.getStateControlErrorMessage(sz, this.czyNaPodstawie(), poz.ilosc + iloscWpisana))) {
            SwtCommon.alert(this.getShell(), errorMessage);
            return;
        }
        poz.ilosc += iloscWpisana;
        String res2 = this.WPR.aktualizujPozycjeOUZ(poz, this.nagl.id);
        if (res2 != null && res2.startsWith("OK")) {
            this.refreshOrReloadRecords();
            return;
        }
        if (res2 == null) return;
        SwtCommon.alert(this.getShell(), res2);
    }

    private void sprawdzDostaweNaPozycjach(final Dostawa d) {
        Visitor v = new Visitor(){

            public boolean visit(Object item) {
                OUZpozM poz = (OUZpozM)item;
                if (poz.idDost == d.id) {
                    SwtCommon.alert(PozycjeOuzCNewer.this.getShell(), "dostawa " + d.nrDost + " juz istnieje na dokumencie");
                    return false;
                }
                return true;
            }
        };
        this.positions.visitAll(v);
    }

    private void dodajNowaPozycje(Towar szczegoly, OUZpozM poz, double iloscWpisana, boolean zakup) {
        String errorMessage;
        poz.ilosc = iloscWpisana;
        if (!this.jakoPrzyjecie && !UtilsM.napisPustyLubTylkoSpacje(errorMessage = WprUtils.getStateControlErrorMessage(szczegoly, this.czyNaPodstawie(), poz.ilosc))) {
            SwtCommon.alert(this.getShell(), errorMessage);
            return;
        }
        OUZpozM dodanaPoz = this.WPR.dodajPozycjeOUZ(this.nagl.id, poz, zakup);
        if (dodanaPoz == null) {
            return;
        }
        poz.id = dodanaPoz.id;
        poz.lp = dodanaPoz.lp;
        poz.sz = szczegoly;
        this.positions.addItem(poz);
        this.initPositions.addItem(poz);
        this.refreshOrReloadRecords();
    }

    private OUZpozM szukajPozycji(final Towar szczegoly) {
        Matcher matcher = new Matcher(){

            public boolean matches(Object item) {
                OUZpozM poz = (OUZpozM)item;
                return poz.kodtow.equals(szczegoly.indeks);
            }
        };
        return this.szukajPozycjiWedlugMatchera(matcher);
    }

    private OUZpozM szukajPozycjiDoRealizacji(final Towar szczegoly) {
        Matcher matcher = new Matcher(){

            public boolean matches(Object item) {
                OUZpozM poz = (OUZpozM)item;
                return poz.kodtow.equals(szczegoly.indeks) && poz.ilosc < poz.iloscZam;
            }
        };
        return this.szukajPozycjiWedlugMatchera(matcher);
    }

    private OUZpozM szukajPozycjiWedlugMatchera(Matcher matcher) {
        Object matchedPoz = this.positions.findFirstMatched(matcher);
        if (matchedPoz == null) {
            matchedPoz = this.initPositions.findFirstMatched(matcher);
        }
        return (OUZpozM)matchedPoz;
    }

    protected OUZpozM getPositionByIdPoz(int id_poz) {
        int posCount = this.positions.getRecordCount();
        for (int index = 0; index < posCount; ++index) {
            OUZpozM tested = (OUZpozM)this.positions.getItem(index);
            if (tested.id != id_poz) continue;
            return tested;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void obslugaEtykiety(KodEan128Result res2) {
        PozycjeCNewer.Ean128DataDesc daneZEtykiety = this.podajDaneZEtykiety(res2);
        if (daneZEtykiety == null) {
            return;
        }
        if (!UtilsM.napisPustyLubTylkoSpacje(daneZEtykiety.errorDesc)) {
            SwtCommon.alert(this.getShell(), daneZEtykiety.errorDesc);
            return;
        }
        if (!this.czyNaPodstawie()) {
            this.obslugaEtykietyBezPodstawy(res2, daneZEtykiety.towar, daneZEtykiety.dostawa);
            return;
        }
        OUZpozM p = this.szukajPozycji(daneZEtykiety.towar);
        if (p == null) {
            SwtCommon.alert(this.getShell(), "brak pozycji na dokumencie");
            return;
        }
        if (this.conf.rozchodWgDostaw) {
            Rezerwacja[] rezerwacje = this.WPR.pobierzRezerwacjePozzam(p.id, p.idPozZam);
            double sumaRez = this.sumaRezerwacji(rezerwacje);
            if (sumaRez == p.iloscZam && !this.conf.podpowiedzIloscZEtykietyDlaWydanNapodstawieWgDostaw) {
                SwtCommon.alert(this.getShell(), "juz wszystko wydano/zarezerwowano");
                return;
            }
            double proponowanaIlosc = p.iloscZam - sumaRez;
            if (this.conf.podpowiedzIloscZEtykietyDlaWydanNapodstawieWgDostaw) {
                proponowanaIlosc = res2.ilosc_na_pal;
            }
            if (!res2.containsNrPartii()) {
                this.wybierajDostawy(p, proponowanaIlosc, daneZEtykiety.towar);
            } else {
                double sumaRez1;
                Dostawa[] dd = this.sprClient.pobierzDostawy(daneZEtykiety.towar.id);
                Dostawa d = PozycjeOuzCNewer.znajdzDostawe(dd, res2.partia);
                if (d == null) {
                    SwtCommon.alert(this.getShell(), "nie znaleziono dostawy o numerze " + res2.partia);
                    return;
                }
                this.sprawdzDostaweNaPozycjach(d);
                double iloscZdostawy = 0.0;
                WpiszIloscC iloscComposite = new WpiszIloscC(this.containerCo, EditMode.INSERT, this.conf, this.nagl, p);
                try {
                    iloscComposite.wpisz(p.sz, null, this.jakoPrzyjecie, null, new Double(proponowanaIlosc), this.jakoZamowienie);
                    if (!iloscComposite.dialogConfirmed()) {
                        return;
                    }
                    iloscZdostawy = iloscComposite.getResultIlosc();
                }
                finally {
                    SwtCommon.safeDispose(iloscComposite);
                }
                StatMsgVal res1 = this.zarezerwujDostawe(p, d, iloscZdostawy);
                if (res1 == null) {
                    return;
                }
                Rezerwacja[] rezerwacje1 = this.WPR.pobierzRezerwacjePozzam(p.id, p.idPozZam);
                p.ilosc = sumaRez1 = this.sumaRezerwacji(rezerwacje1);
                String res = this.WPR.aktualizujPozycjeOUZ(p, this.nagl.id);
                if (res == null || !res.startsWith("OK")) {
                    if (res != null) {
                        SwtCommon.alert(this.getShell(), res);
                    }
                    return;
                }
                this.refreshOrReloadRecords();
                return;
            }
        }
        SwtCommon.alert(this.getShell(), "TODO nie ma wyboru wg dostaw");
    }

    public static Dostawa znajdzDostawe(Dostawa[] dd, String nrPartii) {
        Dostawa d = null;
        for (int i = 0; i < dd.length; ++i) {
            if (!dd[i].nrDost.equals(nrPartii)) continue;
            d = dd[i];
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void obslugaEtykietyBezPodstawy(KodEan128Result res2, Towar szczegoly, Dostawa partia) {
        OUZpozM poz = new OUZpozM();
        poz.dtWazn = null;
        poz.kodtow = szczegoly.indeks;
        poz.sz = szczegoly;
        if (partia != null) {
            poz.idDost = partia.id;
            poz.nrPartii = partia.nrDost;
            poz.iloscZam = partia.ilosc;
        }
        if (this.jakoPrzyjecie || !this.jakoPrzyjecie && !this.conf.rozchodWgDostaw) {
            double resultIlosc = 0.0;
            WpiszIloscC iloscComposite = new WpiszIloscC(this.containerCo, EditMode.INSERT, this.conf, this.nagl, poz);
            try {
                iloscComposite.wpisz(szczegoly, null, this.jakoPrzyjecie, null, new Double(0.0), this.jakoZamowienie);
                if (!iloscComposite.dialogConfirmed()) {
                    return;
                }
                if (this.isDisposed()) {
                    return;
                }
                resultIlosc = iloscComposite.getResultIlosc();
            }
            finally {
                SwtCommon.safeDispose(iloscComposite);
            }
            this.dodajNowaPozycje(szczegoly, poz, resultIlosc, false);
        }
        if (this.conf.rozchodWgDostaw) {
            if (res2.partia == null) {
                this.wybierajDostawy(poz, 0.0, szczegoly);
            } else {
                this.sprawdzDostaweNaPozycjach(partia);
                WpiszIloscC iloscComposite = new WpiszIloscC(this.containerCo, EditMode.INSERT, this.conf, this.nagl, poz);
                iloscComposite.wpisz(szczegoly, null, this.jakoPrzyjecie, null, new Double(res2.ilosc_na_pal), this.jakoZamowienie);
                if (!iloscComposite.dialogConfirmed()) {
                    return;
                }
                double resultIlosc = iloscComposite.getResultIlosc();
                poz.idDost = partia.id;
                this.dodajNowaPozycje(szczegoly, poz, resultIlosc, false);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void obslugaWpisaniaNaPodstawie(OUZpozM editedPoz, OpakKartM opakowanieWpisanegoEan, StanKartMskl[] stany, Double ilosc, EditMode editMode) {
        Towar szczegoly;
        int ret;
        if (editMode.isInsert() && this.jakoPrzyjecie && this.conf.przNowyTermWazn && editedPoz.sz.obsTerminow == 3 && editedPoz.ilosc > 0.0 && (ret = SwtCommon.confirm(this.getShell(), "pozycja ju\u017c wpisana z terminem " + editedPoz.dtWazn + ", czy chcesz wprowadzi\u0107 nowy termin wa\u017cnosci?")) == 64) {
            Integer idPoz2 = this.WPR.dodajNowyTerminWazn(editedPoz.id, this.nagl.id);
            System.out.println("idPoz2 " + idPoz2);
            this.reloadRecords();
            OUZpozM refreshedPoz = this.getPositionByIdPoz(idPoz2);
            if (refreshedPoz != null) {
                editedPoz = refreshedPoz;
            }
        }
        if (!this.sprawdzBlokady(szczegoly = (editedPoz.sz = this.sprClient.szczegolyTowaruMag(editedPoz.sz.id, editedPoz.idMagZam)), this.jakoPrzyjecie, Common.magClientConf, null)) {
            return;
        }
        if (this.conf.rozchodWgDostaw && !this.jakoPrzyjecie) {
            Rezerwacja[] rezerwacje = this.WPR.pobierzRezerwacjePozzam(editedPoz.id, editedPoz.idPozZam);
            double sumaRez = this.sumaRezerwacji(rezerwacje);
            if (sumaRez >= editedPoz.iloscZam) {
                SwtCommon.alert(this.getShell(), "juz wszystko wydano/zarezerwowano");
                return;
            }
            this.wybierajDostawy(editedPoz, editedPoz.iloscZam - sumaRez, szczegoly);
            if (this.isDisposed()) {
                return;
            }
        } else {
            String errorMessage;
            double iloscWpisana = 0.0;
            WpiszIloscC iloscComposite = new WpiszIloscC(this.containerCo, editMode, this.conf, this.nagl, editedPoz);
            try {
                iloscComposite.wpisz(szczegoly, opakowanieWpisanegoEan, this.jakoPrzyjecie, stany, ilosc, this.jakoZamowienie);
                if (!iloscComposite.dialogConfirmed()) {
                    return;
                }
                iloscWpisana = iloscComposite.getResultIlosc();
                if (this.isDisposed()) {
                    return;
                }
            }
            finally {
                SwtCommon.safeDispose(iloscComposite);
            }
            if (!this.jakoPrzyjecie && !UtilsM.napisPustyLubTylkoSpacje(errorMessage = WprUtils.getStateControlErrorMessage(szczegoly, this.czyNaPodstawie(), iloscWpisana))) {
                SwtCommon.alert(this.getShell(), errorMessage);
                return;
            }
            editedPoz.ilosc = editMode.isEdit() ? iloscWpisana : (editedPoz.ilosc += iloscWpisana);
        }
        String res = this.WPR.aktualizujPozycjeOUZ(editedPoz, this.nagl.id);
        if (res == null || !res.startsWith("OK")) {
            if (res != null) {
                SwtCommon.alert(this.getShell(), res);
            }
            return;
        }
        this.refreshOrReloadRecords();
        this.sprawdzWszystkiePozycje(this.jakoPrzyjecie);
    }

    private double sumaRezerwacji(Rezerwacja[] rezerwacje) {
        double suma = 0.0;
        for (int i = 0; i < rezerwacje.length; ++i) {
            suma += rezerwacje[i].ilosc;
        }
        return suma;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void wybierajDostawy(OUZpozM p, double doWydania, Towar szczegoly) {
        double sumaRez;
        Dostawa d = this.wybierzDostawe2(szczegoly, doWydania, p);
        if (d == null) {
            return;
        }
        this.sprawdzDostaweNaPozycjach(d);
        double iloscZdostawy = 0.0;
        WpiszIloscC iloscComposite = new WpiszIloscC(this.containerCo, EditMode.INSERT, this.conf, this.nagl, p);
        try {
            iloscComposite.wpisz(p.sz, null, this.jakoPrzyjecie, null, new Double(doWydania), this.jakoZamowienie);
            if (!iloscComposite.dialogConfirmed()) {
                return;
            }
            iloscZdostawy = iloscComposite.getResultIlosc();
            if (this.isDisposed()) {
                return;
            }
        }
        finally {
            SwtCommon.safeDispose(iloscComposite);
        }
        if (!this.conf.wyddostPozwolWiecej && iloscZdostawy > doWydania) {
            SwtCommon.alert(this.getShell(), "nie mog\u0119 wyda\u0107 wi\u0119cej!!!");
            return;
        }
        StatMsgVal res = this.zarezerwujDostawe(p, d, iloscZdostawy);
        if (res == null) {
            return;
        }
        Rezerwacja[] rezerwacje = this.WPR.pobierzRezerwacjePozzam(p.id, p.idPozZam);
        p.ilosc = sumaRez = this.sumaRezerwacji(rezerwacje);
        double jeszczeDoWydania = p.iloscZam - sumaRez;
        if (jeszczeDoWydania > 0.0) {
            this.wybierajDostawy(p, jeszczeDoWydania, szczegoly);
        }
    }

    private StatMsgVal zarezerwujDostawe(OUZpozM p, Dostawa d, double iloscZdostawy) {
        StatMsgVal res = this.WPR.zarezerwujDostawe(p.id, p.idPozZam, d.id, iloscZdostawy);
        if (res == null) {
            return null;
        }
        if (res.msg != null && res.msg.length() > 0) {
            SwtCommon.alert(this.getShell(), res.msg);
        }
        if (res.val != 0.0) {
            p.iloscZam += res.val;
            this.refreshOrReloadRecords();
        }
        return res;
    }

    private Dostawa wybierzDostawe2(Towar szczegoly, double iloscDoWydania, OUZpozM poz) {
        Dostawa[] dd = Common.getSprClient().pobierzDostawyMag(szczegoly.id, poz.idMagZam);
        if (dd == null) {
            return null;
        }
        if (dd.length == 0) {
            SwtCommon.alert(this.getShell(), "!!! brak dostaw na kartotece " + szczegoly.indeks);
            return null;
        }
        String caption = "Wydaj " + (iloscDoWydania > 0.0 ? Double.toString(iloscDoWydania) : "") + " z dostaw " + szczegoly.indeks;
        return PrzegladyUtils.wybierzDostawe(this.containerCo, dd, caption);
    }

    protected boolean czyPozycjaPoprawnieWydana(OUZpozM poz) {
        boolean isZero = UtilsM.eq2Digits(poz.ilosc, 0.0);
        if (this.conf.ukryjZrealizowaneWWiekszejIlosci && !isZero) {
            return poz.ilosc + (double)this.conf.ukrywanieAkceptowanaRoznica / 100.0 >= poz.iloscZam;
        }
        if (this.conf.ukrywanieAkceptowanaRoznica > 0 && !isZero) {
            double diff = poz.iloscZam - poz.ilosc;
            if (diff < 0.0) {
                diff = -diff;
            }
            return diff <= (double)this.conf.ukrywanieAkceptowanaRoznica / 100.0;
        }
        return poz.ilosc == poz.iloscZam;
    }

    private boolean sprawdzWszystkiePozycje(boolean jakoPrzyjecie) {
        IssuedVisitor issuedVisitor = new IssuedVisitor();
        this.positions.visitAll(issuedVisitor);
        boolean wszystkie_ok = issuedVisitor.cnd;
        if (wszystkie_ok) {
            String wydanePrzyjete = this.nagl.nazwadok.equals("WZ") ? "wydane" : "przyj\u0119te";
            int ret = SwtCommon.confirm(this.getShell(), "Wszystkie pozycje zam\u00f3wienia zosta\u0142y " + wydanePrzyjete + "\n" + "\n" + "Czy chcesz zatwierdzi\u0107 dokument?");
            if (ret != 64) {
                return false;
            }
            this.zatwierdzBtnWS(false);
            String res = this.zatwierdzRetry();
            if (res == null) {
                return false;
            }
            this.zakonczUI = true;
            return true;
        }
        return false;
    }

    protected void zapiszUwagiCechy(DialogParams params) {
        if (this.nagl.uwagi != null && this.nagl.uwagi.equals(params.uwagi) && this.nagl.cecha1.equals(params.cecha1) && this.nagl.cecha2.equals(params.cecha2) && this.nagl.cecha3.equals(params.cecha3)) {
            return;
        }
        String res = this.WPR.zapiszUwagiCechyDok(this.nagl.id, params.uwagi, params.cecha1, params.cecha2, params.cecha3);
        if (!"OK".equals(res)) {
            SwtCommon.alert(this.getShell(), res);
        }
        this.refreshOrReloadRecords();
    }

    protected void dodajInneZamowienie() {
        this.dParams.akcja = 6;
        this.zakonczUI = true;
    }

    private class IssuedVisitor
    implements Visitor {
        public boolean cnd = true;

        private IssuedVisitor() {
        }

        public boolean visit(Object item) {
            if (!PozycjeOuzCNewer.this.czyPozycjaPoprawnieWydana((OUZpozM)item)) {
                this.cnd = false;
                return false;
            }
            return true;
        }
    }

    class OuzPozMap2Checkbox {
        private Map map = new HashMap();

        OuzPozMap2Checkbox() {
        }

        public Button findButtonForOuzPoz(OUZnaglM poz) {
            return (Button)this.map.get(poz);
        }
    }

    private static class nazwaSkrGetter
    implements StringDataGetter {
        private nazwaSkrGetter() {
        }

        public String getData(Object record) {
            return ((OUZpozM)record).sz.nazwaSkr;
        }
    }

    private static class nazwaDlGetter
    implements StringDataGetter {
        private nazwaDlGetter() {
        }

        public String getData(Object record) {
            return ((OUZpozM)record).sz.nazwaDl;
        }
    }

    private class FilteredPosCopier
    implements Visitor {
        public OUZpozM[] destArray;
        public int destIndex;

        private FilteredPosCopier() {
        }

        public boolean visit(Object item) {
            OUZpozM p = (OUZpozM)item;
            if (!PozycjeOuzCNewer.this.czyPozycjaDoOdfiltrowania(p)) {
                this.destArray[this.destIndex] = p;
                ++this.destIndex;
            }
            return true;
        }
    }

    private class FilteredPosCounter
    implements Visitor {
        int count = 0;

        private FilteredPosCounter() {
        }

        public boolean visit(Object item) {
            OUZpozM p = (OUZpozM)item;
            if (PozycjeOuzCNewer.this.czyPozycjaDoOdfiltrowania(p)) {
                ++this.count;
            }
            return true;
        }
    }
}

