/*
 * Decompiled with CFR 0.152.
 */
package ekspert.mobile.wpr;

import base.controls.ExtendedTableItem;
import ekspert.mobile.Common;
import ekspert.mobile.ContC;
import ekspert.mobile.UtilsM;
import ekspert.mobile.common.DialogParams;
import ekspert.mobile.common.EditMode;
import ekspert.mobile.common.PozycjeC;
import ekspert.mobile.common.obj.StanKartMskl;
import ekspert.mobile.common.obj.Towar;
import ekspert.mobile.common.obj.TowarSzukanie;
import ekspert.mobile.common.przeglady.PrzegladyUtils;
import ekspert.mobile.common.spr.SprIF;
import ekspert.mobile.common.wpr.OUZnaglM;
import ekspert.mobile.common.wpr.OUZpozM;
import ekspert.mobile.common.wpr.WprClientConfig;
import ekspert.mobile.common.wpr.WprIF;
import ekspert.mobile.gui.SwtCommon;
import ekspert.mobile.wpr.WpiszIloscC;
import ekspert.mobile.wpr.WprUtils;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TableItem;

public class PozycjeOuzOpakC
extends PozycjeC {
    private static final int KOL_IDURZZEWPOZ = 0;
    private static final int KOL_LP = 1;
    private static final int KOL_INDEKS = 2;
    private static final int KOL_ILOSC = 3;
    private static final int KOL_NAZWASKR = 4;
    private boolean jakoPrzyjecie;
    private OUZnaglM nagl;
    WprIF wpr;
    WprClientConfig conf;
    private WprIF WPR;

    public PozycjeOuzOpakC(ContC parent, boolean kShort) {
        super(parent, kShort);
    }

    protected void listaTableWDS() {
        this.wpisBtnWS();
    }

    protected void wpisBtnWS() {
        String wpisano = this.skanujTxt.getText();
        this.skanujTxt.setText("");
        if (wpisano.length() == 0) {
            int ind = this.listaTable.getSelectionIndex();
            if (ind == -1) {
                return;
            }
            OUZpozM p = (OUZpozM)this.listaTable.getItem(ind).getData();
            this.edytujPozycje(p, ind);
            if (this.isDisposed()) {
                return;
            }
            this.skanujTxt.setFocus();
            this.getShell().setDefaultButton(this.wpisBtn);
            return;
        }
        TowarSzukanie ktory = this.znajdzOpakEan(wpisano);
        if (ktory != null) {
            Towar szczegoly = this.SPR.szczegolyTowaru(ktory.id);
            this.obslugaWpisania(wpisano, -1.0, szczegoly);
        }
        if (this.isDisposed()) {
            return;
        }
        this.skanujTxt.setFocus();
        this.getShell().setDefaultButton(this.wpisBtn);
    }

    private boolean czyNaPodstawie() {
        if (this.cNaPodst == null) {
            return false;
        }
        return this.cNaPodst.isVisible();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void edytujPozycje(OUZpozM p, int ind) {
        String errorMessage;
        TowarSzukanie[] ktore = this.SPR.szukajOpakZwrotIndeksNazwa(p.kodtow);
        if (ktore == null) {
            return;
        }
        if (ktore.length == 0) {
            return;
        }
        Towar szczegoly = this.SPR.szczegolyTowaru(ktore[0].id);
        if (szczegoly == null) {
            return;
        }
        StanKartMskl[] stany = null;
        double nowaIlosc = 0.0;
        WpiszIloscC iloscComposite = new WpiszIloscC(this.containerCo, EditMode.INSERT, this.conf, this.nagl, p);
        try {
            iloscComposite.wpisz(szczegoly, null, this.jakoPrzyjecie, stany, new Double(p.ilosc), false);
            if (!iloscComposite.dialogConfirmed()) {
                return;
            }
            nowaIlosc = iloscComposite.getResultIlosc();
            if (this.isDisposed()) {
                return;
            }
        }
        finally {
            SwtCommon.safeDispose(iloscComposite);
        }
        if (!this.jakoPrzyjecie && !UtilsM.napisPustyLubTylkoSpacje(errorMessage = WprUtils.getStateControlErrorMessage(szczegoly, this.czyNaPodstawie(), nowaIlosc))) {
            SwtCommon.alert(this.getShell(), errorMessage);
            return;
        }
        p.ilosc = nowaIlosc;
        String res = this.WPR.aktualizujPozycjeOUZ(p, this.nagl.id);
        if (res == null || !res.startsWith("OK")) {
            if (res != null) {
                SwtCommon.alert(this.getShell(), res);
            }
            return;
        }
        this.listaTable.getItem(ind).setText(3, UtilsM.formatDoubleIlosc(p.ilosc));
    }

    protected TowarSzukanie znajdzOpakEan(String wpisano) {
        TowarSzukanie ktory;
        TowarSzukanie[] listaTowarow = this.SPR.szukajOpakZwrotEAN(wpisano);
        if (listaTowarow == null) {
            SwtCommon.alert(this.getShell(), "b\u0142\u0105d pobierania listy opakowa\u0144");
            return null;
        }
        if (listaTowarow.length == 0) {
            SwtCommon.alert(this.getShell(), "nie znaleziono indeksu/nazwy.");
            return null;
        }
        if (listaTowarow.length == 1) {
            ktory = listaTowarow[0];
        } else {
            ktory = PrzegladyUtils.wybierzTowar(this.containerCo, listaTowarow, this.getSprConf());
            if (ktory == null || ktory.equals(PrzegladyUtils.TOWAR_POWROC)) {
                return null;
            }
        }
        return ktory;
    }

    protected TowarSzukanie znajdzOpakIndeksNazwa(String wpisano) {
        TowarSzukanie ktory;
        TowarSzukanie[] listaTowarow = this.SPR.szukajOpakZwrotIndeksNazwa(wpisano);
        if (listaTowarow == null) {
            SwtCommon.alert(this.getShell(), "b\u0142\u0105d pobierania listy opakowa\u0144");
            return null;
        }
        if (listaTowarow.length == 0) {
            SwtCommon.alert(this.getShell(), "nie znaleziono indeksu/nazwy.");
            return null;
        }
        if (listaTowarow.length == 1) {
            ktory = listaTowarow[0];
        } else {
            ktory = PrzegladyUtils.wybierzTowar(this.containerCo, listaTowarow, this.getSprConf());
            if (ktory == null || ktory.equals(PrzegladyUtils.TOWAR_POWROC)) {
                return null;
            }
        }
        return ktory;
    }

    protected void szukaj(String fraza) {
        TowarSzukanie ktory = this.znajdzOpakIndeksNazwa(fraza);
        if (this.isDisposed()) {
            return;
        }
        if (ktory == null) {
            return;
        }
        Towar szczegoly = this.SPR.szczegolyTowaru(ktory.id);
        this.obslugaWpisania(fraza, 0.0, szczegoly);
        if (this.isDisposed()) {
            return;
        }
        this.moveAbove(null);
        this.skanujTxt.setFocus();
        this.getShell().setDefaultButton(this.wpisBtn);
    }

    protected void zatwierdzBtnWS() {
        int ret = SwtCommon.confirm(this.getShell(), "Czy chcesz zatwierdzi\u0107 dokument?");
        if (ret != 64) {
            return;
        }
        String res = this.WPR.zatwierdzDokument(this.nagl.id);
        if (res == null) {
            return;
        }
        this.zakonczUI = true;
    }

    protected void usunBtnWS() {
        int ind = this.listaTable.getSelectionIndex();
        if (ind == -1) {
            return;
        }
        TableItem item = this.listaTable.getItem(ind);
        int ret = SwtCommon.confirm(this.getShell(), "Czy chcesz usun\u0105\u0107 pozycj\u0119 " + item.getText(2) + "' ?");
        if (ret != 64) {
            return;
        }
        String id_urzzewpoz = item.getText(0);
        String res = this.WPR.usunPozycjeOUZ(Integer.parseInt(id_urzzewpoz));
        if (res == null) {
            return;
        }
        SwtCommon.info(this.getShell(), "usunalem pozycje " + res);
        this.listaTable.remove(ind);
    }

    protected void przerwijBtnWS() {
        this.zakonczUI = true;
    }

    private void setPozycje(OUZpozM[] listaPoz) {
        this.listaTable.removeAll();
        this.listaTable.getColumn(1).setText("Lp");
        this.listaTable.getColumn(2).setText("Indeks");
        this.listaTable.getColumn(3).setText("Ilo\u015b\u0107");
        this.listaTable.getColumn(4).setText("Nazwa");
        for (int i = 0; i < listaPoz.length; ++i) {
            this.dodajPozycjeDoTabeli(listaPoz[i], i + 1, this.jakoPrzyjecie);
        }
        SwtCommon.ustawAutoSzerokoscKolumn(this.listaTable);
    }

    private void dodajPozycjeDoTabeli(OUZpozM p, int i, boolean jakoPrzyjecie) {
        ExtendedTableItem item = new ExtendedTableItem(this.listaTable, 0);
        item.setText(0, Integer.toString(p.id));
        item.setText(1, Integer.toString(i));
        item.setText(2, p.kodtow);
        item.setText(3, UtilsM.formatDoubleIlosc(p.ilosc));
        item.setText(4, p.sz.nazwaSkr);
        item.setData(p);
    }

    public boolean edytujDokumentOpak(OUZnaglM nagl, OUZpozM[] pozycje, WprClientConfig conf, WprIF wpr, SprIF spr) {
        this.setSprConf(Common.getSprCC());
        this.nagl = nagl;
        this.conf = conf;
        this.WPR = wpr;
        this.SPR = spr;
        this.jakoPrzyjecie = nagl.nazwadok.equals("PZ") || nagl.nazwadok.equals("PW");
        this.dParams.uwagi = nagl.uwagi;
        this.dParams.cecha1 = nagl.cecha1;
        this.dParams.cecha2 = nagl.cecha2;
        this.dParams.cecha3 = nagl.cecha3;
        this.ustawDokInfo(nagl);
        if (this.jakoPrzyjecie) {
            this.pozwolDodawacKartoteki = conf.dodawKart;
        }
        this.ukryjNaPodstawie();
        this.dParams.moznaUkrywac = false;
        this.dParams.moznaUsuwac = true;
        this.dParams.moznaCechy = true;
        this.dParams.moznaUwagi = true;
        this.setPozycje(pozycje);
        this.getShell().setDefaultButton(this.wpisBtn);
        this.runUI((Control)this.skanujTxt);
        if (this.isDisposed()) {
            return false;
        }
        return false;
    }

    private void ustawDokInfo(OUZnaglM nagl) {
        this.dokInfo.setText("opk " + nagl.nrdok + " do " + nagl.nazwadok);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void obslugaWpisania(String wpisane, double iloscWazona, Towar szczegoly) {
        OUZpozM poz;
        int indeks = this.szukajIndeksuWtabelce(szczegoly);
        StanKartMskl[] stany = null;
        if (indeks == -1) {
            poz = new OUZpozM();
            poz.dtWazn = null;
            poz.kodtow = szczegoly.indeks;
            poz.sz = szczegoly;
        } else {
            poz = (OUZpozM)this.listaTable.getItem(indeks).getData();
            if (iloscWazona == -1.0) {
                iloscWazona = 0.0;
            }
        }
        if (!this.sprawdzBlokady(poz.sz, this.jakoPrzyjecie, Common.magClientConf, null)) {
            return;
        }
        double iloscWpisana = 0.0;
        WpiszIloscC iloscComposite = new WpiszIloscC(this.containerCo, EditMode.INSERT, this.conf, this.nagl, poz);
        try {
            iloscComposite.wpisz(szczegoly, null, this.jakoPrzyjecie, stany, new Double(iloscWazona), false);
            if (!iloscComposite.dialogConfirmed()) {
                return;
            }
            iloscWpisana = iloscComposite.getResultIlosc();
            if (this.isDisposed()) {
                return;
            }
        }
        finally {
            SwtCommon.safeDispose(iloscComposite);
        }
        if (indeks == -1) {
            this.dodajNowaPozycje(szczegoly, poz, iloscWpisana, true);
        } else {
            String errorMessage;
            if (!this.jakoPrzyjecie && !UtilsM.napisPustyLubTylkoSpacje(errorMessage = WprUtils.getStateControlErrorMessage(szczegoly, this.czyNaPodstawie(), poz.ilosc + iloscWpisana))) {
                SwtCommon.alert(this.getShell(), errorMessage);
                return;
            }
            poz.ilosc += iloscWpisana;
            String res = this.WPR.aktualizujPozycjeOUZ(poz, this.nagl.id);
            if (res == null || !res.startsWith("OK")) {
                if (res != null) {
                    SwtCommon.alert(this.getShell(), res);
                }
                return;
            }
            this.listaTable.getItem(indeks).setText(3, UtilsM.formatDoubleIlosc(poz.ilosc));
        }
    }

    private void dodajNowaPozycje(Towar szczegoly, OUZpozM poz, double iloscWpisana, boolean zakup) {
        String errorMessage;
        poz.ilosc = iloscWpisana;
        if (!this.jakoPrzyjecie && !UtilsM.napisPustyLubTylkoSpacje(errorMessage = WprUtils.getStateControlErrorMessage(szczegoly, this.czyNaPodstawie(), poz.ilosc))) {
            SwtCommon.alert(this.getShell(), errorMessage);
            return;
        }
        OUZpozM res = this.WPR.dodajPozycjeOUZ(this.nagl.id, poz, zakup);
        if (res == null) {
            return;
        }
        poz.id = res.id;
        poz.lp = res.lp;
        poz.sz = szczegoly;
        this.dodajPozycjeDoTabeli(poz, this.listaTable.getItemCount() + 1, this.jakoPrzyjecie);
        SwtCommon.ustawAutoSzerokoscKolumn(this.listaTable);
    }

    private int szukajIndeksuWtabelce(Towar szczegoly) {
        int indeks = -1;
        for (int i = 0; i < this.listaTable.getItemCount(); ++i) {
            OUZpozM pozZam = (OUZpozM)this.listaTable.getItem(i).getData();
            if (!pozZam.kodtow.equals(szczegoly.indeks)) continue;
            indeks = i;
            break;
        }
        return indeks;
    }

    protected void dodajInneZamowienie() {
    }

    protected void ukryjPozycjeOkBtnWS() {
    }

    protected void zapiszUwagiCechy(DialogParams params) {
    }
}

