/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DNDListener;
import org.eclipse.swt.dnd.DragSourceEffect;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TableDragSourceEffect;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TreeDragSourceEffect;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class DragSource
extends Widget {
    private Control control;
    private Listener controlListener;
    private Transfer[] transferAgents = new Transfer[0];
    private DragSourceEffect dragEffect;
    private static final String DEFAULT_DRAG_SOURCE_EFFECT = "DEFAULT_DRAG_SOURCE_EFFECT";
    static /* synthetic */ Class class$0;

    public DragSource(Control control, int n) {
        super(control, DragSource.checkStyle(n));
        this.control = control;
        if (control.getData("DragSource") != null) {
            DND.error(2000);
        }
        control.setData("DragSource", this);
        this.controlListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 12 && !DragSource.this.isDisposed()) {
                    DragSource.this.dispose();
                }
                if (event.type == 29) {
                    DragSource.this.isDisposed();
                }
            }
        };
        control.addListener(12, this.controlListener);
        control.addListener(29, this.controlListener);
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                DragSource.this.onDispose();
            }
        });
        Object object = control.getData(DEFAULT_DRAG_SOURCE_EFFECT);
        if (object instanceof DragSourceEffect) {
            this.dragEffect = (DragSourceEffect)object;
        } else if (control instanceof Tree) {
            this.dragEffect = new TreeDragSourceEffect((Tree)control);
        } else if (control instanceof Table) {
            this.dragEffect = new TableDragSourceEffect((Table)control);
        }
    }

    public void addDragListener(DragSourceListener dragSourceListener) {
        if (dragSourceListener == null) {
            DND.error(4);
        }
        DNDListener dNDListener = new DNDListener(dragSourceListener);
        dNDListener.dndWidget = this;
        this.addListener(2008, dNDListener);
        this.addListener(2001, dNDListener);
        this.addListener(2000, dNDListener);
    }

    static int checkStyle(int n) {
        if (n == 0) {
            return 2;
        }
        return n;
    }

    protected void checkSubclass() {
        String string;
        String string2 = this.getClass().getName();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.DragSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(string = clazz.getName()).equals(string2)) {
            DND.error(43);
        }
    }

    public Control getControl() {
        return this.control;
    }

    public DragSourceListener[] getDragListeners() {
        Listener[] listenerArray = this.getListeners(2008);
        int n = listenerArray.length;
        DragSourceListener[] dragSourceListenerArray = new DragSourceListener[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            Listener listener = listenerArray[n3];
            if (listener instanceof DNDListener) {
                dragSourceListenerArray[n2] = (DragSourceListener)((DNDListener)listener).getEventListener();
                ++n2;
            }
            ++n3;
        }
        if (n2 == n) {
            return dragSourceListenerArray;
        }
        DragSourceListener[] dragSourceListenerArray2 = new DragSourceListener[n2];
        System.arraycopy(dragSourceListenerArray, 0, dragSourceListenerArray2, 0, n2);
        return dragSourceListenerArray2;
    }

    public DragSourceEffect getDragSourceEffect() {
        return this.dragEffect;
    }

    public Transfer[] getTransfer() {
        return this.transferAgents;
    }

    private void onDispose() {
        if (this.control == null) {
            return;
        }
        if (this.controlListener != null) {
            this.control.removeListener(12, this.controlListener);
            this.control.removeListener(29, this.controlListener);
        }
        this.controlListener = null;
        this.control.setData("DragSource", null);
        this.control = null;
        this.transferAgents = null;
    }

    public void removeDragListener(DragSourceListener dragSourceListener) {
        if (dragSourceListener == null) {
            DND.error(4);
        }
        this.removeListener(2008, dragSourceListener);
        this.removeListener(2001, dragSourceListener);
        this.removeListener(2000, dragSourceListener);
    }

    public void setDragSourceEffect(DragSourceEffect dragSourceEffect) {
        this.dragEffect = dragSourceEffect;
    }

    public void setTransfer(Transfer[] transferArray) {
        this.transferAgents = transferArray;
    }
}

