/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.HDITEM;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TOOLINFO;
import org.eclipse.swt.internal.win32.TVITEM;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.TypedListener;

public class TreeColumn
extends Item {
    Tree parent;
    boolean resizable = true;
    boolean moveable;
    String toolTipText;
    int id;

    public TreeColumn(Tree tree, int n) {
        super(tree, TreeColumn.checkStyle(n));
        this.parent = tree;
        tree.createItem(this, tree.getColumnCount());
    }

    public TreeColumn(Tree tree, int n, int n2) {
        super(tree, TreeColumn.checkStyle(n));
        this.parent = tree;
        tree.createItem(this, n2);
    }

    public void addControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(controlListener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return TreeColumn.checkBits(n, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    public boolean getMoveable() {
        this.checkWidget();
        return this.moveable;
    }

    String getNameText() {
        return this.getText();
    }

    public Tree getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getResizable() {
        this.checkWidget();
        return this.resizable;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public int getWidth() {
        this.checkWidget();
        int n = this.parent.indexOf(this);
        if (n == -1) {
            return 0;
        }
        int n2 = this.parent.hwndHeader;
        if (n2 == 0) {
            return 0;
        }
        HDITEM hDITEM = new HDITEM();
        hDITEM.mask = 1;
        OS.SendMessage(n2, OS.HDM_GETITEM, n, hDITEM);
        return hDITEM.cxy;
    }

    public void pack() {
        int n;
        RECT rECT;
        this.checkWidget();
        int n2 = this.parent.indexOf(this);
        if (n2 == -1) {
            return;
        }
        int n3 = 0;
        int n4 = this.parent.handle;
        int n5 = this.parent.hwndHeader;
        RECT rECT2 = new RECT();
        OS.SendMessage(n5, 4615, n2, rECT2);
        int n6 = OS.GetDC(n4);
        int n7 = 0;
        int n8 = OS.SendMessage(n4, 49, 0, 0);
        if (n8 != 0) {
            n7 = OS.SelectObject(n6, n8);
        }
        TVITEM tVITEM = new TVITEM();
        tVITEM.mask = 28;
        tVITEM.hItem = OS.SendMessage(n4, 4362, 0, 0);
        while (tVITEM.hItem != 0) {
            OS.SendMessage(n4, OS.TVM_GETITEM, 0, tVITEM);
            RECT rECT3 = rECT = tVITEM.lParam != -1 ? this.parent.items[tVITEM.lParam] : null;
            if (rECT != null) {
                Object object;
                int n9;
                n = 0;
                if (this.parent.hooks(41)) {
                    n9 = (tVITEM.state & 2) != 0 ? 2 : 0;
                    object = this.parent.sendMeasureItemEvent((TreeItem)((Object)rECT), n2, n6, n9);
                    if (this.isDisposed() || this.parent.isDisposed()) break;
                    n = ((Event)object).x + ((Event)object).width;
                } else {
                    n9 = ((TreeItem)((Object)rECT)).fontHandle(n2);
                    if (n9 != -1) {
                        n9 = OS.SelectObject(n6, n9);
                    }
                    object = ((TreeItem)((Object)rECT)).getBounds(n2, true, true, false, false, false, n6);
                    if (n9 != -1) {
                        OS.SelectObject(n6, n9);
                    }
                    n = ((RECT)object).right;
                }
                n3 = Math.max(n3, n - rECT2.left);
            }
            tVITEM.hItem = OS.SendMessage(n4, 4362, 6, tVITEM.hItem);
        }
        rECT = new RECT();
        n = 3072;
        TCHAR tCHAR = new TCHAR(this.parent.getCodePage(), this.text, false);
        OS.DrawText(n6, tCHAR, tCHAR.length(), rECT, n);
        int n10 = rECT.right - rECT.left + 12;
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            n10 += 3;
        }
        if (this.image != null || this.parent.sortColumn == this) {
            Image image = null;
            if (this.parent.sortColumn == this && this.parent.sortDirection != 0) {
                if (OS.COMCTL32_MAJOR < 6) {
                    image = this.display.getSortImage(this.parent.sortDirection);
                } else {
                    n10 += 10;
                }
            } else {
                image = this.image;
            }
            if (image != null) {
                Rectangle rectangle = image.getBounds();
                n10 += rectangle.width;
            }
            int n11 = 0;
            n11 = n5 != 0 && OS.COMCTL32_VERSION >= OS.VERSION(5, 80) ? OS.SendMessage(n5, 4629, 0, 0) : OS.GetSystemMetrics(45) * 3;
            n10 += n11 * 2;
        }
        if (n8 != 0) {
            OS.SelectObject(n6, n7);
        }
        OS.ReleaseDC(n4, n6);
        int n12 = this.parent.linesVisible ? 1 : 0;
        this.setWidth(Math.max(n10, n3 + n12));
    }

    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
    }

    void releaseParent() {
        super.releaseParent();
        if (this.parent.sortColumn == this) {
            this.parent.sortColumn = null;
        }
    }

    public void removeControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, controlListener);
        this.eventTable.unhook(11, controlListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setAlignment(int n) {
        this.checkWidget();
        if ((n & 0x1024000) == 0) {
            return;
        }
        int n2 = this.parent.indexOf(this);
        if (n2 == -1 || n2 == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= n & 0x1024000;
        int n3 = this.parent.hwndHeader;
        if (n3 == 0) {
            return;
        }
        HDITEM hDITEM = new HDITEM();
        hDITEM.mask = 4;
        OS.SendMessage(n3, OS.HDM_GETITEM, n2, hDITEM);
        hDITEM.fmt &= 0xFFFFFFFC;
        if ((this.style & 0x4000) == 16384) {
            hDITEM.fmt |= 0;
        }
        if ((this.style & 0x1000000) == 0x1000000) {
            hDITEM.fmt |= 2;
        }
        if ((this.style & 0x20000) == 131072) {
            hDITEM.fmt |= 1;
        }
        OS.SendMessage(n3, OS.HDM_SETITEM, n2, hDITEM);
        if (n2 != 0) {
            int n4 = this.parent.handle;
            this.parent.forceResize();
            RECT rECT = new RECT();
            RECT rECT2 = new RECT();
            OS.GetClientRect(n4, rECT);
            OS.SendMessage(n3, 4615, n2, rECT2);
            rECT.left = rECT2.left;
            rECT.right = rECT2.right;
            OS.InvalidateRect(n4, rECT, true);
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        super.setImage(image);
        if (this.parent.sortColumn != this || this.parent.sortDirection != 0) {
            this.setImage(image, false, false);
        }
    }

    void setImage(Image image, boolean bl, boolean bl2) {
        int n = this.parent.indexOf(this);
        if (n == -1) {
            return;
        }
        int n2 = this.parent.hwndHeader;
        if (n2 == 0) {
            return;
        }
        HDITEM hDITEM = new HDITEM();
        hDITEM.mask = 52;
        OS.SendMessage(n2, OS.HDM_GETITEM, n, hDITEM);
        hDITEM.fmt &= 0xFFFFEFFF;
        if (image != null) {
            if (bl) {
                hDITEM.mask &= 0xFFFFFFDF;
                hDITEM.fmt &= 0xFFFFF7FF;
                hDITEM.fmt |= 0x2000;
                hDITEM.hbm = image.handle;
            } else {
                hDITEM.mask &= 0xFFFFFFEF;
                hDITEM.fmt &= 0xFFFFDFFF;
                hDITEM.fmt |= 0x800;
                hDITEM.iImage = this.parent.imageIndexHeader(image);
            }
            if (bl2) {
                hDITEM.fmt |= 0x1000;
            }
        } else {
            hDITEM.mask &= 0xFFFFFFCF;
            hDITEM.fmt &= 0xFFFFD7FF;
        }
        OS.SendMessage(n2, OS.HDM_SETITEM, n, hDITEM);
    }

    public void setMoveable(boolean bl) {
        this.checkWidget();
        this.moveable = bl;
    }

    public void setResizable(boolean bl) {
        this.checkWidget();
        this.resizable = bl;
    }

    void setSortDirection(int n) {
        if (OS.COMCTL32_MAJOR >= 6) {
            int n2 = this.parent.hwndHeader;
            if (n2 != 0) {
                int n3 = this.parent.indexOf(this);
                if (n3 == -1) {
                    return;
                }
                HDITEM hDITEM = new HDITEM();
                hDITEM.mask = 36;
                OS.SendMessage(n2, OS.HDM_GETITEM, n3, hDITEM);
                switch (n) {
                    case 128: {
                        hDITEM.fmt &= 0xFFFFF5FF;
                        hDITEM.fmt |= 0x400;
                        if (this.image != null) break;
                        hDITEM.mask &= 0xFFFFFFDF;
                        break;
                    }
                    case 1024: {
                        hDITEM.fmt &= 0xFFFFF3FF;
                        hDITEM.fmt |= 0x200;
                        if (this.image != null) break;
                        hDITEM.mask &= 0xFFFFFFDF;
                        break;
                    }
                    case 0: {
                        hDITEM.fmt &= 0xFFFFF9FF;
                        if (this.image != null) {
                            hDITEM.fmt |= 0x800;
                            hDITEM.iImage = this.parent.imageIndexHeader(this.image);
                            break;
                        }
                        hDITEM.fmt &= 0xFFFFF7FF;
                        hDITEM.mask &= 0xFFFFFFDF;
                    }
                }
                OS.SendMessage(n2, OS.HDM_SETITEM, n3, hDITEM);
                if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
                    int n4 = this.parent.handle;
                    this.parent.forceResize();
                    RECT rECT = new RECT();
                    RECT rECT2 = new RECT();
                    OS.GetClientRect(n4, rECT);
                    OS.SendMessage(n2, 4615, n3, rECT2);
                    rECT.left = rECT2.left;
                    rECT.right = rECT2.right;
                    OS.InvalidateRect(n4, rECT, true);
                }
            }
        } else {
            switch (n) {
                case 128: 
                case 1024: {
                    this.setImage(this.display.getSortImage(n), true, true);
                    break;
                }
                case 0: {
                    this.setImage(this.image, false, false);
                }
            }
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        int n = this.parent.indexOf(this);
        if (n == -1) {
            return;
        }
        super.setText(string);
        int n2 = OS.GetProcessHeap();
        TCHAR tCHAR = new TCHAR(this.parent.getCodePage(), this.fixMnemonic(string, true), true);
        int n3 = tCHAR.length() * TCHAR.sizeof;
        int n4 = OS.HeapAlloc(n2, 8, n3);
        OS.MoveMemory(n4, tCHAR, n3);
        int n5 = this.parent.hwndHeader;
        if (n5 == 0) {
            return;
        }
        HDITEM hDITEM = new HDITEM();
        hDITEM.mask = 2;
        hDITEM.pszText = n4;
        int n6 = OS.SendMessage(n5, OS.HDM_SETITEM, n, hDITEM);
        if (n4 != 0) {
            OS.HeapFree(n2, 0, n4);
        }
        if (n6 == 0) {
            this.error(13);
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
        int n = this.parent.headerToolTipHandle;
        if (n == 0) {
            this.parent.createHeaderToolTips();
            this.parent.updateHeaderToolTips();
        }
    }

    public void setWidth(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        int n2 = this.parent.indexOf(this);
        if (n2 == -1) {
            return;
        }
        int n3 = this.parent.hwndHeader;
        if (n3 == 0) {
            return;
        }
        HDITEM hDITEM = new HDITEM();
        hDITEM.mask = 1;
        hDITEM.cxy = n;
        OS.SendMessage(n3, OS.HDM_SETITEM, n2, hDITEM);
        RECT rECT = new RECT();
        OS.SendMessage(n3, 4615, n2, rECT);
        this.parent.forceResize();
        int n4 = this.parent.handle;
        RECT rECT2 = new RECT();
        OS.GetClientRect(n4, rECT2);
        rECT2.left = rECT.left;
        OS.InvalidateRect(n4, rECT2, true);
        this.parent.setScrollWidth();
    }

    void updateToolTip(int n) {
        RECT rECT;
        int n2;
        int n3 = this.parent.headerToolTipHandle;
        if (n3 != 0 && OS.SendMessage(n2 = this.parent.hwndHeader, 4615, n, rECT = new RECT()) != 0) {
            TOOLINFO tOOLINFO = new TOOLINFO();
            tOOLINFO.cbSize = TOOLINFO.sizeof;
            tOOLINFO.hwnd = n2;
            tOOLINFO.uId = this.id;
            tOOLINFO.left = rECT.left;
            tOOLINFO.top = rECT.top;
            tOOLINFO.right = rECT.right;
            tOOLINFO.bottom = rECT.bottom;
            OS.SendMessage(n3, OS.TTM_NEWTOOLRECT, 0, tOOLINFO);
        }
    }
}

